/*
 * このクラスは 'AbstractBlancoFileManagerFileDescDao' の具象クラスとして blanco Framework によって自動生成されました。
 */
package blanco.filemanager.db.dao;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;

import blanco.filemanager.db.query.Sbfm0201Iterator;
import blanco.filemanager.db.query.Sbfm0202Iterator;
import blanco.filemanager.dbaccessor.query.BfmFileDescI01Invoker;
import blanco.filemanager.file.BlancoFileManagerFileDesc;
import blanco.fw.BlancoGeneratedBy;

/**
 */
@BlancoGeneratedBy(name = "Blanco2g")
public class BlancoFileManagerFileDescDao extends AbstractBlancoFileManagerFileDescDao {
    /**
     * 指定されたファイルIDにひもづくすべてのファイル説明を取得します。
     *
     * @param conn
     * @param fileId
     * @return  あればファイルID。なければ -1。
     * @throws SQLException
     */
    public List<blanco.filemanager.file.BlancoFileManagerFileDesc> getFileDescList(Connection conn, int fileId) throws SQLException {
        java.util.List<blanco.filemanager.file.BlancoFileManagerFileDesc> autoValMethodResult;
        // [@BlancoInject] Inject DAO object.
        final Sbfm0202Iterator iteDesc = new Sbfm0202Iterator(conn);
        try {
            autoValMethodResult = super.getFileDescList(conn, iteDesc, fileId);
        } finally {
            // [@BlancoInject] Close DAO object.
            try {
                iteDesc.close();
            } catch (SQLException exIgnore) {
            }
        }
        return autoValMethodResult;
    }

    /**
     * 次のファイル説明IDを採番します。
     *
     * @param conn
     * @return
     * @throws SQLException
     */
    public int getNextFileDescId(Connection conn) throws SQLException {
        int autoValMethodResult;
        // [@BlancoInject] Inject DAO object.
        final Sbfm0201Iterator iteMax = new Sbfm0201Iterator(conn);
        try {
            autoValMethodResult = super.getNextFileDescId(conn, iteMax);
        } finally {
            // [@BlancoInject] Close DAO object.
            try {
                iteMax.close();
            } catch (SQLException exIgnore) {
            }
        }
        return autoValMethodResult;
    }

    /**
     * 新たなデータをINESRTします。
     *
     * @param conn
     * @param fileDesc
     * @param now
     * @throws SQLException
     */
    public void insertFileDesc(Connection conn, BlancoFileManagerFileDesc fileDesc, Date now) throws SQLException {
        // [@BlancoInject] Inject DAO object.
        final BfmFileDescI01Invoker invDesc = new BfmFileDescI01Invoker(conn);
        try {
            super.insertFileDesc(conn, fileDesc, invDesc, now);
        } finally {
            // [@BlancoInject] Close DAO object.
            try {
                invDesc.close();
            } catch (SQLException exIgnore) {
            }
        }
    }
}
