/*
 * このクラスは 'AbstractBlancoFileManagerFileInfoDao' の具象クラスとして blanco Framework によって自動生成されました。
 */
package blanco.filemanager.db.dao;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;

import blanco.filemanager.db.query.Sbfm0101Iterator;
import blanco.filemanager.db.query.Sbfm0102Iterator;
import blanco.filemanager.db.query.Sbfm0103Iterator;
import blanco.filemanager.dbaccessor.query.BfmFileInfoI01Invoker;
import blanco.filemanager.dbaccessor.query.BfmFileInfoS01Iterator;
import blanco.filemanager.dbaccessor.query.BfmFileInfoU01Invoker;
import blanco.filemanager.file.BlancoFileManagerFileInfo;
import blanco.fw.BlancoGeneratedBy;

/**
 */
@BlancoGeneratedBy(name = "Blanco2g")
public class BlancoFileManagerFileInfoDao extends AbstractBlancoFileManagerFileInfoDao {
    /**
     * 指定された条件のファイルがすでに登録されたかどうかを調べます。
     *
     * @param conn
     * @param fileInfo
     * @return  あればファイルID。なければ -1。
     * @throws SQLException
     */
    public int getFileIdIfExists(Connection conn, BlancoFileManagerFileInfo fileInfo) throws SQLException {
        int autoValMethodResult;
        // [@BlancoInject] Inject DAO object.
        final Sbfm0102Iterator iteSearch = new Sbfm0102Iterator(conn);
        try {
            autoValMethodResult = super.getFileIdIfExists(conn, iteSearch, fileInfo);
        } finally {
            // [@BlancoInject] Close DAO object.
            try {
                iteSearch.close();
            } catch (SQLException exIgnore) {
            }
        }
        return autoValMethodResult;
    }

    /**
     * 次のファイルIDを採番します。
     *
     * @param conn
     * @return
     * @throws SQLException
     */
    public int getNextFileId(Connection conn) throws SQLException {
        int autoValMethodResult;
        // [@BlancoInject] Inject DAO object.
        final Sbfm0101Iterator iteMax = new Sbfm0101Iterator(conn);
        try {
            autoValMethodResult = super.getNextFileId(conn, iteMax);
        } finally {
            // [@BlancoInject] Close DAO object.
            try {
                iteMax.close();
            } catch (SQLException exIgnore) {
            }
        }
        return autoValMethodResult;
    }

    /**
     * 新たなデータをINESRTします。子の情報はINSERTしません。別途実施してください。
     *
     * @param conn
     * @param fileInfo
     * @param now
     * @throws SQLException
     */
    public void insertFileInfo(Connection conn, BlancoFileManagerFileInfo fileInfo, Date now) throws SQLException {
        // [@BlancoInject] Inject DAO object.
        final BfmFileInfoI01Invoker invInfo = new BfmFileInfoI01Invoker(conn);
        try {
            super.insertFileInfo(conn, fileInfo, invInfo, now);
        } finally {
            // [@BlancoInject] Close DAO object.
            try {
                invInfo.close();
            } catch (SQLException exIgnore) {
            }
        }
    }

    /**
     * ファイル取り込み時の状況変化に関する最低限の更新(ファイルの変更フラグのみ)を行います。
     *
     * @param conn
     * @param fileInfo
     * @param now
     * @throws SQLException
     */
    public void updateFileInfo(Connection conn, BlancoFileManagerFileInfo fileInfo, Date now) throws SQLException {
        // [@BlancoInject] Inject DAO object.
        final BfmFileInfoU01Invoker invInfo = new BfmFileInfoU01Invoker(conn);
        try {
            super.updateFileInfo(conn, fileInfo, invInfo, now);
        } finally {
            // [@BlancoInject] Close DAO object.
            try {
                invInfo.close();
            } catch (SQLException exIgnore) {
            }
        }
    }

    /**
     * プロジェクトにひもづくすべてのファイル情報をリスト取得します。(このテーブルのみの浅い検索結果取得です)
     *
     * @param conn
     * @param project
     * @return
     * @throws SQLException
     */
    public List<blanco.filemanager.file.BlancoFileManagerFileInfo> getListByProject(Connection conn, String project) throws SQLException {
        java.util.List<blanco.filemanager.file.BlancoFileManagerFileInfo> autoValMethodResult;
        // [@BlancoInject] Inject DAO object.
        final Sbfm0103Iterator iteList = new Sbfm0103Iterator(conn);
        try {
            autoValMethodResult = super.getListByProject(conn, iteList, project);
        } finally {
            // [@BlancoInject] Close DAO object.
            try {
                iteList.close();
            } catch (SQLException exIgnore) {
            }
        }
        return autoValMethodResult;
    }

    /**
     * ファイルIDにより 1件取得します。
     *
     * @param conn
     * @param fileId
     * @return
     * @throws SQLException
     */
    public BlancoFileManagerFileInfo getFileInfo(Connection conn, int fileId) throws SQLException {
        blanco.filemanager.file.BlancoFileManagerFileInfo autoValMethodResult;
        // [@BlancoInject] Inject DAO object.
        final BfmFileInfoS01Iterator ite = new BfmFileInfoS01Iterator(conn);
        try {
            autoValMethodResult = super.getFileInfo(conn, ite, fileId);
        } finally {
            // [@BlancoInject] Close DAO object.
            try {
                ite.close();
            } catch (SQLException exIgnore) {
            }
        }
        return autoValMethodResult;
    }
}
