/*
 * This code is generated by blanco Framework.
 */
package blanco.filemanager.dbaccessor.query;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;

import blanco.filemanager.db.runtime.exception.DeadlockException;
import blanco.filemanager.db.runtime.exception.IntegrityConstraintException;
import blanco.filemanager.db.runtime.exception.NoRowModifiedException;
import blanco.filemanager.db.runtime.exception.TimeoutException;
import blanco.filemanager.db.runtime.exception.TooManyRowsModifiedException;
import blanco.filemanager.db.runtime.util.BlancoDbUtil;
import blanco.fw.BlancoGeneratedBy;

/**
 * [BfmFileAttrInfoI01] 単純な INSERT (QueryInvoker)
 *
 * 実行型SQL文をラッピングして各種アクセサを提供します。<br>
 * シングル属性: 有効 (期待する処理件数は1件)<br>
 */
@BlancoGeneratedBy(name = "blancoDb")
public class BfmFileAttrInfoI01Invoker {
    /**
     * このクラスが内部的に利用するデータベース接続オブジェクト。
     *
     * データベース接続オブジェクトはコンストラクタの引数として外部から与えられます。<br>
     * トランザクションのコミットやロールバックは、このクラスの内部では実行しません。
     */
    protected Connection fConnection;

    /**
     * このクラスが内部的に利用するステートメントオブジェクト。
     *
     * このオブジェクトはデータベース接続オブジェクトから生成されて内部的に利用されます。<br>
     * closeメソッドの呼び出し時に、このオブジェクトのcloseを実行します。
     */
    protected PreparedStatement fStatement;

    /**
     * BfmFileAttrInfoI01Invokerクラスのコンストラクタ。
     *
     * データベースコネクションオブジェクトを引数としてクエリクラスを作成します。<br>
     * このクラスの利用後は、必ず close()メソッドを呼び出す必要があります。<br>
     *
     * @param conn データベース接続
     */
    public BfmFileAttrInfoI01Invoker(final Connection conn) {
        fConnection = conn;
    }

    /**
     * BfmFileAttrInfoI01Invokerクラスのコンストラクタ。
     *
     * データベースコネクションオブジェクトを与えずにクエリクラスを作成します。<br>
     */
    @Deprecated
    public BfmFileAttrInfoI01Invoker() {
    }

    /**
     * BfmFileAttrInfoI01Invokerクラスにデータベース接続を設定。
     *
     * @param conn データベース接続
     */
    @Deprecated
    public void setConnection(final Connection conn) {
        fConnection = conn;
    }

    /**
     * SQL定義書で与えられたSQL文を取得します。
     *
     * SQL入力パラメータとして #キーワードによる指定がある場合には、該当箇所を ? に置き換えた後の SQL文が取得できます。
     *
     * @return JDBCドライバに与えて実行可能な状態のSQL文。
     */
    public String getQuery() {
        return "INSERT\n    INTO\n        BFM_FILE_ATTR_INFO (\n            FILE_ATTR_ID\n            ,FILE_ID\n            ,FILE_SIZE\n            ,FILE_MD5\n            ,FILE_SHA1\n            ,FILE_SHA256\n            ,FILE_ATTR_DT\n            ,VALID_LINE_COUNT\n            ,COMMENT_LINE_COUNT\n            ,BLANK_LINE_COUNT\n            ,MODIFIED_LINE_COUNT\n            ,UPD_DT\n            ,UPD_USER_ID\n        )\n    VALUES (\n        ?\n        ,?\n        ,?\n        ,?\n        ,?\n        ,?\n        ,?\n        ,?\n        ,?\n        ,?\n        ,?\n        ,?\n        ,?\n    )";
    }

    /**
     * SQL定義書から与えられたSQL文をもちいてプリコンパイルを実施します。
     *
     * 内部的にConnection.prepareStatementを呼び出します。<br>
     *
     * @throws SQLException SQL例外が発生した場合。
     */
    public void prepareStatement() throws SQLException {
        close();
        prepareStatement(getQuery());
    }

    /**
     * 与えられたSQL文をもちいてプリコンパイルを実施(動的SQL)します。
     *
     * このメソッドは、動的に内容が変化するような SQL を実行する必要がある場合にのみ利用します。<br>
     * 動的 SQL を利用する必要がある場合には、SQL 定義書で「動的SQL」を「使用する」に変更してください。変更後は外部から利用可能になります。<br>
     * 内部的に JDBC ドライバの Connection.prepareStatement を呼び出します。<br>
     *
     * @param query プリコンパイルを実施させたいSQL文。動的SQLの場合には、この引数には加工された後の実行可能なSQL文を与えます。
     * @throws SQLException SQL例外が発生した場合。
     */
    protected void prepareStatement(final String query) throws SQLException {
        close();
        fStatement = fConnection.prepareStatement(query);
    }

    /**
     * SQL文に与えるSQL入力パラメータをセットします。
     *
     * 内部的には PreparedStatementにSQL入力パラメータをセットします。
     *
     * @param fileAttrId 'fileAttrId'列の値
     * @param fileId 'fileId'列の値
     * @param fileSize 'fileSize'列の値
     * @param fileMd5 'fileMd5'列の値
     * @param fileSha1 'fileSha1'列の値
     * @param fileSha256 'fileSha256'列の値
     * @param fileAttrDt 'fileAttrDt'列の値
     * @param validLineCount 'validLineCount'列の値
     * @param commentLineCount 'commentLineCount'列の値
     * @param blankLineCount 'blankLineCount'列の値
     * @param modifiedLineCount 'modifiedLineCount'列の値
     * @param updDt 'updDt'列の値
     * @param updUserId 'updUserId'列の値
     * @throws SQLException SQL例外が発生した場合。
     */
    public void setInputParameter(final int fileAttrId, final int fileId, final long fileSize, final String fileMd5, final String fileSha1, final String fileSha256, final Date fileAttrDt, final int validLineCount, final int commentLineCount, final int blankLineCount, final Integer modifiedLineCount, final Date updDt, final String updUserId) throws SQLException {
        if (fStatement == null) {
            prepareStatement();
        }
        fStatement.setInt(1, fileAttrId);
        fStatement.setInt(2, fileId);
        fStatement.setLong(3, fileSize);
        fStatement.setString(4, fileMd5);
        fStatement.setString(5, fileSha1);
        fStatement.setString(6, fileSha256);
        if (fileAttrDt == null) {
            fStatement.setNull(7, java.sql.Types.TIMESTAMP);
        } else {
            fStatement.setTimestamp(7, new Timestamp(fileAttrDt.getTime()));
        }
        fStatement.setInt(8, validLineCount);
        fStatement.setInt(9, commentLineCount);
        fStatement.setInt(10, blankLineCount);
        if (modifiedLineCount == null) {
            fStatement.setNull(11, java.sql.Types.INTEGER);
        } else {
            fStatement.setInt(11, modifiedLineCount.intValue());
        }
        if (updDt == null) {
            fStatement.setNull(12, java.sql.Types.TIMESTAMP);
        } else {
            fStatement.setTimestamp(12, new Timestamp(updDt.getTime()));
        }
        fStatement.setString(13, updUserId);
    }

    /**
     * SQL文を実行します。
     *
     * シングル属性が有効なのでスコープをprotectedとします。<br>
     * このメソッドの代わりに executeSingleUpdateメソッドを利用してください。<br>
     *
     * @return 処理された行数
     * @throws IntegrityConstraintException データベース制約違反が発生した場合。
     * @throws DeadlockException データベースデッドロックが発生した場合。
     * @throws TimeoutException データベースタイムアウトが発生した場合。
     * @throws SQLException SQL例外が発生した場合。
     */
    protected int executeUpdate() throws IntegrityConstraintException, DeadlockException, TimeoutException, SQLException {
        if (fStatement == null) {
            // PreparedStatementが未取得の状態なので、PreparedStatement.executeUpdate()実行に先立ちprepareStatement()メソッドを呼び出して取得します。
            prepareStatement();
        }

        try {
            return fStatement.executeUpdate();
        } catch (SQLException ex) {
            throw BlancoDbUtil.convertToBlancoException(ex);
        }
    }

    /**
     * SQL文を実行します。
     *
     * SQL文の実行結果が1行であることを確認します。実行結果が1行以外である場合には例外を発生させます。<br>
     * シングル属性が有効となっているので生成されます。<br>
     *
     * @throws NoRowModifiedException データベースの処理の結果、1行もデータが変更されなかった場合。
     * @throws TooManyRowsModifiedException データベースの処理の結果、1行を超えるデータが変更されてしまった場合。
     * @throws IntegrityConstraintException データベース制約違反が発生した場合。
     * @throws DeadlockException データベースデッドロックが発生した場合。
     * @throws TimeoutException データベースタイムアウトが発生した場合。
     * @throws SQLException SQL例外が発生した場合。
     */
    public void executeSingleUpdate() throws NoRowModifiedException, TooManyRowsModifiedException, IntegrityConstraintException, DeadlockException, TimeoutException, SQLException {
        int result = 0;
        result = executeUpdate();

        if (result == 0) {
            throw new NoRowModifiedException("データベースの処理の結果、1行もデータが変更されませんでした。");
        } else if (result > 1) {
            String message = "データベースの処理の結果、1行を超えるデータが変更されました。変更件数:" + result;
            throw new TooManyRowsModifiedException(message);
        }
    }

    /**
     * ステートメント (java.sql.PreparedStatement) を取得します。
     * @deprecated 基本的にStatementは外部から直接利用する必要はありません。
     *
     * @return 内部的に利用されている java.sql.PreparedStatementオブジェクト
     */
    public PreparedStatement getStatement() {
        return fStatement;
    }

    /**
     * このクラスのクローズ処理をおこないます。
     *
     * 内部的に生成していたJDBCリソースのオブジェクトに対して close()メソッドの呼び出しをおこないます。<br>
     * クラスの利用が終わったら、必ずこのメソッドを呼び出すようにします。
     *
     * @throws SQLException SQL例外が発生した場合。
     */
    public void close() throws SQLException {
        if (fStatement != null) {
            fStatement.close();
            fStatement = null;
        }
    }

    /**
     * finalizeメソッド。
     *
     * このクラスが内部的に生成したオブジェクトのなかで、close()呼び出し忘れバグが存在するかどうかチェックします。<br>
     *
     * @throws Throwable finalize処理の中で発生した例外。
     */
    protected void finalize() throws Throwable {
        super.finalize();
        if (fStatement != null) {
            final String message = "BfmFileAttrInfoI01Invoker : close()メソッドによるリソースの開放が行われていません。";
            System.out.println(message);
        }
    }
}
