/*
 * このソースコードは blanco Frameworkにより自動生成されました。
 */
package blanco.filemanager.task;

import java.io.IOException;

import blanco.filemanager.task.valueobject.BlancoFileManagerExpandZipProcessInput;

/**
 * バッチ処理クラス [BlancoFileManagerExpandZipBatchProcess]。
 *
 * <P>バッチ処理の呼び出し例。</P>
 * <code>
 * java -classpath (クラスパス) blanco.filemanager.task.BlancoFileManagerExpandZipBatchProcess -help
 * </code>
 */
public class BlancoFileManagerExpandZipBatchProcess {
    /**
     * 正常終了。
     */
    public static final int END_SUCCESS = 0;

    /**
     * 入力異常終了。内部的にjava.lang.IllegalArgumentExceptionが発生した場合。
     */
    public static final int END_ILLEGAL_ARGUMENT_EXCEPTION = 7;

    /**
     * 入出力例外終了。内部的にjava.io.IOExceptionが発生した場合。
     */
    public static final int END_IO_EXCEPTION = 8;

    /**
     * 異常終了。バッチの処理開始に失敗した場合、および内部的にjava.lang.Errorまたはjava.lang.RuntimeExceptionが発生した場合。
     */
    public static final int END_ERROR = 9;

    /**
     * コマンドラインから実行された際のエントリポイントです。
     *
     * @param args コンソールから引き継がれた引数。
     */
    public static final void main(final String[] args) {
        final BlancoFileManagerExpandZipBatchProcess batchProcess = new BlancoFileManagerExpandZipBatchProcess();

        // バッチ処理の引数。
        final BlancoFileManagerExpandZipProcessInput input = new BlancoFileManagerExpandZipProcessInput();

        boolean isNeedUsage = false;
        boolean isFieldInputfileProcessed = false;
        boolean isFieldOutputdirProcessed = false;

        // コマンドライン引数の解析をおこないます。
        for (int index = 0; index < args.length; index++) {
            String arg = args[index];
            if (arg.startsWith("-verbose=")) {
                input.setVerbose(Boolean.valueOf(arg.substring(9)).booleanValue());
            } else if (arg.startsWith("-inputfile=")) {
                input.setInputfile(arg.substring(11));
                isFieldInputfileProcessed = true;
            } else if (arg.startsWith("-outputdir=")) {
                input.setOutputdir(arg.substring(11));
                isFieldOutputdirProcessed = true;
            } else if (arg.equals("-?") || arg.equals("-help")) {
                usage();
                System.exit(END_SUCCESS);
            } else {
                System.out.println("BlancoFileManagerExpandZipBatchProcess: 入力パラメータ[" + arg + "]は無視されました。");
                isNeedUsage = true;
            }
        }

        if (isNeedUsage) {
            usage();
        }

        if( isFieldInputfileProcessed == false) {
            System.out.println("BlancoFileManagerExpandZipBatchProcess: 処理開始失敗。入力パラメータ[input]の必須フィールド値[inputfile]に値が設定されていません。");
            System.exit(END_ILLEGAL_ARGUMENT_EXCEPTION);
        }
        if( isFieldOutputdirProcessed == false) {
            System.out.println("BlancoFileManagerExpandZipBatchProcess: 処理開始失敗。入力パラメータ[input]の必須フィールド値[outputdir]に値が設定されていません。");
            System.exit(END_ILLEGAL_ARGUMENT_EXCEPTION);
        }

        int retCode = batchProcess.execute(input);

        // 終了コードを戻します。
        // ※注意：System.exit()を呼び出している点に注意してください。
        System.exit(retCode);
    }

    /**
     * 具体的なバッチ処理内容を記述するためのメソッドです。
     *
     * このメソッドに実際の処理内容を記述します。
     *
     * @param input バッチ処理の入力パラメータ。
     * @return バッチ処理の終了コード。END_SUCCESS, END_ILLEGAL_ARGUMENT_EXCEPTION, END_IO_EXCEPTION, END_ERROR のいずれかの値を戻します。
     * @throws IOException 入出力例外が発生した場合。
     * @throws IllegalArgumentException 入力値に不正が見つかった場合。
     */
    public int process(final BlancoFileManagerExpandZipProcessInput input) throws IOException, IllegalArgumentException {
        // 入力パラメータをチェックします。
        validateInput(input);

        // この箇所でコンパイルエラーが発生する場合、BlancoFileManagerExpandZipProcessインタフェースを実装して blanco.filemanager.taskパッケージに BlancoFileManagerExpandZipProcessImplクラスを作成することにより解決できる場合があります。
        final BlancoFileManagerExpandZipProcess process = new BlancoFileManagerExpandZipProcessImpl();

        // 処理の本体を実行します。
        final int retCode = process.execute(input);

        return retCode;
    }

    /**
     * クラスをインスタンス化してバッチを実行する際のエントリポイントです。
     *
     * このメソッドは下記の仕様を提供します。
     * <ul>
     * <li>メソッドの入力パラメータの内容チェック。
     * <li>IllegalArgumentException, RuntimeException, Errorなどの例外をcatchして戻り値へと変換。
     * </ul>
     *
     * @param input バッチ処理の入力パラメータ。
     * @return バッチ処理の終了コード。END_SUCCESS, END_ILLEGAL_ARGUMENT_EXCEPTION, END_IO_EXCEPTION, END_ERROR のいずれかの値を戻します。
     * @throws IllegalArgumentException 入力値に不正が見つかった場合。
     */
    public final int execute(final BlancoFileManagerExpandZipProcessInput input) throws IllegalArgumentException {
        try {
            // バッチ処理の本体を実行します。
            int retCode = process(input);

            return retCode;
        } catch (IllegalArgumentException ex) {
            System.out.println("BlancoFileManagerExpandZipBatchProcess: 入力例外が発生しました。バッチ処理を中断します。:" + ex.toString());
            // 入力異常終了。
            return END_ILLEGAL_ARGUMENT_EXCEPTION;
        } catch (IOException ex) {
            System.out.println("BlancoFileManagerExpandZipBatchProcess: 入出力例外が発生しました。バッチ処理を中断します。:" + ex.toString());
            // 入力異常終了。
            return END_IO_EXCEPTION;
        } catch (RuntimeException ex) {
            System.out.println("BlancoFileManagerExpandZipBatchProcess: ランタイム例外が発生しました。バッチ処理を中断します。:" + ex.toString());
            ex.printStackTrace();
            // 異常終了。
            return END_ERROR;
        } catch (Error er) {
            System.out.println("BlancoFileManagerExpandZipBatchProcess: ランタイムエラーが発生しました。バッチ処理を中断します。:" + er.toString());
            er.printStackTrace();
            // 異常終了。
            return END_ERROR;
        }
    }

    /**
     * このバッチ処理クラスの使い方の説明を標準出力に示すためのメソッドです。
     */
    public static final void usage() {
        System.out.println("BlancoFileManagerExpandZipBatchProcess: Usage:");
        System.out.println("  java blanco.filemanager.task.BlancoFileManagerExpandZipBatchProcess -verbose=値1 -inputfile=値2 -outputdir=値3");
        System.out.println("    -verbose");
        System.out.println("      説明[verboseモードで動作させるかどうか。]");
        System.out.println("      型[真偽]");
        System.out.println("      デフォルト値[false]");
        System.out.println("    -inputfile");
        System.out.println("      説明[入力ZIPファイルを指定します。]");
        System.out.println("      型[文字列]");
        System.out.println("      必須パラメータ");
        System.out.println("    -outputdir");
        System.out.println("      説明[出力先ディレクトリを指定します。]");
        System.out.println("      型[文字列]");
        System.out.println("      必須パラメータ");
        System.out.println("    -? , -help");
        System.out.println("      説明[使い方を表示します。]");
    }

    /**
     * このバッチ処理クラスの入力パラメータの妥当性チェックを実施するためのメソッドです。
     *
     * @param input バッチ処理の入力パラメータ。
     * @throws IllegalArgumentException 入力値に不正が見つかった場合。
     */
    public void validateInput(final BlancoFileManagerExpandZipProcessInput input) throws IllegalArgumentException {
        if (input == null) {
            throw new IllegalArgumentException("BlancoBatchProcessBatchProcess: 処理開始失敗。入力パラメータ[input]にnullが与えられました。");
        }
        if (input.getInputfile() == null) {
            throw new IllegalArgumentException("BlancoFileManagerExpandZipBatchProcess: 処理開始失敗。入力パラメータ[input]の必須フィールド値[inputfile]に値が設定されていません。");
        }
        if (input.getOutputdir() == null) {
            throw new IllegalArgumentException("BlancoFileManagerExpandZipBatchProcess: 処理開始失敗。入力パラメータ[input]の必須フィールド値[outputdir]に値が設定されていません。");
        }
    }
}
