package blanco.filemanager.core;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;

import blanco.filemanager.db.query.Sbfm0001Invoker;
import blanco.filemanager.db.query.Sbfm0002Invoker;
import blanco.filemanager.db.query.Sbfm0003Invoker;
import blanco.filemanager.db.query.Sbfm0011Invoker;
import blanco.filemanager.db.query.Sbfm0012Invoker;
import blanco.filemanager.db.query.Sbfm0013Invoker;

public class BlancoFileManagerDbCore {
    public static Connection getBatchConnection(final String jdbcdriver, final String jdbcurl, final String jdbcuser,
            final String jdbcpassword) throws SQLException {
        try {
            Class.forName(jdbcdriver);
        } catch (ClassNotFoundException e) {
            throw new SQLException("Fail to load JDBC Driver class: [" + jdbcdriver + "]: " + e.toString(), e);
        }

        final Connection conn = DriverManager.getConnection(jdbcurl, jdbcuser, jdbcpassword);
        conn.setAutoCommit(false);
        return conn;
    }

    public static final boolean createTables(final Connection conn) {
        try {
            final Sbfm0001Invoker inv001 = new Sbfm0001Invoker(conn);
            try {
                inv001.executeUpdate();
            } finally {
                inv001.close();
            }

            final Sbfm0002Invoker inv002 = new Sbfm0002Invoker(conn);
            try {
                inv002.executeUpdate();
            } finally {
                inv002.close();
            }

            final Sbfm0003Invoker inv003 = new Sbfm0003Invoker(conn);
            try {
                inv003.executeUpdate();
            } finally {
                inv003.close();
            }

            return true;
        } catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static final boolean dropTables(final Connection conn) {
        try {
            final Sbfm0011Invoker inv011 = new Sbfm0011Invoker(conn);
            try {
                inv011.executeUpdate();
            } finally {
                inv011.close();
            }

            final Sbfm0012Invoker inv012 = new Sbfm0012Invoker(conn);
            try {
                inv012.executeUpdate();
            } finally {
                inv012.close();
            }

            final Sbfm0013Invoker inv013 = new Sbfm0013Invoker(conn);
            try {
                inv013.executeUpdate();
            } finally {
                inv013.close();
            }

            return true;
        } catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
    }
}
