package blanco.filemanager.core;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

import blanco.commons.util.BlancoStringUtil;

/**
 * ファイルのダイジェストを取得するためのクラスです。
 * 
 * @author Toshiki IGA
 */
public class BlancoFileManagerFileDigestUtil {
    public static String getMD5(final File file) throws IOException {
        return getDigest(file, "MD5");
    }

    public static String getSHA1(final File file) throws IOException {
        return getDigest(file, "SHA1");
    }

    public static String getSHA256(final File file) throws IOException {
        return getDigest(file, "SHA-256");
    }

    public static String getDigest(final File file, final String algorithm) throws IOException {
        try {
            final DigestInputStream inStream = new DigestInputStream(
                    new BufferedInputStream(new FileInputStream(file)), MessageDigest.getInstance(algorithm));
            final byte[] buf = new byte[8192];
            for (;;) {
                if (inStream.read(buf) <= 0) {
                    break;
                }
            }
            inStream.close();

            final MessageDigest md = inStream.getMessageDigest();
            final byte[] digest = md.digest();

            return BlancoStringUtil.toHexString(digest);
        } catch (NoSuchAlgorithmException ex) {
            throw new IOException("NoSuchAlgorithmException: " + ex.toString(), ex);
        }
    }
}
