package blanco.filemanager.task;

import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Date;

import blanco.filemanager.BlancoFileManagerConstats;
import blanco.filemanager.core.BlancoFileManagerDbCore;
import blanco.filemanager.core.BlancoFileManagerFileParser;
import blanco.filemanager.db.dao.BlancoFileManagerFileAttrInfoDao;
import blanco.filemanager.db.dao.BlancoFileManagerFileDescDao;
import blanco.filemanager.db.dao.BlancoFileManagerFileInfoDao;
import blanco.filemanager.file.BlancoFileManagerFileAttrInfo;
import blanco.filemanager.file.BlancoFileManagerFileDesc;
import blanco.filemanager.file.BlancoFileManagerFileInfo;
import blanco.filemanager.task.valueobject.BlancoFileManagerImportProcessInput;

public class BlancoFileManagerImportProcessImpl implements BlancoFileManagerImportProcess {

    @Override
    public int execute(final BlancoFileManagerImportProcessInput input) throws IOException, IllegalArgumentException {
        System.err.println("BlancoFileManagerImportTask (" + BlancoFileManagerConstats.getVersion() + ")");

        final File inputdir = new File(input.getInputdir());
        if (inputdir.exists() == false) {
            System.out.println("指定されたディレクトリ[" + inputdir.getCanonicalPath() + "]が見つかりませんでした。");
            return 9;
        }
        if (inputdir.isDirectory() == false) {
            System.out.println("指定されたディレクトリ[" + inputdir.getCanonicalPath() + "]は実際にはファイルでした。");
            return 9;
        }

        try {
            final Connection conn = BlancoFileManagerDbCore.getBatchConnection(input.getJdbcdriver(),
                    input.getJdbcurl(), input.getJdbcuser(), input.getJdbcpassword());

            final BlancoFileManagerFileParser parser = new BlancoFileManagerFileParser() {
                @Override
                public void fireFileInfo(final BlancoFileManagerFileInfo fileInfo) {
                    // プロジェクト名をここで引き渡してセットします。
                    fileInfo.setProject(input.getProjectname());

                    final Date now = new Date();

                    try {
                        int fileId = new BlancoFileManagerFileInfoDao().getFileIdIfExists(conn, fileInfo);

                        if (fileId < 0) {
                            // 新規の場合。
                            // 新規のファイルです。インポートします。

                            // 新しくファイルIDを採番します。
                            int nextFileId = new BlancoFileManagerFileInfoDao().getNextFileId(conn);
                            fileInfo.setFileId(nextFileId);

                            {
                                final BlancoFileManagerFileDesc desc = new BlancoFileManagerFileDesc();
                                fileInfo.getDescList().add(desc);
                                // ファイルIDやファイル説明IDの設定は後回しです。
                                desc.setFileDesc("ファイル取り込みにより新規登録されました。");
                                desc.setFileDescUsername("system");
                            }

                            // 新しく採番されたファイルIDについて、子テーブルの Bean に伝播させます。
                            for (BlancoFileManagerFileAttrInfo attr : fileInfo.getAttrInfoList()) {
                                attr.setFileId(nextFileId);
                            }
                            for (BlancoFileManagerFileDesc desc : fileInfo.getDescList()) {
                                desc.setFileId(nextFileId);
                            }

                            // 日付も伝播させます。
                            for (BlancoFileManagerFileDesc desc : fileInfo.getDescList()) {
                                desc.setFileDescDt(now);
                            }
                            for (BlancoFileManagerFileAttrInfo attr : fileInfo.getAttrInfoList()) {
                                attr.setFileAttrDt(now);
                            }

                            // これを DB に格納します。
                            // TODO 一意制約違反の例外処理が抜けています。
                            new BlancoFileManagerFileInfoDao().insertFileInfo(conn, fileInfo, now);

                            for (BlancoFileManagerFileDesc desc : fileInfo.getDescList()) {
                                int nextFileDescId = new BlancoFileManagerFileDescDao().getNextFileDescId(conn);
                                desc.setFileDescId(nextFileDescId);
                                // TODO 一意制約違反の例外処理が抜けています。
                                new BlancoFileManagerFileDescDao().insertFileDesc(conn, desc, now);
                            }

                            for (BlancoFileManagerFileAttrInfo attr : fileInfo.getAttrInfoList()) {
                                int nextFileAttrId = new BlancoFileManagerFileAttrInfoDao().getNextFileAttrId(conn);
                                attr.setFileAttrId(nextFileAttrId);
                                // TODO 一意制約違反の例外処理が抜けています。
                                new BlancoFileManagerFileAttrInfoDao().insertFileAttrInfo(conn, attr, now);
                            }
                        } else {
                            // すでに存在するファイル情報の場合。
                            // ファイル属性情報などに変化があるのかどうかチェックします。
                            fileInfo.setFileId(fileId);
                            final BlancoFileManagerFileAttrInfo pastFileAttrinfo = new BlancoFileManagerFileAttrInfoDao()
                                    .getFileAttrInfo(conn, fileInfo.getFileId());
                            final BlancoFileManagerFileAttrInfo newFileAttrinfo = fileInfo.getAttrInfoList().get(
                                    fileInfo.getAttrInfoList().size() - 1);
                            if (pastFileAttrinfo.getFileSha256().equals(newFileAttrinfo.getFileSha256())) {
                                // バイナリレベルにおいてファイルの内容は変化していません。処理スキップします。
                            } else {
                                // バイナリレベルで変化が発生しています。

                                // TODO 無視する行かどうかの判定が必要です。

                                // ファイルを「変更」にセットします。
                                // TODO 2 とかじゃなくて定数化したい。
                                fileInfo.setFileChangeFlg(2);
                                {
                                    final BlancoFileManagerFileDesc desc = new BlancoFileManagerFileDesc();
                                    fileInfo.getDescList().add(desc);
                                    // ファイルIDやファイル説明IDの設定は後回しです。
                                    desc.setFileDesc("ファイルの内容が変化しました。");
                                    desc.setFileDescUsername("system");
                                }

                                // ファイルIDについて、子テーブルの Bean に伝播させます。
                                for (BlancoFileManagerFileAttrInfo attr : fileInfo.getAttrInfoList()) {
                                    attr.setFileId(fileInfo.getFileId());
                                }
                                for (BlancoFileManagerFileDesc desc : fileInfo.getDescList()) {
                                    desc.setFileId(fileInfo.getFileId());
                                }

                                // 日付も伝播させます。
                                for (BlancoFileManagerFileDesc desc : fileInfo.getDescList()) {
                                    desc.setFileDescDt(now);
                                }
                                for (BlancoFileManagerFileAttrInfo attr : fileInfo.getAttrInfoList()) {
                                    attr.setFileAttrDt(now);
                                }

                                // 本体レコードの更新!!!
                                new BlancoFileManagerFileInfoDao().updateFileInfo(conn, fileInfo, now);

                                for (BlancoFileManagerFileDesc desc : fileInfo.getDescList()) {
                                    int nextFileDescId = new BlancoFileManagerFileDescDao().getNextFileDescId(conn);
                                    desc.setFileDescId(nextFileDescId);
                                    // TODO 一意制約違反の例外処理が抜けています。
                                    new BlancoFileManagerFileDescDao().insertFileDesc(conn, desc, now);
                                }

                                for (BlancoFileManagerFileAttrInfo attr : fileInfo.getAttrInfoList()) {
                                    int nextFileAttrId = new BlancoFileManagerFileAttrInfoDao().getNextFileAttrId(conn);
                                    attr.setFileAttrId(nextFileAttrId);
                                    // TODO 一意制約違反の例外処理が抜けています。
                                    new BlancoFileManagerFileAttrInfoDao().insertFileAttrInfo(conn, attr, now);
                                }
                            }

                        }
                    } catch (SQLException e) {
                        // FIXME 一意制約違反をどうするの。そもそもここの例外ってどんなケース?
                        e.printStackTrace();
                    }
                }
            };

            System.out.println("ディレクトリ[" + inputdir.getCanonicalPath() + "]をインポートしてファイル管理します。");
            parser.parseDir(inputdir, inputdir);

            conn.commit();

            // どんなときでもロールバック。
            conn.rollback();
            conn.close();
        } catch (SQLException ex) {
            throw new IOException("処理中にSQL例外が発生:" + ex.toString(), ex);
        }

        return 0;
    }

    @Override
    public boolean progress(String argProgressMessage) {
        return false;
    }
}
