/*
 * This code is generated by blanco Framework.
 */
package blanco.filemanager.db.query;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;

import blanco.filemanager.db.runtime.exception.DeadlockException;
import blanco.filemanager.db.runtime.exception.IntegrityConstraintException;
import blanco.filemanager.db.runtime.exception.TimeoutException;
import blanco.filemanager.db.runtime.util.BlancoDbUtil;
import blanco.fw.BlancoGeneratedBy;

/**
 * [SBFM0002] BFM_FILE_DESC テーブル作成 (QueryInvoker)
 *
 * 実行型SQL文をラッピングして各種アクセサを提供します。<br>
 */
@BlancoGeneratedBy(name = "blancoDb")
public class Sbfm0002Invoker {
    /**
     * このクラスが内部的に利用するデータベース接続オブジェクト。
     *
     * データベース接続オブジェクトはコンストラクタの引数として外部から与えられます。<br>
     * トランザクションのコミットやロールバックは、このクラスの内部では実行しません。
     */
    protected Connection fConnection;

    /**
     * このクラスが内部的に利用するステートメントオブジェクト。
     *
     * このオブジェクトはデータベース接続オブジェクトから生成されて内部的に利用されます。<br>
     * closeメソッドの呼び出し時に、このオブジェクトのcloseを実行します。
     */
    protected PreparedStatement fStatement;

    /**
     * Sbfm0002Invokerクラスのコンストラクタ。
     *
     * データベースコネクションオブジェクトを引数としてクエリクラスを作成します。<br>
     * このクラスの利用後は、必ず close()メソッドを呼び出す必要があります。<br>
     *
     * @param conn データベース接続
     */
    public Sbfm0002Invoker(final Connection conn) {
        fConnection = conn;
    }

    /**
     * Sbfm0002Invokerクラスのコンストラクタ。
     *
     * データベースコネクションオブジェクトを与えずにクエリクラスを作成します。<br>
     */
    @Deprecated
    public Sbfm0002Invoker() {
    }

    /**
     * Sbfm0002Invokerクラスにデータベース接続を設定。
     *
     * @param conn データベース接続
     */
    @Deprecated
    public void setConnection(final Connection conn) {
        fConnection = conn;
    }

    /**
     * SQL定義書で与えられたSQL文を取得します。
     *
     * SQL入力パラメータとして #キーワードによる指定がある場合には、該当箇所を ? に置き換えた後の SQL文が取得できます。
     *
     * @return JDBCドライバに与えて実行可能な状態のSQL文。
     */
    public String getQuery() {
        return "CREATE\n    TABLE\n        BFM_FILE_DESC (\n            FILE_DESC_ID INT NOT NULL\n            ,FILE_ID INT NOT NULL\n            ,FILE_DESC VARCHAR (8192) NOT NULL\n            ,FILE_DESC_DT TIMESTAMP NOT NULL\n            ,FILE_DESC_USERNAME VARCHAR (256) NOT NULL\n            ,UPD_DT TIMESTAMP NOT NULL\n            ,UPD_USER_ID VARCHAR (256) NOT NULL\n            ,PRIMARY KEY (FILE_DESC_ID)\n        )";
    }

    /**
     * SQL定義書から与えられたSQL文をもちいてプリコンパイルを実施します。
     *
     * 内部的にConnection.prepareStatementを呼び出します。<br>
     *
     * @throws SQLException SQL例外が発生した場合。
     */
    public void prepareStatement() throws SQLException {
        close();
        prepareStatement(getQuery());
    }

    /**
     * 与えられたSQL文をもちいてプリコンパイルを実施(動的SQL)します。
     *
     * このメソッドは、動的に内容が変化するような SQL を実行する必要がある場合にのみ利用します。<br>
     * 動的 SQL を利用する必要がある場合には、SQL 定義書で「動的SQL」を「使用する」に変更してください。変更後は外部から利用可能になります。<br>
     * 内部的に JDBC ドライバの Connection.prepareStatement を呼び出します。<br>
     *
     * @param query プリコンパイルを実施させたいSQL文。動的SQLの場合には、この引数には加工された後の実行可能なSQL文を与えます。
     * @throws SQLException SQL例外が発生した場合。
     */
    protected void prepareStatement(final String query) throws SQLException {
        close();
        fStatement = fConnection.prepareStatement(query);
    }

    /**
     * SQL文を実行します。
     *
     * @return 処理された行数
     * @throws IntegrityConstraintException データベース制約違反が発生した場合。
     * @throws DeadlockException データベースデッドロックが発生した場合。
     * @throws TimeoutException データベースタイムアウトが発生した場合。
     * @throws SQLException SQL例外が発生した場合。
     */
    public int executeUpdate() throws IntegrityConstraintException, DeadlockException, TimeoutException, SQLException {
        if (fStatement == null) {
            // PreparedStatementが未取得の状態なので、PreparedStatement.executeUpdate()実行に先立ちprepareStatement()メソッドを呼び出して取得します。
            prepareStatement();
        }

        try {
            return fStatement.executeUpdate();
        } catch (SQLException ex) {
            throw BlancoDbUtil.convertToBlancoException(ex);
        }
    }

    /**
     * ステートメント (java.sql.PreparedStatement) を取得します。
     * @deprecated 基本的にStatementは外部から直接利用する必要はありません。
     *
     * @return 内部的に利用されている java.sql.PreparedStatementオブジェクト
     */
    public PreparedStatement getStatement() {
        return fStatement;
    }

    /**
     * このクラスのクローズ処理をおこないます。
     *
     * 内部的に生成していたJDBCリソースのオブジェクトに対して close()メソッドの呼び出しをおこないます。<br>
     * クラスの利用が終わったら、必ずこのメソッドを呼び出すようにします。
     *
     * @throws SQLException SQL例外が発生した場合。
     */
    public void close() throws SQLException {
        if (fStatement != null) {
            fStatement.close();
            fStatement = null;
        }
    }

    /**
     * finalizeメソッド。
     *
     * このクラスが内部的に生成したオブジェクトのなかで、close()呼び出し忘れバグが存在するかどうかチェックします。<br>
     *
     * @throws Throwable finalize処理の中で発生した例外。
     */
    protected void finalize() throws Throwable {
        super.finalize();
        if (fStatement != null) {
            final String message = "Sbfm0002Invoker : close()メソッドによるリソースの開放が行われていません。";
            System.out.println(message);
        }
    }
}
