/*
 * このソースコードは blanco Frameworkにより自動生成されました。
 */
package blanco.filemanager.task;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

import blanco.filemanager.task.valueobject.BlancoFileManagerDbTableProcessInput;

/**
 * Apache Antタスク [BlancoFileManagerDbTable]のクラス。
 *
 * データベース上に blancoFileManager に関連するテーブルを作成または削除します。<br>
 * このクラスでは、Apache Antタスクで一般的に必要なチェックなどのコーディングを肩代わりします。
 * 実際の処理は パッケージ[blanco.filemanager.task]にBlancoFileManagerDbTableBatchProcessクラスを作成して記述してください。<br>
 * <br>
 * Antタスクへの組み込み例<br>
 * <pre>
 * &lt;taskdef name=&quot;blancofilemanagerdbtable&quot; classname=&quot;blanco.filemanager.task.BlancoFileManagerDbTableTask">
 *     &lt;classpath&gt;
 *         &lt;fileset dir=&quot;lib&quot; includes=&quot;*.jar&quot; /&gt;
 *         &lt;fileset dir=&quot;lib.ant&quot; includes=&quot;*.jar&quot; /&gt;
 *     &lt;/classpath&gt;
 * &lt;/taskdef&gt;
 * </pre>
 */
public class BlancoFileManagerDbTableTask extends Task {
    /**
     * データベース上に blancoFileManager に関連するテーブルを作成または削除します。
     */
    protected BlancoFileManagerDbTableProcessInput fInput = new BlancoFileManagerDbTableProcessInput();

    /**
     * フィールド [create] に値がセットされたかどうか。
     */
    protected boolean fIsFieldCreateProcessed = false;

    /**
     * フィールド [drop] に値がセットされたかどうか。
     */
    protected boolean fIsFieldDropProcessed = false;

    /**
     * フィールド [jdbcdriver] に値がセットされたかどうか。
     */
    protected boolean fIsFieldJdbcdriverProcessed = false;

    /**
     * フィールド [jdbcurl] に値がセットされたかどうか。
     */
    protected boolean fIsFieldJdbcurlProcessed = false;

    /**
     * フィールド [jdbcuser] に値がセットされたかどうか。
     */
    protected boolean fIsFieldJdbcuserProcessed = false;

    /**
     * フィールド [jdbcpassword] に値がセットされたかどうか。
     */
    protected boolean fIsFieldJdbcpasswordProcessed = false;

    /**
     * verboseモードで動作させるかどうか。
     *
     * @param arg verboseモードで動作させるかどうか。
     */
    public void setVerbose(final boolean arg) {
        fInput.setVerbose(arg);
    }

    /**
     * verboseモードで動作させるかどうか。
     *
     * @return verboseモードで動作させるかどうか。
     */
    public boolean getVerbose() {
        return fInput.getVerbose();
    }

    /**
     * Antタスクの[create]アトリビュートのセッターメソッド。
     *
     * 項目番号: 1<br>
     * テーブルを作成する場合にセットします。<br>
     *
     * @param arg セットしたい値
     */
    public void setCreate(final boolean arg) {
        fInput.setCreate(arg);
        fIsFieldCreateProcessed = true;
    }

    /**
     * Antタスクの[create]アトリビュートのゲッターメソッド。
     *
     * 項目番号: 1<br>
     * テーブルを作成する場合にセットします。<br>
     * デフォルト値[true]が設定されています。Apache Antタスク上でアトリビュートの指定が無い場合には、デフォルト値が設定されます。<br>
     *
     * @return このフィールドの値
     */
    public boolean getCreate() {
        return fInput.getCreate();
    }

    /**
     * Antタスクの[drop]アトリビュートのセッターメソッド。
     *
     * 項目番号: 2<br>
     * テーブルを削除する場合にのみセットします。\n★これが true だと情報が削除される点に注意してください。<br>
     *
     * @param arg セットしたい値
     */
    public void setDrop(final boolean arg) {
        fInput.setDrop(arg);
        fIsFieldDropProcessed = true;
    }

    /**
     * Antタスクの[drop]アトリビュートのゲッターメソッド。
     *
     * 項目番号: 2<br>
     * テーブルを削除する場合にのみセットします。\n★これが true だと情報が削除される点に注意してください。<br>
     * デフォルト値[false]が設定されています。Apache Antタスク上でアトリビュートの指定が無い場合には、デフォルト値が設定されます。<br>
     *
     * @return このフィールドの値
     */
    public boolean getDrop() {
        return fInput.getDrop();
    }

    /**
     * Antタスクの[jdbcdriver]アトリビュートのセッターメソッド。
     *
     * 項目番号: 3<br>
     * JDBC ドライバクラス名。\n例: org.apache.derby.jdbc.EmbeddedDriver<br>
     *
     * @param arg セットしたい値
     */
    public void setJdbcdriver(final String arg) {
        fInput.setJdbcdriver(arg);
        fIsFieldJdbcdriverProcessed = true;
    }

    /**
     * Antタスクの[jdbcdriver]アトリビュートのゲッターメソッド。
     *
     * 項目番号: 3<br>
     * JDBC ドライバクラス名。\n例: org.apache.derby.jdbc.EmbeddedDriver<br>
     * 必須アトリビュートです。Apache Antタスク上で必ず値が指定されます。<br>
     *
     * @return このフィールドの値
     */
    public String getJdbcdriver() {
        return fInput.getJdbcdriver();
    }

    /**
     * Antタスクの[jdbcurl]アトリビュートのセッターメソッド。
     *
     * 項目番号: 4<br>
     * JDBC 接続先 URL。\n例: jdbc:derby:tmp/derby.db;create=true<br>
     *
     * @param arg セットしたい値
     */
    public void setJdbcurl(final String arg) {
        fInput.setJdbcurl(arg);
        fIsFieldJdbcurlProcessed = true;
    }

    /**
     * Antタスクの[jdbcurl]アトリビュートのゲッターメソッド。
     *
     * 項目番号: 4<br>
     * JDBC 接続先 URL。\n例: jdbc:derby:tmp/derby.db;create=true<br>
     * 必須アトリビュートです。Apache Antタスク上で必ず値が指定されます。<br>
     *
     * @return このフィールドの値
     */
    public String getJdbcurl() {
        return fInput.getJdbcurl();
    }

    /**
     * Antタスクの[jdbcuser]アトリビュートのセッターメソッド。
     *
     * 項目番号: 5<br>
     * JDBC 接続時のユーザー。\n例: user<br>
     *
     * @param arg セットしたい値
     */
    public void setJdbcuser(final String arg) {
        fInput.setJdbcuser(arg);
        fIsFieldJdbcuserProcessed = true;
    }

    /**
     * Antタスクの[jdbcuser]アトリビュートのゲッターメソッド。
     *
     * 項目番号: 5<br>
     * JDBC 接続時のユーザー。\n例: user<br>
     * 必須アトリビュートです。Apache Antタスク上で必ず値が指定されます。<br>
     *
     * @return このフィールドの値
     */
    public String getJdbcuser() {
        return fInput.getJdbcuser();
    }

    /**
     * Antタスクの[jdbcpassword]アトリビュートのセッターメソッド。
     *
     * 項目番号: 6<br>
     * JDBC 接続時のパスワード。\n例: password<br>
     *
     * @param arg セットしたい値
     */
    public void setJdbcpassword(final String arg) {
        fInput.setJdbcpassword(arg);
        fIsFieldJdbcpasswordProcessed = true;
    }

    /**
     * Antタスクの[jdbcpassword]アトリビュートのゲッターメソッド。
     *
     * 項目番号: 6<br>
     * JDBC 接続時のパスワード。\n例: password<br>
     * 必須アトリビュートです。Apache Antタスク上で必ず値が指定されます。<br>
     *
     * @return このフィールドの値
     */
    public String getJdbcpassword() {
        return fInput.getJdbcpassword();
    }

    /**
     * Antタスクのメイン処理。Apache Antから このメソッドが呼び出されます。
     *
     * @throws BuildException タスクとしての例外が発生した場合。
     */
    @Override
    public final void execute() throws BuildException {
        System.out.println("BlancoFileManagerDbTableTask begin.");

        // 項目番号[3]、アトリビュート[jdbcdriver]は必須入力です。入力チェックを行います。
        if (fIsFieldJdbcdriverProcessed == false) {
            throw new BuildException("必須アトリビュート[jdbcdriver]が設定されていません。処理を中断します。");
        }
        // 項目番号[4]、アトリビュート[jdbcurl]は必須入力です。入力チェックを行います。
        if (fIsFieldJdbcurlProcessed == false) {
            throw new BuildException("必須アトリビュート[jdbcurl]が設定されていません。処理を中断します。");
        }
        // 項目番号[5]、アトリビュート[jdbcuser]は必須入力です。入力チェックを行います。
        if (fIsFieldJdbcuserProcessed == false) {
            throw new BuildException("必須アトリビュート[jdbcuser]が設定されていません。処理を中断します。");
        }
        // 項目番号[6]、アトリビュート[jdbcpassword]は必須入力です。入力チェックを行います。
        if (fIsFieldJdbcpasswordProcessed == false) {
            throw new BuildException("必須アトリビュート[jdbcpassword]が設定されていません。処理を中断します。");
        }

        if (getVerbose()) {
            System.out.println("- verbose:[true]");
            System.out.println("- create:[" + getCreate() + "]");
            System.out.println("- drop:[" + getDrop() + "]");
            System.out.println("- jdbcdriver:[" + getJdbcdriver() + "]");
            System.out.println("- jdbcurl:[" + getJdbcurl() + "]");
            System.out.println("- jdbcuser:[" + getJdbcuser() + "]");
            System.out.println("- jdbcpassword:[" + getJdbcpassword() + "]");
        }

        try {
            // 実際のAntタスクの主処理を実行します。
            // この箇所でコンパイルエラーが発生する場合、BlancoFileManagerDbTableProcessインタフェースを実装して blanco.filemanager.taskパッケージに BlancoFileManagerDbTableProcessImplクラスを作成することにより解決できる場合があります。
            final BlancoFileManagerDbTableProcess proc = new BlancoFileManagerDbTableProcessImpl();
            if (proc.execute(fInput) != BlancoFileManagerDbTableBatchProcess.END_SUCCESS) {
                throw new BuildException("タスクは異常終了しました。");
            }
        } catch (IllegalArgumentException e) {
            if (getVerbose()) {
                e.printStackTrace();
            }
            throw new BuildException(e.getMessage());
        } catch (Exception e) {
            e.printStackTrace();
            throw new BuildException("タスクを処理中に例外が発生しました。処理を中断します。" + e.toString());
        } catch (Error e) {
            e.printStackTrace();
            throw new BuildException("タスクを処理中にエラーが発生しました。処理を中断します。" + e.toString());
        }
    }
}
