/*
 * このソースコードは blanco Frameworkにより自動生成されました。
 */
package blanco.filemanager.task;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

import blanco.filemanager.task.valueobject.BlancoFileManagerReportProcessInput;

/**
 * Apache Antタスク [BlancoFileManagerReport]のクラス。
 *
 * 現在のファイル管理状況をレポートします。<br>
 * このクラスでは、Apache Antタスクで一般的に必要なチェックなどのコーディングを肩代わりします。
 * 実際の処理は パッケージ[blanco.filemanager.task]にBlancoFileManagerReportBatchProcessクラスを作成して記述してください。<br>
 * <br>
 * Antタスクへの組み込み例<br>
 * <pre>
 * &lt;taskdef name=&quot;blancofilemanagerreport&quot; classname=&quot;blanco.filemanager.task.BlancoFileManagerReportTask">
 *     &lt;classpath&gt;
 *         &lt;fileset dir=&quot;lib&quot; includes=&quot;*.jar&quot; /&gt;
 *         &lt;fileset dir=&quot;lib.ant&quot; includes=&quot;*.jar&quot; /&gt;
 *     &lt;/classpath&gt;
 * &lt;/taskdef&gt;
 * </pre>
 */
public class BlancoFileManagerReportTask extends Task {
    /**
     * 現在のファイル管理状況をレポートします。
     */
    protected BlancoFileManagerReportProcessInput fInput = new BlancoFileManagerReportProcessInput();

    /**
     * フィールド [projectname] に値がセットされたかどうか。
     */
    protected boolean fIsFieldProjectnameProcessed = false;

    /**
     * フィールド [templatefile] に値がセットされたかどうか。
     */
    protected boolean fIsFieldTemplatefileProcessed = false;

    /**
     * フィールド [outputfile] に値がセットされたかどうか。
     */
    protected boolean fIsFieldOutputfileProcessed = false;

    /**
     * フィールド [jdbcdriver] に値がセットされたかどうか。
     */
    protected boolean fIsFieldJdbcdriverProcessed = false;

    /**
     * フィールド [jdbcurl] に値がセットされたかどうか。
     */
    protected boolean fIsFieldJdbcurlProcessed = false;

    /**
     * フィールド [jdbcuser] に値がセットされたかどうか。
     */
    protected boolean fIsFieldJdbcuserProcessed = false;

    /**
     * フィールド [jdbcpassword] に値がセットされたかどうか。
     */
    protected boolean fIsFieldJdbcpasswordProcessed = false;

    /**
     * verboseモードで動作させるかどうか。
     *
     * @param arg verboseモードで動作させるかどうか。
     */
    public void setVerbose(final boolean arg) {
        fInput.setVerbose(arg);
    }

    /**
     * verboseモードで動作させるかどうか。
     *
     * @return verboseモードで動作させるかどうか。
     */
    public boolean getVerbose() {
        return fInput.getVerbose();
    }

    /**
     * Antタスクの[projectname]アトリビュートのセッターメソッド。
     *
     * 項目番号: 1<br>
     * 出力対象のプロジェクト名。<br>
     *
     * @param arg セットしたい値
     */
    public void setProjectname(final String arg) {
        fInput.setProjectname(arg);
        fIsFieldProjectnameProcessed = true;
    }

    /**
     * Antタスクの[projectname]アトリビュートのゲッターメソッド。
     *
     * 項目番号: 1<br>
     * 出力対象のプロジェクト名。<br>
     * デフォルト値[NONAME]が設定されています。Apache Antタスク上でアトリビュートの指定が無い場合には、デフォルト値が設定されます。<br>
     *
     * @return このフィールドの値
     */
    public String getProjectname() {
        return fInput.getProjectname();
    }

    /**
     * Antタスクの[templatefile]アトリビュートのセッターメソッド。
     *
     * 項目番号: 2<br>
     * レポートのテンプレートとなる xls ファイル。\n例: meta/template/blancoFileManagerTemplate.xls<br>
     *
     * @param arg セットしたい値
     */
    public void setTemplatefile(final String arg) {
        fInput.setTemplatefile(arg);
        fIsFieldTemplatefileProcessed = true;
    }

    /**
     * Antタスクの[templatefile]アトリビュートのゲッターメソッド。
     *
     * 項目番号: 2<br>
     * レポートのテンプレートとなる xls ファイル。\n例: meta/template/blancoFileManagerTemplate.xls<br>
     * 必須アトリビュートです。Apache Antタスク上で必ず値が指定されます。<br>
     *
     * @return このフィールドの値
     */
    public String getTemplatefile() {
        return fInput.getTemplatefile();
    }

    /**
     * Antタスクの[outputfile]アトリビュートのセッターメソッド。
     *
     * 項目番号: 3<br>
     * 出力xls ファイル名。<br>
     *
     * @param arg セットしたい値
     */
    public void setOutputfile(final String arg) {
        fInput.setOutputfile(arg);
        fIsFieldOutputfileProcessed = true;
    }

    /**
     * Antタスクの[outputfile]アトリビュートのゲッターメソッド。
     *
     * 項目番号: 3<br>
     * 出力xls ファイル名。<br>
     * 必須アトリビュートです。Apache Antタスク上で必ず値が指定されます。<br>
     *
     * @return このフィールドの値
     */
    public String getOutputfile() {
        return fInput.getOutputfile();
    }

    /**
     * Antタスクの[jdbcdriver]アトリビュートのセッターメソッド。
     *
     * 項目番号: 4<br>
     * JDBC ドライバクラス名。\n例: org.apache.derby.jdbc.EmbeddedDriver<br>
     *
     * @param arg セットしたい値
     */
    public void setJdbcdriver(final String arg) {
        fInput.setJdbcdriver(arg);
        fIsFieldJdbcdriverProcessed = true;
    }

    /**
     * Antタスクの[jdbcdriver]アトリビュートのゲッターメソッド。
     *
     * 項目番号: 4<br>
     * JDBC ドライバクラス名。\n例: org.apache.derby.jdbc.EmbeddedDriver<br>
     * 必須アトリビュートです。Apache Antタスク上で必ず値が指定されます。<br>
     *
     * @return このフィールドの値
     */
    public String getJdbcdriver() {
        return fInput.getJdbcdriver();
    }

    /**
     * Antタスクの[jdbcurl]アトリビュートのセッターメソッド。
     *
     * 項目番号: 5<br>
     * JDBC 接続先 URL。\n例: jdbc:derby:tmp/derby.db;create=true<br>
     *
     * @param arg セットしたい値
     */
    public void setJdbcurl(final String arg) {
        fInput.setJdbcurl(arg);
        fIsFieldJdbcurlProcessed = true;
    }

    /**
     * Antタスクの[jdbcurl]アトリビュートのゲッターメソッド。
     *
     * 項目番号: 5<br>
     * JDBC 接続先 URL。\n例: jdbc:derby:tmp/derby.db;create=true<br>
     * 必須アトリビュートです。Apache Antタスク上で必ず値が指定されます。<br>
     *
     * @return このフィールドの値
     */
    public String getJdbcurl() {
        return fInput.getJdbcurl();
    }

    /**
     * Antタスクの[jdbcuser]アトリビュートのセッターメソッド。
     *
     * 項目番号: 6<br>
     * JDBC 接続時のユーザー。\n例: user<br>
     *
     * @param arg セットしたい値
     */
    public void setJdbcuser(final String arg) {
        fInput.setJdbcuser(arg);
        fIsFieldJdbcuserProcessed = true;
    }

    /**
     * Antタスクの[jdbcuser]アトリビュートのゲッターメソッド。
     *
     * 項目番号: 6<br>
     * JDBC 接続時のユーザー。\n例: user<br>
     * 必須アトリビュートです。Apache Antタスク上で必ず値が指定されます。<br>
     *
     * @return このフィールドの値
     */
    public String getJdbcuser() {
        return fInput.getJdbcuser();
    }

    /**
     * Antタスクの[jdbcpassword]アトリビュートのセッターメソッド。
     *
     * 項目番号: 7<br>
     * JDBC 接続時のパスワード。\n例: password<br>
     *
     * @param arg セットしたい値
     */
    public void setJdbcpassword(final String arg) {
        fInput.setJdbcpassword(arg);
        fIsFieldJdbcpasswordProcessed = true;
    }

    /**
     * Antタスクの[jdbcpassword]アトリビュートのゲッターメソッド。
     *
     * 項目番号: 7<br>
     * JDBC 接続時のパスワード。\n例: password<br>
     * 必須アトリビュートです。Apache Antタスク上で必ず値が指定されます。<br>
     *
     * @return このフィールドの値
     */
    public String getJdbcpassword() {
        return fInput.getJdbcpassword();
    }

    /**
     * Antタスクのメイン処理。Apache Antから このメソッドが呼び出されます。
     *
     * @throws BuildException タスクとしての例外が発生した場合。
     */
    @Override
    public final void execute() throws BuildException {
        System.out.println("BlancoFileManagerReportTask begin.");

        // 項目番号[2]、アトリビュート[templatefile]は必須入力です。入力チェックを行います。
        if (fIsFieldTemplatefileProcessed == false) {
            throw new BuildException("必須アトリビュート[templatefile]が設定されていません。処理を中断します。");
        }
        // 項目番号[3]、アトリビュート[outputfile]は必須入力です。入力チェックを行います。
        if (fIsFieldOutputfileProcessed == false) {
            throw new BuildException("必須アトリビュート[outputfile]が設定されていません。処理を中断します。");
        }
        // 項目番号[4]、アトリビュート[jdbcdriver]は必須入力です。入力チェックを行います。
        if (fIsFieldJdbcdriverProcessed == false) {
            throw new BuildException("必須アトリビュート[jdbcdriver]が設定されていません。処理を中断します。");
        }
        // 項目番号[5]、アトリビュート[jdbcurl]は必須入力です。入力チェックを行います。
        if (fIsFieldJdbcurlProcessed == false) {
            throw new BuildException("必須アトリビュート[jdbcurl]が設定されていません。処理を中断します。");
        }
        // 項目番号[6]、アトリビュート[jdbcuser]は必須入力です。入力チェックを行います。
        if (fIsFieldJdbcuserProcessed == false) {
            throw new BuildException("必須アトリビュート[jdbcuser]が設定されていません。処理を中断します。");
        }
        // 項目番号[7]、アトリビュート[jdbcpassword]は必須入力です。入力チェックを行います。
        if (fIsFieldJdbcpasswordProcessed == false) {
            throw new BuildException("必須アトリビュート[jdbcpassword]が設定されていません。処理を中断します。");
        }

        if (getVerbose()) {
            System.out.println("- verbose:[true]");
            System.out.println("- projectname:[" + getProjectname() + "]");
            System.out.println("- templatefile:[" + getTemplatefile() + "]");
            System.out.println("- outputfile:[" + getOutputfile() + "]");
            System.out.println("- jdbcdriver:[" + getJdbcdriver() + "]");
            System.out.println("- jdbcurl:[" + getJdbcurl() + "]");
            System.out.println("- jdbcuser:[" + getJdbcuser() + "]");
            System.out.println("- jdbcpassword:[" + getJdbcpassword() + "]");
        }

        try {
            // 実際のAntタスクの主処理を実行します。
            // この箇所でコンパイルエラーが発生する場合、BlancoFileManagerReportProcessインタフェースを実装して blanco.filemanager.taskパッケージに BlancoFileManagerReportProcessImplクラスを作成することにより解決できる場合があります。
            final BlancoFileManagerReportProcess proc = new BlancoFileManagerReportProcessImpl();
            if (proc.execute(fInput) != BlancoFileManagerReportBatchProcess.END_SUCCESS) {
                throw new BuildException("タスクは異常終了しました。");
            }
        } catch (IllegalArgumentException e) {
            if (getVerbose()) {
                e.printStackTrace();
            }
            throw new BuildException(e.getMessage());
        } catch (Exception e) {
            e.printStackTrace();
            throw new BuildException("タスクを処理中に例外が発生しました。処理を中断します。" + e.toString());
        } catch (Error e) {
            e.printStackTrace();
            throw new BuildException("タスクを処理中にエラーが発生しました。処理を中断します。" + e.toString());
        }
    }
}
