package blanco.filemanager.db.dao;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Date;

import blanco.filemanager.db.query.Sbfm0301Iterator;
import blanco.filemanager.db.query.Sbfm0302Iterator;
import blanco.filemanager.db.row.Sbfm0301Row;
import blanco.filemanager.db.row.Sbfm0302Row;
import blanco.filemanager.dbaccessor.query.BfmFileAttrInfoI01Invoker;
import blanco.filemanager.dbaccessor.query.BfmFileAttrInfoS01Iterator;
import blanco.filemanager.dbaccessor.row.BfmFileAttrInfoS01Row;
import blanco.filemanager.file.BlancoFileManagerFileAttrInfo;
import blanco.fw.BlancoInject;

public abstract class AbstractBlancoFileManagerFileAttrInfoDao {
    /**
     * 指定されたファイルIDのファイル属性情報を取得します。
     * 
     * @param conn
     * @param iteAttr
     * @param fileAttrId
     * @return
     * @throws SQLException
     */
    public BlancoFileManagerFileAttrInfo getFileAttrInfo(final Connection conn,
            @BlancoInject final BfmFileAttrInfoS01Iterator iteAttr, final int fileAttrId) throws SQLException {
        iteAttr.setInputParameter(fileAttrId);
        final BfmFileAttrInfoS01Row row = iteAttr.getSingleRow();

        final BlancoFileManagerFileAttrInfo attr = new BlancoFileManagerFileAttrInfo();
        attr.setFileAttrId(fileAttrId);

        attr.setFileId(row.getFileId());
        attr.setFileSize(row.getFileSize());
        attr.setFileMd5(row.getFileMd5());
        attr.setFileSha1(row.getFileSha1());
        attr.setFileSha256(row.getFileSha256());
        attr.setFileAttrDt(row.getFileAttrDt());
        attr.setValidLineCount(row.getValidLineCount());
        attr.setCommentLineCount(row.getCommentLineCount());
        attr.setBlankLineCount(row.getBlankLineCount());
        attr.setModifiedLineCount(row.getModifiedLineCount());
        attr.setUpdDt(row.getUpdDt());
        attr.setUpdUserId(row.getUpdUserId());

        return attr;
    }

    /**
     * 指定されたファイルIDにひもづく最後の(すなはちファイル属性IDがいちばん大きな)ファイル属性情報を取得します。
     * 
     * @param conn
     * @param iteSearch
     * @param fileInfo
     * @return あればファイルID。なければ -1。
     * @throws SQLException
     */
    public BlancoFileManagerFileAttrInfo getLastFileAttrInfo(final Connection conn,
            @BlancoInject final Sbfm0302Iterator iteAttr, final int fileId) throws SQLException {
        iteAttr.setInputParameter(fileId);
        final Sbfm0302Row row = iteAttr.getSingleRow();

        final BlancoFileManagerFileAttrInfo attr = new BlancoFileManagerFileAttrInfo();
        attr.setFileAttrId(row.getFileAttrId());
        attr.setFileId(row.getFileId());
        attr.setFileSize(row.getFileSize());
        attr.setFileMd5(row.getFileMd5());
        attr.setFileSha1(row.getFileSha1());
        attr.setFileSha256(row.getFileSha256());
        attr.setFileAttrDt(row.getFileAttrDt());
        attr.setValidLineCount(row.getValidLineCount());
        attr.setCommentLineCount(row.getCommentLineCount());
        attr.setBlankLineCount(row.getBlankLineCount());
        attr.setModifiedLineCount(row.getModifiedLineCount());
        attr.setUpdDt(row.getUpdDt());
        attr.setUpdUserId(row.getUpdUserId());

        return attr;
    }

    /**
     * 次のファイル説明IDを採番します。
     * 
     * @param conn
     * @param iteMax
     * @return
     * @throws SQLException
     */
    public int getNextFileAttrId(final Connection conn, @BlancoInject final Sbfm0301Iterator iteMax)
            throws SQLException {
        int nextFileAttrId = 0;
        final Sbfm0301Row rowMax = iteMax.getSingleRow();
        if (rowMax.getMaxFileAttrId() == null) {
            nextFileAttrId = 1;
        } else {
            nextFileAttrId = rowMax.getMaxFileAttrId().intValue() + 1;
        }

        return nextFileAttrId;
    }

    /**
     * 新たなデータをINESRTします。
     * 
     * @param conn
     * @param fileInfo
     * @param invInfo
     * @param now
     * @throws SQLException
     */
    public void insertFileAttrInfo(final Connection conn, final BlancoFileManagerFileAttrInfo fileAttr,
            @BlancoInject final BfmFileAttrInfoI01Invoker invAttr, final Date now) throws SQLException {
        invAttr.setInputParameter(fileAttr.getFileAttrId(), fileAttr.getFileId(), fileAttr.getFileSize(),
                fileAttr.getFileMd5(), fileAttr.getFileSha1(), fileAttr.getFileSha256(), fileAttr.getFileAttrDt(),
                fileAttr.getValidLineCount(), fileAttr.getCommentLineCount(), fileAttr.getBlankLineCount(),
                fileAttr.getModifiedLineCount(), now, "system");
        invAttr.executeSingleUpdate();
    }
}
