package blanco.filemanager.db.dao;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import blanco.filemanager.db.query.Sbfm0201Iterator;
import blanco.filemanager.db.query.Sbfm0202Iterator;
import blanco.filemanager.db.row.Sbfm0201Row;
import blanco.filemanager.db.row.Sbfm0202Row;
import blanco.filemanager.dbaccessor.query.BfmFileDescI01Invoker;
import blanco.filemanager.file.BlancoFileManagerFileDesc;
import blanco.fw.BlancoInject;

public abstract class AbstractBlancoFileManagerFileDescDao {
    /**
     * 指定されたファイルIDにひもづくすべてのファイル説明を取得します。
     * 
     * @param conn
     * @param iteSearch
     * @param fileInfo
     * @return あればファイルID。なければ -1。
     * @throws SQLException
     */
    public List<BlancoFileManagerFileDesc> getFileDescList(final Connection conn,
            @BlancoInject final Sbfm0202Iterator iteDesc, final int fileId) throws SQLException {
        final List<BlancoFileManagerFileDesc> descList = new ArrayList<BlancoFileManagerFileDesc>();
        iteDesc.setInputParameter(fileId);
        for (Sbfm0202Row desc : iteDesc.getList(100000)) {
            final BlancoFileManagerFileDesc newDesc = new BlancoFileManagerFileDesc();
            descList.add(newDesc);
            newDesc.setFileDescId(desc.getFileDescId());
            newDesc.setFileId(desc.getFileId());
            newDesc.setFileDescDt(desc.getFileDescDt());
            newDesc.setFileDesc(desc.getFileDesc());
            newDesc.setFileDescUsername(desc.getFileDescUsername());
            newDesc.setUpdDt(desc.getUpdDt());
            newDesc.setUpdUserId(desc.getUpdUserId());
        }

        return descList;
    }

    /**
     * 次のファイル説明IDを採番します。
     * 
     * @param conn
     * @param iteMax
     * @return
     * @throws SQLException
     */
    public int getNextFileDescId(final Connection conn, @BlancoInject final Sbfm0201Iterator iteMax)
            throws SQLException {
        int nextFileDescId = 0;
        final Sbfm0201Row rowMax = iteMax.getSingleRow();
        if (rowMax.getMaxFileDescId() == null) {
            nextFileDescId = 1;
        } else {
            nextFileDescId = rowMax.getMaxFileDescId().intValue() + 1;
        }

        return nextFileDescId;
    }

    /**
     * 新たなデータをINESRTします。
     * 
     * @param conn
     * @param fileInfo
     * @param invInfo
     * @param now
     * @throws SQLException
     */
    public void insertFileDesc(final Connection conn, final BlancoFileManagerFileDesc fileDesc,
            @BlancoInject final BfmFileDescI01Invoker invDesc, final Date now) throws SQLException {
        invDesc.setInputParameter(fileDesc.getFileDescId(), fileDesc.getFileId(), fileDesc.getFileDesc(),
                fileDesc.getFileDescDt(), fileDesc.getFileDescUsername(), now, "system");
        invDesc.executeSingleUpdate();
    }
}
