/*
 * This code is generated by blanco Framework.
 */
package blanco.filemanager.db.query;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import blanco.filemanager.db.row.Sbfm0104Row;
import blanco.filemanager.db.runtime.exception.DeadlockException;
import blanco.filemanager.db.runtime.exception.TimeoutException;
import blanco.filemanager.db.runtime.util.BlancoDbUtil;
import blanco.fw.BlancoGeneratedBy;

/**
 * [SBFM0104] あるファイルIDの、全ての説明を検索します。所定の並び順で並べます。 (QueryIterator)
 *
 * 検索型SQL文をラッピングして各種アクセサを提供します。<br>
 * スクロール属性: forward_only<br>
 */
@BlancoGeneratedBy(name = "blancoDb")
public class Sbfm0104Iterator {
    /**
     * このクラスが内部的に利用するデータベース接続オブジェクト。
     *
     * データベース接続オブジェクトはコンストラクタの引数として外部から与えられます。<br>
     * トランザクションのコミットやロールバックは、このクラスの内部では実行しません。
     */
    protected Connection fConnection;

    /**
     * このクラスが内部的に利用するステートメントオブジェクト。
     *
     * このオブジェクトはデータベース接続オブジェクトから生成されて内部的に利用されます。<br>
     * closeメソッドの呼び出し時に、このオブジェクトのcloseを実行します。
     */
    protected PreparedStatement fStatement;

    /**
     * このクラスが内部的に利用する結果セットオブジェクト。
     *
     * このオブジェクトはデータベースステートメントオブジェクトから生成されて内部的に利用されます。<br>
     * closeメソッドの呼び出し時に、このオブジェクトのcloseを実行します。
     */
    protected ResultSet fResultSet;

    /**
     * Sbfm0104Iteratorクラスのコンストラクタ。
     *
     * データベースコネクションオブジェクトを引数としてクエリクラスを作成します。<br>
     * このクラスの利用後は、必ず close()メソッドを呼び出す必要があります。<br>
     *
     * @param conn データベース接続
     */
    public Sbfm0104Iterator(final Connection conn) {
        fConnection = conn;
    }

    /**
     * Sbfm0104Iteratorクラスのコンストラクタ。
     *
     * データベースコネクションオブジェクトを与えずにクエリクラスを作成します。<br>
     */
    @Deprecated
    public Sbfm0104Iterator() {
    }

    /**
     * Sbfm0104Iteratorクラスにデータベース接続を設定。
     *
     * @param conn データベース接続
     */
    @Deprecated
    public void setConnection(final Connection conn) {
        fConnection = conn;
    }

    /**
     * SQL定義書で与えられたSQL文を取得します。
     *
     * SQL入力パラメータとして #キーワードによる指定がある場合には、該当箇所を ? に置き換えた後の SQL文が取得できます。
     *
     * @return JDBCドライバに与えて実行可能な状態のSQL文。
     */
    public String getQuery() {
        return "SELECT\n        *\n    FROM\n        BFM_FILE_DESC\n    WHERE\n        FILE_ID = ?\n    ORDER BY\n        FILE_DESC_ID DESC";
    }

    /**
     * SQL定義書から与えられたSQL文をもちいてプリコンパイルを実施します。
     *
     * 内部的にConnection.prepareStatementを呼び出します。<br>
     *
     * @throws SQLException SQL例外が発生した場合。
     */
    public void prepareStatement() throws SQLException {
        close();
        prepareStatement(getQuery());
    }

    /**
     * 与えられたSQL文をもちいてプリコンパイルを実施(動的SQL)します。
     *
     * このメソッドは、動的に内容が変化するような SQL を実行する必要がある場合にのみ利用します。<br>
     * 動的 SQL を利用する必要がある場合には、SQL 定義書で「動的SQL」を「使用する」に変更してください。変更後は外部から利用可能になります。<br>
     * 内部的に JDBC ドライバの Connection.prepareStatement を呼び出します。<br>
     *
     * @param query プリコンパイルを実施させたいSQL文。動的SQLの場合には、この引数には加工された後の実行可能なSQL文を与えます。
     * @throws SQLException SQL例外が発生した場合。
     */
    protected void prepareStatement(final String query) throws SQLException {
        close();
        fStatement = fConnection.prepareStatement(query);
    }

    /**
     * SQL文に与えるSQL入力パラメータをセットします。
     *
     * 内部的には PreparedStatementにSQL入力パラメータをセットします。
     *
     * @param FILE_ID 'FILE_ID'列の値
     * @throws SQLException SQL例外が発生した場合。
     */
    public void setInputParameter(final int FILE_ID) throws SQLException {
        if (fStatement == null) {
            prepareStatement();
        }
        fStatement.setInt(1, FILE_ID);
    }

    /**
     * 検索型クエリを実行します。<br>
     *
     * @throws DeadlockException データベースデッドロックが発生した場合。
     * @throws TimeoutException データベースタイムアウトが発生した場合。
     * @throws SQLException SQL例外が発生した場合。
     */
    public void executeQuery() throws DeadlockException, TimeoutException, SQLException {
        if (fStatement == null) {
            // PreparedStatementが未取得の状態なので、PreparedStatement.executeQuery()実行に先立ちprepareStatement()メソッドを呼び出して取得します。
            prepareStatement();
        }
        if (fResultSet != null) {
            // 前回の結果セット(ResultSet)が残っているので、これを一旦開放します。
            fResultSet.close();
            fResultSet = null;
        }

        try {
            fResultSet = fStatement.executeQuery();
        } catch (SQLException ex) {
            throw BlancoDbUtil.convertToBlancoException(ex);
        }
    }

    /**
     * カーソルを現在の位置から1行次へ移動します。
     *
     * @return 新しい現在の行が有効な場合はtrue、それ以上の行がない場合はfalse。
     * @throws DeadlockException データベースデッドロックが発生した場合。
     * @throws TimeoutException データベースタイムアウトが発生した場合。
     * @throws SQLException SQL例外が発生した場合。
     */
    public boolean next() throws DeadlockException, TimeoutException, SQLException {
        if (fResultSet == null) {
            executeQuery();
        }

        try {
            return fResultSet.next();
        } catch (SQLException ex) {
            throw BlancoDbUtil.convertToBlancoException(ex);
        }
    }

    /**
     * 現在の行のデータをオブジェクトとして取得します。
     *
     * このメソッドを呼び出す前に、next()などのカーソルを操作するメソッドを呼び出す必要があります。
     *
     * @return 行オブジェクト。
     * @throws SQLException SQL例外が発生した場合。
     */
    public Sbfm0104Row getRow() throws SQLException {
        Sbfm0104Row result = new Sbfm0104Row();
        result.setFileDescId(fResultSet.getInt(1));
        result.setFileId(fResultSet.getInt(2));
        result.setFileDesc(fResultSet.getString(3));
        result.setFileDescDt(BlancoDbUtil.convertTimestampToDate(fResultSet.getTimestamp(4)));
        if (fResultSet.wasNull()) {
            result.setFileDescDt(null);
        }
        result.setFileDescUsername(fResultSet.getString(5));
        result.setUpdDt(BlancoDbUtil.convertTimestampToDate(fResultSet.getTimestamp(6)));
        if (fResultSet.wasNull()) {
            result.setUpdDt(null);
        }
        result.setUpdUserId(fResultSet.getString(7));

        return result;
    }

    /**
     * ステートメント (java.sql.PreparedStatement) を取得します。
     * @deprecated 基本的にStatementは外部から直接利用する必要はありません。
     *
     * @return 内部的に利用されている java.sql.PreparedStatementオブジェクト
     */
    public PreparedStatement getStatement() {
        return fStatement;
    }

    /**
     * 内部的に保持されているResultSetオブジェクトを取得します。
     *
     * @deprecated 基本的にResultSetは外部から直接利用する必要はありません。
     *
     * @return ResultSetオブジェクト。
     */
    public ResultSet getResultSet() {
        return fResultSet;
    }

    /**
     * 検索結果をリストの形式で取得します。
     *
     * リストには SBFM0104クラスが格納されます。<br>
     * 検索結果の件数があらかじめわかっていて、且つ件数が少ない場合に利用することができます。<br>
     * 検索結果の件数が多い場合には、このメソッドは利用せず、代わりに next()メソッドを利用することをお勧めします。<br>
     * このQueryIteratorは FORWARD_ONLY(順方向カーソル)です。大量のデータを扱うことがわかっている場合には、このgetListメソッドの利用は極力避けるか、あるいは スクロールカーソルとしてソースコードを再生成してください。
     *
     * @param size 読み出しを行う行数。
     * @return SBFM0104クラスのList。検索結果が0件の場合には空のリストが戻ります。
     * @throws SQLException SQL例外が発生した場合。
     */
    public List<Sbfm0104Row> getList(final int size) throws SQLException {
        List<Sbfm0104Row> result = new ArrayList<Sbfm0104Row>(8192);
        for (int count = 1; count <= size; count++) {
            if (next() == false) {
                break;
            }
            result.add(getRow());
        }
        return result;
    }

    /**
     * このクラスのクローズ処理をおこないます。
     *
     * 内部的に生成していたJDBCリソースのオブジェクトに対して close()メソッドの呼び出しをおこないます。<br>
     * クラスの利用が終わったら、必ずこのメソッドを呼び出すようにします。
     *
     * @throws SQLException SQL例外が発生した場合。
     */
    public void close() throws SQLException {
        try {
            if (fResultSet != null) {
                fResultSet.close();
                fResultSet = null;
            }
        } finally {
            if (fStatement != null) {
                fStatement.close();
                fStatement = null;
            }
        }
    }

    /**
     * finalizeメソッド。
     *
     * このクラスが内部的に生成したオブジェクトのなかで、close()呼び出し忘れバグが存在するかどうかチェックします。<br>
     *
     * @throws Throwable finalize処理の中で発生した例外。
     */
    protected void finalize() throws Throwable {
        super.finalize();
        if (fStatement != null) {
            final String message = "Sbfm0104Iterator : close()メソッドによるリソースの開放が行われていません。";
            System.out.println(message);
        }
    }
}
