package blanco.filemanager.file;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import blanco.gettersetter.BlancoGetterSetter;

public abstract class AbstractBlancoFileManagerFileInfo {
    @BlancoGetterSetter
    protected int FILE_ID = -1;

    @BlancoGetterSetter
    protected String PROJECT = "NONAME";

    @BlancoGetterSetter
    protected String FILE_NAME = null;

    @BlancoGetterSetter
    protected int FILE_STAT_FLG = 0;

    @BlancoGetterSetter
    protected int FILE_CHANGE_FLG = 0;

    @BlancoGetterSetter
    protected String FILE_TYPE = "";

    @BlancoGetterSetter
    protected String FILE_PATH = "";

    @BlancoGetterSetter
    protected Date UPD_DT = null;

    @BlancoGetterSetter
    protected String UPD_USER_ID = null;

    /**
     * ファイルに対する属性の履歴。
     */
    @BlancoGetterSetter(setter = false)
    protected List<BlancoFileManagerFileAttrInfo> attrInfoList = new ArrayList<BlancoFileManagerFileAttrInfo>();

    /**
     * ファイルに対する説明の履歴。
     */
    @BlancoGetterSetter(setter = false)
    protected List<BlancoFileManagerFileDesc> descList = new ArrayList<BlancoFileManagerFileDesc>();

    // 表示用のサービスメソッド。

    public String getFileStatFlgDisplayString() {
        switch (FILE_STAT_FLG) {
        case 0:
            return "通常";
        case 2:
            return "修正待ち";
        case 3:
            return "削除待ち";
        case 8:
            return "無視";
        default:
            return "(想定外の値(" + FILE_STAT_FLG + ")があたえられました)";
        }
    }

    public String getFileChangeFlgDisplayString() {
        switch (FILE_CHANGE_FLG) {
        case 0:
            return "";
        case 1:
            return "追加";
        case 2:
            return "変更";
        case 3:
            return "削除";
        default:
            return "(想定外の値(" + FILE_CHANGE_FLG + ")があたえられました)";
        }
    }
}
