package blanco.filemanager.task;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;

import blanco.filemanager.BlancoFileManagerConstats;
import blanco.filemanager.core.BlancoFileManagerDbCore;
import blanco.filemanager.task.valueobject.BlancoFileManagerDbTableProcessInput;

public class BlancoFileManagerDbTableProcessImpl implements BlancoFileManagerDbTableProcess {

    @Override
    public int execute(final BlancoFileManagerDbTableProcessInput input) throws IOException, IllegalArgumentException {
        System.err.println("BlancoFileManagerDbTableTask (" + BlancoFileManagerConstats.getVersion() + ")");

        if (input.getCreate()) {
            System.out.println("blancoFileManager の管理テーブルを作成します。");
        }

        if (input.getDrop()) {
            System.out.println("blancoFileManager の管理テーブルを削除します。");
        }

        try {
            if (input.getCreate() == false && input.getDrop() == false) {
                System.out.println("データベースへの接続のみを実行します。これは Derby の shutdown において利用されることのみ想定しています。");

                try {
                    Class.forName(input.getJdbcdriver());
                } catch (ClassNotFoundException e) {
                    throw new SQLException("Fail to load JDBC Driver class: [" + input.getJdbcdriver() + "]: "
                            + e.toString(), e);
                }

                // shutdown シーケンスに入ります。
                try {
                    // Derby は Shutdown 時に例外が発生する場合がある模様。
                    final Connection conn = DriverManager.getConnection(input.getJdbcurl());
                    conn.close();
                } catch (SQLException ex) {
                    System.out.println("DB接続のみ確認: Derby の shutdown での利用を想定: その処理の中で例外が発生しましたが無視します: " + ex.toString());
                }

                return 0;
            }

            final Connection conn = BlancoFileManagerDbCore.getBatchConnection(input.getJdbcdriver(),
                    input.getJdbcurl(), input.getJdbcuser(), input.getJdbcpassword());

            if (input.getCreate()) {
                System.out.println("Create db tables.");
                BlancoFileManagerDbCore.createTables(conn);
                conn.commit();
            }

            if (input.getDrop()) {
                System.out.println("Drop db tables.");
                BlancoFileManagerDbCore.dropTables(conn);
                conn.commit();
            }

            conn.rollback();
            conn.close();

            System.out.println("Done.");
        } catch (SQLException e) {
            e.printStackTrace();
            return 9;
        }

        return 0;
    }

    @Override
    public boolean progress(String argProgressMessage) {
        return false;
    }
}
