/*
 * このソースコードは blanco Frameworkにより自動生成されました。
 */
package blanco.filemanager.task;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

import blanco.filemanager.task.valueobject.BlancoFileManagerExpandZipProcessInput;

/**
 * Apache Antタスク [BlancoFileManagerExpandZip]のクラス。
 *
 * 与えられた ZIP ファイルを展開します。日本語ディレクトリ名やファイル名に対応します。<br>
 * このクラスでは、Apache Antタスクで一般的に必要なチェックなどのコーディングを肩代わりします。
 * 実際の処理は パッケージ[blanco.filemanager.task]にBlancoFileManagerExpandZipBatchProcessクラスを作成して記述してください。<br>
 * <br>
 * Antタスクへの組み込み例<br>
 * <pre>
 * &lt;taskdef name=&quot;blancofilemanagerexpandzip&quot; classname=&quot;blanco.filemanager.task.BlancoFileManagerExpandZipTask">
 *     &lt;classpath&gt;
 *         &lt;fileset dir=&quot;lib&quot; includes=&quot;*.jar&quot; /&gt;
 *         &lt;fileset dir=&quot;lib.ant&quot; includes=&quot;*.jar&quot; /&gt;
 *     &lt;/classpath&gt;
 * &lt;/taskdef&gt;
 * </pre>
 */
public class BlancoFileManagerExpandZipTask extends Task {
    /**
     * 与えられた ZIP ファイルを展開します。日本語ディレクトリ名やファイル名に対応します。
     */
    protected BlancoFileManagerExpandZipProcessInput fInput = new BlancoFileManagerExpandZipProcessInput();

    /**
     * フィールド [inputfile] に値がセットされたかどうか。
     */
    protected boolean fIsFieldInputfileProcessed = false;

    /**
     * フィールド [outputdir] に値がセットされたかどうか。
     */
    protected boolean fIsFieldOutputdirProcessed = false;

    /**
     * verboseモードで動作させるかどうか。
     *
     * @param arg verboseモードで動作させるかどうか。
     */
    public void setVerbose(final boolean arg) {
        fInput.setVerbose(arg);
    }

    /**
     * verboseモードで動作させるかどうか。
     *
     * @return verboseモードで動作させるかどうか。
     */
    public boolean getVerbose() {
        return fInput.getVerbose();
    }

    /**
     * Antタスクの[inputfile]アトリビュートのセッターメソッド。
     *
     * 項目番号: 1<br>
     * 入力ZIPファイルを指定します。<br>
     *
     * @param arg セットしたい値
     */
    public void setInputfile(final String arg) {
        fInput.setInputfile(arg);
        fIsFieldInputfileProcessed = true;
    }

    /**
     * Antタスクの[inputfile]アトリビュートのゲッターメソッド。
     *
     * 項目番号: 1<br>
     * 入力ZIPファイルを指定します。<br>
     * 必須アトリビュートです。Apache Antタスク上で必ず値が指定されます。<br>
     *
     * @return このフィールドの値
     */
    public String getInputfile() {
        return fInput.getInputfile();
    }

    /**
     * Antタスクの[outputdir]アトリビュートのセッターメソッド。
     *
     * 項目番号: 2<br>
     * 出力先ディレクトリを指定します。<br>
     *
     * @param arg セットしたい値
     */
    public void setOutputdir(final String arg) {
        fInput.setOutputdir(arg);
        fIsFieldOutputdirProcessed = true;
    }

    /**
     * Antタスクの[outputdir]アトリビュートのゲッターメソッド。
     *
     * 項目番号: 2<br>
     * 出力先ディレクトリを指定します。<br>
     * 必須アトリビュートです。Apache Antタスク上で必ず値が指定されます。<br>
     *
     * @return このフィールドの値
     */
    public String getOutputdir() {
        return fInput.getOutputdir();
    }

    /**
     * Antタスクのメイン処理。Apache Antから このメソッドが呼び出されます。
     *
     * @throws BuildException タスクとしての例外が発生した場合。
     */
    @Override
    public final void execute() throws BuildException {
        System.out.println("BlancoFileManagerExpandZipTask begin.");

        // 項目番号[1]、アトリビュート[inputfile]は必須入力です。入力チェックを行います。
        if (fIsFieldInputfileProcessed == false) {
            throw new BuildException("必須アトリビュート[inputfile]が設定されていません。処理を中断します。");
        }
        // 項目番号[2]、アトリビュート[outputdir]は必須入力です。入力チェックを行います。
        if (fIsFieldOutputdirProcessed == false) {
            throw new BuildException("必須アトリビュート[outputdir]が設定されていません。処理を中断します。");
        }

        if (getVerbose()) {
            System.out.println("- verbose:[true]");
            System.out.println("- inputfile:[" + getInputfile() + "]");
            System.out.println("- outputdir:[" + getOutputdir() + "]");
        }

        try {
            // 実際のAntタスクの主処理を実行します。
            // この箇所でコンパイルエラーが発生する場合、BlancoFileManagerExpandZipProcessインタフェースを実装して blanco.filemanager.taskパッケージに BlancoFileManagerExpandZipProcessImplクラスを作成することにより解決できる場合があります。
            final BlancoFileManagerExpandZipProcess proc = new BlancoFileManagerExpandZipProcessImpl();
            if (proc.execute(fInput) != BlancoFileManagerExpandZipBatchProcess.END_SUCCESS) {
                throw new BuildException("タスクは異常終了しました。");
            }
        } catch (IllegalArgumentException e) {
            if (getVerbose()) {
                e.printStackTrace();
            }
            throw new BuildException(e.getMessage());
        } catch (Exception e) {
            e.printStackTrace();
            throw new BuildException("タスクを処理中に例外が発生しました。処理を中断します。" + e.toString());
        } catch (Error e) {
            e.printStackTrace();
            throw new BuildException("タスクを処理中にエラーが発生しました。処理を中断します。" + e.toString());
        }
    }
}
