/*
 * このソースコードは blanco Frameworkにより自動生成されました。
 */
package blanco.filemanager.task;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

import blanco.filemanager.task.valueobject.BlancoFileManagerImportProcessInput;

/**
 * Apache Antタスク [BlancoFileManagerImport]のクラス。
 *
 * ファイルを blancoFileManager 管理テーブルに情報取り込みます。<br>
 * このクラスでは、Apache Antタスクで一般的に必要なチェックなどのコーディングを肩代わりします。
 * 実際の処理は パッケージ[blanco.filemanager.task]にBlancoFileManagerImportBatchProcessクラスを作成して記述してください。<br>
 * <br>
 * Antタスクへの組み込み例<br>
 * <pre>
 * &lt;taskdef name=&quot;blancofilemanagerimport&quot; classname=&quot;blanco.filemanager.task.BlancoFileManagerImportTask">
 *     &lt;classpath&gt;
 *         &lt;fileset dir=&quot;lib&quot; includes=&quot;*.jar&quot; /&gt;
 *         &lt;fileset dir=&quot;lib.ant&quot; includes=&quot;*.jar&quot; /&gt;
 *     &lt;/classpath&gt;
 * &lt;/taskdef&gt;
 * </pre>
 */
public class BlancoFileManagerImportTask extends Task {
    /**
     * ファイルを blancoFileManager 管理テーブルに情報取り込みます。
     */
    protected BlancoFileManagerImportProcessInput fInput = new BlancoFileManagerImportProcessInput();

    /**
     * フィールド [inputdir] に値がセットされたかどうか。
     */
    protected boolean fIsFieldInputdirProcessed = false;

    /**
     * フィールド [projectname] に値がセットされたかどうか。
     */
    protected boolean fIsFieldProjectnameProcessed = false;

    /**
     * フィールド [multiproject] に値がセットされたかどうか。
     */
    protected boolean fIsFieldMultiprojectProcessed = false;

    /**
     * フィールド [jdbcdriver] に値がセットされたかどうか。
     */
    protected boolean fIsFieldJdbcdriverProcessed = false;

    /**
     * フィールド [jdbcurl] に値がセットされたかどうか。
     */
    protected boolean fIsFieldJdbcurlProcessed = false;

    /**
     * フィールド [jdbcuser] に値がセットされたかどうか。
     */
    protected boolean fIsFieldJdbcuserProcessed = false;

    /**
     * フィールド [jdbcpassword] に値がセットされたかどうか。
     */
    protected boolean fIsFieldJdbcpasswordProcessed = false;

    /**
     * verboseモードで動作させるかどうか。
     *
     * @param arg verboseモードで動作させるかどうか。
     */
    public void setVerbose(final boolean arg) {
        fInput.setVerbose(arg);
    }

    /**
     * verboseモードで動作させるかどうか。
     *
     * @return verboseモードで動作させるかどうか。
     */
    public boolean getVerbose() {
        return fInput.getVerbose();
    }

    /**
     * Antタスクの[inputdir]アトリビュートのセッターメソッド。
     *
     * 項目番号: 1<br>
     * 管理テーブルに取り込む対象となるファイルが含まれたディレクトリ。<br>
     *
     * @param arg セットしたい値
     */
    public void setInputdir(final String arg) {
        fInput.setInputdir(arg);
        fIsFieldInputdirProcessed = true;
    }

    /**
     * Antタスクの[inputdir]アトリビュートのゲッターメソッド。
     *
     * 項目番号: 1<br>
     * 管理テーブルに取り込む対象となるファイルが含まれたディレクトリ。<br>
     * 必須アトリビュートです。Apache Antタスク上で必ず値が指定されます。<br>
     *
     * @return このフィールドの値
     */
    public String getInputdir() {
        return fInput.getInputdir();
    }

    /**
     * Antタスクの[projectname]アトリビュートのセッターメソッド。
     *
     * 項目番号: 2<br>
     * 管理上のプロジェクト名を指定します。multiprojectが指定された場合は、この指定は無効になります。<br>
     *
     * @param arg セットしたい値
     */
    public void setProjectname(final String arg) {
        fInput.setProjectname(arg);
        fIsFieldProjectnameProcessed = true;
    }

    /**
     * Antタスクの[projectname]アトリビュートのゲッターメソッド。
     *
     * 項目番号: 2<br>
     * 管理上のプロジェクト名を指定します。multiprojectが指定された場合は、この指定は無効になります。<br>
     * デフォルト値[NONAME]が設定されています。Apache Antタスク上でアトリビュートの指定が無い場合には、デフォルト値が設定されます。<br>
     *
     * @return このフィールドの値
     */
    public String getProjectname() {
        return fInput.getProjectname();
    }

    /**
     * Antタスクの[multiproject]アトリビュートのセッターメソッド。
     *
     * 項目番号: 3<br>
     * マルチプロジェクトかどうかを指定します。このパラメータを指定した場合は、projectname 名指定は無効になります。<br>
     *
     * @param arg セットしたい値
     */
    public void setMultiproject(final boolean arg) {
        fInput.setMultiproject(arg);
        fIsFieldMultiprojectProcessed = true;
    }

    /**
     * Antタスクの[multiproject]アトリビュートのゲッターメソッド。
     *
     * 項目番号: 3<br>
     * マルチプロジェクトかどうかを指定します。このパラメータを指定した場合は、projectname 名指定は無効になります。<br>
     * デフォルト値[false]が設定されています。Apache Antタスク上でアトリビュートの指定が無い場合には、デフォルト値が設定されます。<br>
     *
     * @return このフィールドの値
     */
    public boolean getMultiproject() {
        return fInput.getMultiproject();
    }

    /**
     * Antタスクの[jdbcdriver]アトリビュートのセッターメソッド。
     *
     * 項目番号: 4<br>
     * JDBC ドライバクラス名。\n例: org.apache.derby.jdbc.EmbeddedDriver<br>
     *
     * @param arg セットしたい値
     */
    public void setJdbcdriver(final String arg) {
        fInput.setJdbcdriver(arg);
        fIsFieldJdbcdriverProcessed = true;
    }

    /**
     * Antタスクの[jdbcdriver]アトリビュートのゲッターメソッド。
     *
     * 項目番号: 4<br>
     * JDBC ドライバクラス名。\n例: org.apache.derby.jdbc.EmbeddedDriver<br>
     * 必須アトリビュートです。Apache Antタスク上で必ず値が指定されます。<br>
     *
     * @return このフィールドの値
     */
    public String getJdbcdriver() {
        return fInput.getJdbcdriver();
    }

    /**
     * Antタスクの[jdbcurl]アトリビュートのセッターメソッド。
     *
     * 項目番号: 5<br>
     * JDBC 接続先 URL。\n例: jdbc:derby:tmp/derby.db;create=true<br>
     *
     * @param arg セットしたい値
     */
    public void setJdbcurl(final String arg) {
        fInput.setJdbcurl(arg);
        fIsFieldJdbcurlProcessed = true;
    }

    /**
     * Antタスクの[jdbcurl]アトリビュートのゲッターメソッド。
     *
     * 項目番号: 5<br>
     * JDBC 接続先 URL。\n例: jdbc:derby:tmp/derby.db;create=true<br>
     * 必須アトリビュートです。Apache Antタスク上で必ず値が指定されます。<br>
     *
     * @return このフィールドの値
     */
    public String getJdbcurl() {
        return fInput.getJdbcurl();
    }

    /**
     * Antタスクの[jdbcuser]アトリビュートのセッターメソッド。
     *
     * 項目番号: 6<br>
     * JDBC 接続時のユーザー。\n例: user<br>
     *
     * @param arg セットしたい値
     */
    public void setJdbcuser(final String arg) {
        fInput.setJdbcuser(arg);
        fIsFieldJdbcuserProcessed = true;
    }

    /**
     * Antタスクの[jdbcuser]アトリビュートのゲッターメソッド。
     *
     * 項目番号: 6<br>
     * JDBC 接続時のユーザー。\n例: user<br>
     * 必須アトリビュートです。Apache Antタスク上で必ず値が指定されます。<br>
     *
     * @return このフィールドの値
     */
    public String getJdbcuser() {
        return fInput.getJdbcuser();
    }

    /**
     * Antタスクの[jdbcpassword]アトリビュートのセッターメソッド。
     *
     * 項目番号: 7<br>
     * JDBC 接続時のパスワード。\n例: password<br>
     *
     * @param arg セットしたい値
     */
    public void setJdbcpassword(final String arg) {
        fInput.setJdbcpassword(arg);
        fIsFieldJdbcpasswordProcessed = true;
    }

    /**
     * Antタスクの[jdbcpassword]アトリビュートのゲッターメソッド。
     *
     * 項目番号: 7<br>
     * JDBC 接続時のパスワード。\n例: password<br>
     * 必須アトリビュートです。Apache Antタスク上で必ず値が指定されます。<br>
     *
     * @return このフィールドの値
     */
    public String getJdbcpassword() {
        return fInput.getJdbcpassword();
    }

    /**
     * Antタスクのメイン処理。Apache Antから このメソッドが呼び出されます。
     *
     * @throws BuildException タスクとしての例外が発生した場合。
     */
    @Override
    public final void execute() throws BuildException {
        System.out.println("BlancoFileManagerImportTask begin.");

        // 項目番号[1]、アトリビュート[inputdir]は必須入力です。入力チェックを行います。
        if (fIsFieldInputdirProcessed == false) {
            throw new BuildException("必須アトリビュート[inputdir]が設定されていません。処理を中断します。");
        }
        // 項目番号[4]、アトリビュート[jdbcdriver]は必須入力です。入力チェックを行います。
        if (fIsFieldJdbcdriverProcessed == false) {
            throw new BuildException("必須アトリビュート[jdbcdriver]が設定されていません。処理を中断します。");
        }
        // 項目番号[5]、アトリビュート[jdbcurl]は必須入力です。入力チェックを行います。
        if (fIsFieldJdbcurlProcessed == false) {
            throw new BuildException("必須アトリビュート[jdbcurl]が設定されていません。処理を中断します。");
        }
        // 項目番号[6]、アトリビュート[jdbcuser]は必須入力です。入力チェックを行います。
        if (fIsFieldJdbcuserProcessed == false) {
            throw new BuildException("必須アトリビュート[jdbcuser]が設定されていません。処理を中断します。");
        }
        // 項目番号[7]、アトリビュート[jdbcpassword]は必須入力です。入力チェックを行います。
        if (fIsFieldJdbcpasswordProcessed == false) {
            throw new BuildException("必須アトリビュート[jdbcpassword]が設定されていません。処理を中断します。");
        }

        if (getVerbose()) {
            System.out.println("- verbose:[true]");
            System.out.println("- inputdir:[" + getInputdir() + "]");
            System.out.println("- projectname:[" + getProjectname() + "]");
            System.out.println("- multiproject:[" + getMultiproject() + "]");
            System.out.println("- jdbcdriver:[" + getJdbcdriver() + "]");
            System.out.println("- jdbcurl:[" + getJdbcurl() + "]");
            System.out.println("- jdbcuser:[" + getJdbcuser() + "]");
            System.out.println("- jdbcpassword:[" + getJdbcpassword() + "]");
        }

        try {
            // 実際のAntタスクの主処理を実行します。
            // この箇所でコンパイルエラーが発生する場合、BlancoFileManagerImportProcessインタフェースを実装して blanco.filemanager.taskパッケージに BlancoFileManagerImportProcessImplクラスを作成することにより解決できる場合があります。
            final BlancoFileManagerImportProcess proc = new BlancoFileManagerImportProcessImpl();
            if (proc.execute(fInput) != BlancoFileManagerImportBatchProcess.END_SUCCESS) {
                throw new BuildException("タスクは異常終了しました。");
            }
        } catch (IllegalArgumentException e) {
            if (getVerbose()) {
                e.printStackTrace();
            }
            throw new BuildException(e.getMessage());
        } catch (Exception e) {
            e.printStackTrace();
            throw new BuildException("タスクを処理中に例外が発生しました。処理を中断します。" + e.toString());
        } catch (Error e) {
            e.printStackTrace();
            throw new BuildException("タスクを処理中にエラーが発生しました。処理を中断します。" + e.toString());
        }
    }
}
