package blanco.filemanager.task;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.List;

import blanco.excelapi.BlancoExcelBookFactory;
import blanco.excelapi.BlancoExcelBookWriter;
import blanco.filemanager.BlancoFileManagerConstats;
import blanco.filemanager.core.BlancoFileManagerDbCore;
import blanco.filemanager.db.dao.BlancoFileManagerFileAttrInfoDao;
import blanco.filemanager.db.dao.BlancoFileManagerFileDescDao;
import blanco.filemanager.db.dao.BlancoFileManagerFileInfoDao;
import blanco.filemanager.file.BlancoFileManagerFileAttrInfo;
import blanco.filemanager.file.BlancoFileManagerFileDesc;
import blanco.filemanager.file.BlancoFileManagerFileInfo;
import blanco.filemanager.task.valueobject.BlancoFileManagerReportProcessInput;

public class BlancoFileManagerReportProcessImpl implements BlancoFileManagerReportProcess {

    @Override
    public int execute(final BlancoFileManagerReportProcessInput input) throws IOException, IllegalArgumentException {
        System.err.println("BlancoFileManagerReportTask (" + BlancoFileManagerConstats.getVersion() + ")");

        final File templatefile = new File(input.getTemplatefile());
        final File outputfile = new File(input.getOutputfile());
        if (templatefile.exists() == false) {
            System.out.println("指定されたテンプレートファイル[" + templatefile.getCanonicalPath() + "]が見つかりませんでした。");
            return 9;
        }
        if (templatefile.isFile() == false) {
            System.out.println("指定されたテンプレートファイル[" + templatefile.getCanonicalPath() + "]が実際にはファイルではありませんでした。");
            return 9;
        }
        if (outputfile.exists() && outputfile.canWrite() == false) {
            System.out.println("指定された出力先ファイル[" + templatefile.getCanonicalPath() + "]がすでに存在するうえに書き込みができませんでした。");
            return 9;
        }
        if (outputfile.exists() && outputfile.isFile() == false) {
            System.out.println("指定された出力先ファイル[" + templatefile.getCanonicalPath() + "]がすでに存在するうえにファイルではありませんでした。");
            return 9;
        }
        if (outputfile.getParentFile().exists() == false) {
            if (outputfile.getParentFile().mkdirs() == false) {
                System.out.println("指定された出力先ファイル[" + templatefile.getCanonicalPath()
                        + "]が所属する予定のディレクトリが無かったために新規作成しようとしましたが失敗しました。");
                return 9;
            }
        }

        System.out.println("ファイル情報の管理情報を[" + outputfile.getCanonicalPath() + "]に出力します。");

        try {
            final Connection conn = BlancoFileManagerDbCore.getBatchConnection(input.getJdbcdriver(),
                    input.getJdbcurl(), input.getJdbcuser(), input.getJdbcpassword());

            {
                // TODO 現在は xls 限定になっています。xlsx もサポートすべきなのかな?
                final BlancoExcelBookWriter writer = BlancoExcelBookFactory.getXLSWriterInstance();
                writer.open(new BufferedOutputStream(new FileOutputStream(outputfile)), new BufferedInputStream(
                        new FileInputStream(templatefile)));

                // プロジェクトを入力してファイル情報の一覧を取得します。
                final List<BlancoFileManagerFileInfo> fileInfoList = new BlancoFileManagerFileInfoDao()
                        .getListByProject(conn, input.getProjectname());

                int lineNo = 4;
                for (BlancoFileManagerFileInfo fileInfo : fileInfoList) {
                    // ファイルID
                    writer.setNumber(0, lineNo, fileInfo.getFileId(), 0, 4);
                    // ファイル名
                    writer.setText(1, lineNo, fileInfo.getFileName(), 1, 4);
                    // 状態
                    writer.setText(2, lineNo, fileInfo.getFileStatFlgDisplayString(), 2, 4);
                    // 追加・変更・削除
                    writer.setText(3, lineNo, fileInfo.getFileChangeFlgDisplayString(), 3, 4);
                    // ファイル種別
                    writer.setText(4, lineNo, fileInfo.getFileType(), 4, 4);
                    // プロジェクト
                    writer.setText(5, lineNo, fileInfo.getProject(), 5, 4);

                    // ファイルパス
                    writer.setText(6, lineNo, fileInfo.getFilePath(), 6, 4);

                    // 説明
                    {
                        final SimpleDateFormat sdf = new SimpleDateFormat("MM/dd");
                        final StringBuffer descMsg = new StringBuffer();
                        boolean isFirstDesc = true;
                        for (BlancoFileManagerFileDesc fileDesc : new BlancoFileManagerFileDescDao().getFileDescList(
                                conn, fileInfo.getFileId())) {
                            if (isFirstDesc) {
                                isFirstDesc = false;
                            } else {
                                // 改行を挟み込みます。
                                descMsg.append("\n");
                            }
                            descMsg.append("[" + sdf.format(fileDesc.getFileDescDt()) + " "
                                    + fileDesc.getFileDescUsername() + "] " + fileDesc.getFileDesc());
                        }
                        writer.setText(7, lineNo, descMsg.toString(), 7, 4);
                    }

                    // 行数
                    {
                        final BlancoFileManagerFileAttrInfo attr = new BlancoFileManagerFileAttrInfoDao()
                                .getLastFileAttrInfo(conn, fileInfo.getFileId());
                        writer.setNumber(8, lineNo, attr.getFileSize(), 8, 4);

                        if (attr.getValidLineCount() >= 0) {
                            writer.setNumber(9, lineNo, attr.getValidLineCount(), 9, 4);
                        } else {
                            writer.setText(9, lineNo, "", 9, 4);
                        }
                        if (attr.getCommentLineCount() >= 0) {
                            writer.setNumber(10, lineNo, attr.getCommentLineCount(), 10, 4);
                        } else {
                            writer.setText(10, lineNo, "", 10, 4);
                        }
                        if (attr.getBlankLineCount() >= 0) {
                            writer.setNumber(11, lineNo, attr.getBlankLineCount(), 11, 4);
                        } else {
                            writer.setText(11, lineNo, "", 11, 4);
                        }
                        if (attr.getModifiedLineCount() >= 0) {
                            writer.setNumber(12, lineNo, attr.getModifiedLineCount(), 12, 4);
                        } else {
                            writer.setText(12, lineNo, "", 12, 4);
                        }
                    }

                    lineNo++;
                }

                writer.close();
            }
        } catch (SQLException ex) {
            throw new IOException("処理中にSQL例外が発生:" + ex.toString(), ex);
        }

        return 0;
    }

    @Override
    public boolean progress(String argProgressMessage) {
        return false;
    }
}
