/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.bli.testingframework;

import java.sql.Connection;
import java.sql.PreparedStatement;
import javax.sql.DataSource;
import jp.co.dgic.testing.framework.DJUnitTestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dbunit.database.DatabaseConnection;
import org.dbunit.database.IDatabaseConnection;
import org.springframework.context.ApplicationContext;
import org.springframework.dao.DataAccessException;

public class BliDbUnitTestCase
extends DJUnitTestCase {
    protected ApplicationContext context = null;
    protected String truncateSql = "";
    protected boolean oracleFlag = false;
    protected Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    protected String classNameStr = ((Object)((Object)this)).getClass().getSimpleName();

    public BliDbUnitTestCase() {
    }

    public BliDbUnitTestCase(String name) {
        super(name);
    }

    public IDatabaseConnection getConnection(boolean autoComit) throws Exception {
        DataSource ds = (DataSource)this.context.getBean("dataSource");
        Connection con = ds.getConnection();
        if (autoComit) {
            con.setAutoCommit(true);
        } else {
            con.setAutoCommit(false);
        }
        if (this.oracleFlag) {
            String schema = con.getMetaData().getUserName();
            return new DatabaseConnection(con, schema);
        }
        return new DatabaseConnection(con);
    }

    public IDatabaseConnection getConnection(Connection con) throws Exception {
        con.setAutoCommit(false);
        if (this.oracleFlag) {
            String schema = con.getMetaData().getUserName();
            return new DatabaseConnection(con, schema);
        }
        return new DatabaseConnection(con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tableInit(Connection con) {
        PreparedStatement ps = null;
        try {
            ps = con.prepareStatement(this.truncateSql);
            ps.execute();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    protected void logStart(String testMethodName) {
        this.log.info((Object)("Test Method Start ******************** " + this.classNameStr + "." + testMethodName + " ********************"));
    }

    protected void logEnd(String testMethodName) {
        this.log.info((Object)("Test Method End ******************** " + this.classNameStr + "." + testMethodName + " ********************"));
    }

    protected void logging(String testMethodName, String logMainStr) {
        this.log.info((Object)(this.classNameStr + "." + testMethodName + ":" + logMainStr));
    }

    public static class MockDataAccessException
    extends DataAccessException {
        private static final long serialVersionUID = 1L;

        public MockDataAccessException() {
            super("");
        }
    }
}

