/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.bli.framework.ss;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import jp.sf.bli.framework.common.util.FrameworkUtil;
import jp.sf.bli.framework.logging.Logging;
import jp.sf.bli.framework.ss.BusinessLogicCtrlSS;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BliStrutsAction
extends Action {
    private static final String LOG_MESSAGE = "Fatal error occurred.";
    private static final String START_LOG_MESSAGE = "BliStrutsAction started:";
    private static final String PARAM_LOG_MESSAGE = "Parameter:";
    private static final String END_LOG_MESSAGE = "BliStrutsAction ended:";
    private static final String END_LOG_FOWARD = " foward:";
    private static final String TIME_LOG_MESSAGE = " Processing time:";
    private BusinessLogicCtrlSS blCtrl = null;
    private String loginId = "";
    private List<String> loginRole = null;
    private String loginChkFlag = "1";
    private String mesInitFlag = "0";

    public String getMesInitFlag() {
        return this.mesInitFlag;
    }

    public void setMesInitFlag(String mesInitFlag) {
        this.mesInitFlag = mesInitFlag;
    }

    public void setBlCtrl(BusinessLogicCtrlSS blCtrl) {
        this.blCtrl = blCtrl;
    }

    public BusinessLogicCtrlSS getBlCtrl() {
        return this.blCtrl;
    }

    public String getLoginChkFlag() {
        return this.loginChkFlag;
    }

    public void setLoginChkFlag(String loginChkFlag) {
        this.loginChkFlag = loginChkFlag;
    }

    public String getLoginId() {
        return this.loginId;
    }

    public void setLoginId(String loginId) {
        this.loginId = loginId;
    }

    public List<String> getLoginRole() {
        return this.loginRole;
    }

    public void setLoginRole(List<String> loginRole) {
        if (loginRole == null) {
            loginRole = new ArrayList<String>();
        }
        this.loginRole = loginRole;
    }

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res) {
        long start = System.currentTimeMillis();
        ServletContext sc = null;
        HttpSession session = null;
        String fowardName = null;
        boolean fatalFlag = false;
        String fatalLogCount = "";
        ActionForward actionForward = null;
        try {
            sc = super.getServlet().getServletContext();
            session = req.getSession();
            this.loginId = this.getLoginId(session);
            this.loginRole = this.getLoginRole(session);
            fowardName = this.loginChk(req);
            this.loggingStart(req);
            this.mesInit(session);
            if (fowardName == null) {
                fowardName = this.doProcessBefore(sc, session, req, res);
            }
            if (fowardName == null) {
                fowardName = this.doProcess(mapping, form, sc, session, req, res);
                this.doProcessAfter(mapping, form, sc, session, req, res);
            }
        }
        catch (Exception e) {
            Logging.fatal(((Object)((Object)this)).getClass(), "BLI000013", this.loginId, "Fatal error occurred. " + e.getMessage());
            e.printStackTrace();
            fowardName = "fatal";
            fatalFlag = true;
            fatalLogCount = "BLI000013";
        }
        this.loggingEnd(start, fowardName);
        actionForward = this.forwardSet(mapping, session, fowardName, fatalFlag, fatalLogCount);
        return actionForward;
    }

    protected String loginChk(HttpServletRequest req) {
        String rtnStr = null;
        String clientAdd = req.getRemoteAddr();
        String reqURL = null;
        try {
            reqURL = req.getRequestURL().toString();
        }
        catch (NullPointerException e) {
            e.printStackTrace();
            reqURL = null;
        }
        if (this.loginChkFlag.equals("0")) {
            if (this.loginId == null || this.loginId.equals("") || this.loginId.equals("noLognId")) {
                rtnStr = "nologin";
                Logging.error(((Object)((Object)this)).getClass(), "BLI000003", this.loginId, "Login Error : NoLoginUser Access IP: " + clientAdd + " URL: " + reqURL);
            }
        } else {
            Logging.debug(((Object)((Object)this)).getClass(), "BLI000004", this.loginId, "No Login Check IP: " + clientAdd + " URL: " + reqURL);
        }
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("Audit Log. Login Role : [ ");
        Iterator<String> itr = this.loginRole.iterator();
        while (itr.hasNext()) {
            sbuf = sbuf.append(itr.next());
            sbuf = sbuf.append(" ");
        }
        sbuf.append("]");
        Logging.info(((Object)((Object)this)).getClass(), "BLI000005", this.loginId, sbuf.toString() + " IP: " + clientAdd + " URL: " + reqURL);
        return rtnStr;
    }

    protected ActionForward forwardSet(ActionMapping mapping, HttpSession session, String fowardName, boolean fatalFlag, String fatalLogCount) {
        ActionForward actionForward = null;
        if (fowardName == null) {
            actionForward = null;
        } else {
            if (fatalFlag) {
                String errorMes = "System Fatal Error. Please, contact system administrator. loginId:[" + this.loginId + "] logCount:[" + fatalLogCount + "]";
                FrameworkUtil.setSessionErrorMes(session, errorMes, 0);
            }
            actionForward = mapping.findForward(fowardName);
        }
        return actionForward;
    }

    protected void loggingEnd(long start, String fowardName) {
        StringBuffer message = new StringBuffer();
        message.append(END_LOG_MESSAGE);
        message.append(END_LOG_FOWARD);
        message.append(fowardName);
        message.append(TIME_LOG_MESSAGE);
        message.append(System.currentTimeMillis() - start);
        Logging.info(((Object)((Object)this)).getClass(), "BLI000002", this.loginId, message.toString());
    }

    protected void loggingStart(HttpServletRequest req) {
        Map parameterMap = req.getParameterMap();
        StringBuffer message = new StringBuffer();
        message.append(START_LOG_MESSAGE);
        message.append(PARAM_LOG_MESSAGE);
        if (parameterMap != null) {
            if (parameterMap.size() != 0) {
                for (String key : parameterMap.keySet()) {
                    String[] keys = req.getParameterValues(key);
                    for (int i = 0; keys.length > i; ++i) {
                        message.append(" [");
                        message.append(key);
                        message.append("=");
                        message.append(keys[i]);
                        message.append("]");
                    }
                }
            } else {
                message.append(" [ No Parameter ]");
            }
        }
        Logging.info(((Object)((Object)this)).getClass(), "BLI000001", this.loginId, message.toString());
    }

    public abstract String doProcessBefore(ServletContext var1, HttpSession var2, HttpServletRequest var3, HttpServletResponse var4) throws Exception;

    public abstract String doProcess(ActionMapping var1, ActionForm var2, ServletContext var3, HttpSession var4, HttpServletRequest var5, HttpServletResponse var6) throws Exception;

    public abstract void doProcessAfter(ActionMapping var1, ActionForm var2, ServletContext var3, HttpSession var4, HttpServletRequest var5, HttpServletResponse var6) throws Exception;

    public String getLoginId(HttpSession session) {
        String loginId = (String)session.getAttribute("sessionKeyLoginId");
        if (loginId == null) {
            loginId = "noLognId";
        }
        return loginId;
    }

    public List<String> getLoginRole(HttpSession session) {
        ArrayList loginRole = (ArrayList)session.getAttribute("essionKeyLoginRole");
        if (loginRole == null) {
            loginRole = new ArrayList();
        }
        return loginRole;
    }

    public void mesInit(HttpSession session) {
        if (this.mesInitFlag.equals("0")) {
            session.removeAttribute("sessionKeyErrorMes");
            session.removeAttribute("sessionKeyMes");
        }
    }
}

