/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.bli.framework.ss;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import jp.sf.bli.framework.common.BusinessLogicException;
import jp.sf.bli.framework.common.util.FrameworkUtil;
import jp.sf.bli.framework.logging.Logging;
import jp.sf.bli.framework.ss.BusinessLogicDoSS;
import jp.sf.bli.framework.ss.BusinessLogicValidateSS;
import org.apache.struts.action.ActionForm;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BusinessLogicCtrlSS {
    protected String loginId = "";
    protected BusinessLogicValidateSS blValidate = null;
    protected List<BusinessLogicDoSS> blList = null;
    protected Map<String, Object> inputValueMap = null;
    protected Map<String, Object> outputValueMap = null;

    public List<BusinessLogicDoSS> getBlList() {
        return this.blList;
    }

    public BusinessLogicValidateSS getBlValidate() {
        return this.blValidate;
    }

    public Map<String, Object> getInputValueMap() {
        return this.inputValueMap;
    }

    public void setInputValueMap(Map<String, Object> inputValueMap) {
        this.inputValueMap = inputValueMap;
    }

    public Map<String, Object> getOutputValueMap() {
        return this.outputValueMap;
    }

    public void setOutputValueMap(Map<String, Object> outputValueMap) {
        this.outputValueMap = outputValueMap;
    }

    public String getLoginId() {
        return this.loginId;
    }

    public void setLoginId(String loginId) {
        this.loginId = loginId;
    }

    public void setBlValidate(BusinessLogicValidateSS blValidate) {
        this.blValidate = blValidate;
    }

    public void setBlList(List<BusinessLogicDoSS> blList) {
        this.blList = blList;
    }

    public int doBizCtrl(ServletContext sc, HttpSession session, HttpServletResponse res, HttpServletRequest req, ActionForm form) throws BusinessLogicException {
        int resultFlagInt = -1000;
        try {
            this.init(session);
            this.initProcess(sc, session, res, req, form);
            this.parameter2InputValueMap(sc, session, res, req, form);
            this.blDoLoop(session, this.doVaildate(session));
            this.viewDispSet(sc, session, res, req, form);
            this.endProcess(sc, session, res, req, form);
            this.end(sc, session, res, req);
        }
        catch (Exception e) {
            Logging.fatal(this.getClass(), "BLI000006", this.getLoginId(), "doBizCtrl:BLCtrl catch Exception. " + e.getMessage());
            e.printStackTrace();
            throw new BusinessLogicException("LogCount\uff1aBLI000006");
        }
        resultFlagInt = (Integer)this.outputValueMap.get("resultFlag");
        return resultFlagInt;
    }

    public void init(HttpSession session) throws Exception {
        this.setLoginId(FrameworkUtil.getLoginId(session));
        this.inputValueMap = new HashMap<String, Object>();
        this.outputValueMap = new HashMap<String, Object>();
        Logging.debug(this.getClass(), "BLI000007", this.getLoginId(), "doBizCtrl:BLCtrl started.");
    }

    protected abstract void initProcess(ServletContext var1, HttpSession var2, HttpServletResponse var3, HttpServletRequest var4, ActionForm var5) throws Exception;

    protected abstract void parameter2InputValueMap(ServletContext var1, HttpSession var2, HttpServletResponse var3, HttpServletRequest var4, ActionForm var5) throws Exception;

    protected int doVaildate(HttpSession session) throws Exception {
        int resultFlagInt = 0;
        Integer resultFlag = null;
        if (this.blValidate != null) {
            this.blValidate.doValidate(this.loginId, this.inputValueMap, this.outputValueMap);
            resultFlag = (Integer)this.outputValueMap.get("resultFlag");
            if (resultFlag == null || resultFlag == 0) {
                String errorMes = (String)this.outputValueMap.get("mapKeyErrorMes");
                FrameworkUtil.setSessionErrorMes(session, errorMes, 1);
                if (resultFlag == null) {
                    resultFlagInt = -999;
                    resultFlag = -999;
                    this.outputValueMap.put("resultFlag", resultFlagInt);
                }
                Logging.error(this.getClass(), "BLI000008", this.getLoginId(), "doBizCtrl:Validate ended because of the error. rtnFlag:[" + resultFlag + "] errerMes:[" + errorMes + "]");
            }
        } else {
            resultFlag = -1000;
        }
        resultFlagInt = resultFlag;
        return resultFlagInt;
    }

    protected void blDoLoop(HttpSession session, int resultFlagInt) throws Exception {
        if (resultFlagInt != -999 && resultFlagInt != 0) {
            Iterator<BusinessLogicDoSS> itr = this.blList.iterator();
            while (itr.hasNext()) {
                Logging.debug(this.getClass(), "BLI000009", this.getLoginId(), "blDoLoop:BusineesLogicDo Strat");
                BusinessLogicDoSS blDo = itr.next();
                if (!this.doBL(session, blDo)) {
                    Logging.debug(this.getClass(), "BLI000010", this.getLoginId(), "blDoLoop:BusineesLogicDo No Normal End");
                    Integer resultFlag = (Integer)this.outputValueMap.get("resultFlag");
                    resultFlagInt = resultFlag;
                    if (resultFlagInt == -999 || resultFlagInt == 0) {
                        Logging.debug(this.getClass(), "BLI000011", this.getLoginId(), "blDoLoop:break; resultFlag:" + resultFlagInt);
                        break;
                    }
                }
                Logging.debug(this.getClass(), "BLI000012", this.getLoginId(), "blDoLoop:BusineesLogicDo Normal End");
            }
        }
    }

    protected boolean doBL(HttpSession session, BusinessLogicDoSS blDo) throws Exception {
        boolean rtnFlag = true;
        blDo.doBizLogic(this.loginId, this.inputValueMap, this.outputValueMap);
        Integer resultFlag = (Integer)this.outputValueMap.get("resultFlag");
        if (resultFlag == null || resultFlag == 0) {
            rtnFlag = false;
            String errorMes = (String)this.outputValueMap.get("mapKeyErrorMes");
            FrameworkUtil.setSessionErrorMes(session, errorMes, 0);
            if (resultFlag == null) {
                resultFlag = -999;
                this.outputValueMap.put("resultFlag", resultFlag);
            }
            Logging.error(this.getClass(), "BLI000012", this.getLoginId(), "doBizCtrl:Validate ended because of the error. rtnFlag:[" + resultFlag + "] errerMes:[" + errorMes + "]");
        }
        return rtnFlag;
    }

    protected abstract void viewDispSet(ServletContext var1, HttpSession var2, HttpServletResponse var3, HttpServletRequest var4, ActionForm var5) throws Exception;

    protected abstract void endProcess(ServletContext var1, HttpSession var2, HttpServletResponse var3, HttpServletRequest var4, ActionForm var5) throws Exception;

    protected void end(ServletContext sc, HttpSession session, HttpServletResponse res, HttpServletRequest req) throws Exception {
        Logging.debug(this.getClass(), "BLI000013", this.loginId, "doBizCtrl:BLCtrl ended normally. rtnFlag:[0]");
    }
}

