/*
 * Copyright (C) 2006-2007 BLI Project
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms,
 * with or without modification, are permitted provided
 * that the following conditions are
 * met:
 * 
 * 1. Redistributions of source code must retain
 * the above copyright notice, this list of conditions
 * and the following disclaimer as the first lines of this file unmodified.
 * 
 * 2. Redistributions  in  binary  form must reproduce 
 * the above copyright notice, this list of conditions 
 * and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 *  OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package jp.sf.bli.ss.sample;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import jp.sf.bli.framework.ss.BliStrutsAction;
import jp.sf.bli.framework.ss.BusinessLogicCtrlSS;

import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;

/**
 * @author takeda 2007/02/12
 */
public class SampleAction extends BliStrutsAction {

    /*
     * (non-Javadoc)
     * 
     * @see jp.sf.bli.framework.bl.AbstractBliAction#doProcess(org.apache.struts.action.ActionMapping,
     *      org.apache.struts.action.ActionForm, javax.servlet.ServletContext,
     *      javax.servlet.http.HttpSession,
     *      javax.servlet.http.HttpServletRequest,
     *      javax.servlet.http.HttpServletResponse)
     */
    @Override
    public String doProcess( ActionMapping mapping, ActionForm form,
            ServletContext sc, HttpSession session, HttpServletRequest req,
            HttpServletResponse res ) throws Exception {

        String forward = "";

        int forwardWay = 0; // failureで初期化

        try {

            BusinessLogicCtrlSS blCtrl = this.getBlCtrl();

            forwardWay = blCtrl.doBizCtrl( sc, session, res, req, form );

            switch ( forwardWay ) {
                case 0:

                    // doBizLogicエラーあり
                    forward = "failure";
                    break;

                case 1:

                    // doBizLogicエラーなし
                    forward = "success";
                    break;

                default:

                    // doBizLogic未定義返り値の為、エラーあり
                    forward = "failure";
            }

        } catch ( Exception e ) {

            e.printStackTrace();
            forward = "fatal";

        }

        return forward;
    }


    /*
     * (non-Javadoc)
     * 
     * @see jp.sf.bli.framework.bl.AbstractBliAction#doProcessAfter(org.apache.struts.action.ActionMapping,
     *      org.apache.struts.action.ActionForm, javax.servlet.ServletContext,
     *      javax.servlet.http.HttpSession,
     *      javax.servlet.http.HttpServletRequest,
     *      javax.servlet.http.HttpServletResponse)
     */
    @Override
    public void doProcessAfter( ActionMapping mapping, ActionForm form,
            ServletContext sc, HttpSession session, HttpServletRequest req,
            HttpServletResponse res ) throws Exception {

        // 実装なし

    }


    /*
     * (non-Javadoc)
     * 
     * @see jp.sf.bli.framework.bl.AbstractBliAction#doProcessBefore(javax.servlet.ServletContext,
     *      javax.servlet.http.HttpSession,
     *      javax.servlet.http.HttpServletRequest,
     *      javax.servlet.http.HttpServletResponse)
     */
    @Override
    public String doProcessBefore( ServletContext sc, HttpSession session,
            HttpServletRequest req, HttpServletResponse res ) throws Exception {

        // 実装なし
        return null;
    }

}
