/*
 * Copyright (C) 2006-2007 BLI Project
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms,
 * with or without modification, are permitted provided
 * that the following conditions are
 * met:
 * 
 * 1. Redistributions of source code must retain
 * the above copyright notice, this list of conditions
 * and the following disclaimer as the first lines of this file unmodified.
 * 
 * 2. Redistributions  in  binary  form must reproduce 
 * the above copyright notice, this list of conditions 
 * and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 *  OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package jp.sf.bli.ss.sample;

import java.util.List;
import java.util.Map;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import jp.sf.bli.framework.ss.BusinessLogicCtrlSS;
import jp.sf.bli.ss.sample.model.Sample;

import org.apache.struts.action.ActionForm;

public class SampleBlCtrl extends BusinessLogicCtrlSS {

    /*
     * (non-Javadoc)
     * 
     * @see jp.sf.bli.framework.bl.BusinessLogicCtrl
     *      #initProcess(javax.servlet.ServletContext,
     *      javax.servlet.http.HttpSession,
     *      javax.servlet.http.HttpServletResponse,
     *      javax.servlet.http.HttpServletRequest,
     *      org.apache.struts.action.ActionForm, java.lang.String,
     *      java.util.Map, java.util.Map)
     */
    @Override
    protected void initProcess( ServletContext sc, HttpSession session,
            HttpServletResponse res, HttpServletRequest req, ActionForm form )
            throws Exception {

        // 処理なし

    }


    /*
     * (non-Javadoc)
     * 
     * @see jp.sf.bli.framework.bl.BusinessLogicCtrl
     *      #parameter2InputValueMap(javax.servlet.ServletContext,
     *      javax.servlet.http.HttpSession,
     *      javax.servlet.http.HttpServletResponse,
     *      javax.servlet.http.HttpServletRequest,
     *      org.apache.struts.action.ActionForm, java.lang.String,
     *      java.util.Map, java.util.Map)
     */
    @Override
    protected void parameter2InputValueMap( ServletContext sc,
            HttpSession session, HttpServletResponse res,
            HttpServletRequest req, ActionForm form ) throws Exception {

        /** 画面からの入力を格納したActionForm */
        SampleForm sampleForm = ( SampleForm ) form;

        // BL処理前データ格納
        Map< String, Object > inputValueMap = getInputValueMap();
        inputValueMap.put( "age", sampleForm.getAge() );
        inputValueMap.put( "name", sampleForm.getName() );
    }


    /*
     * (non-Javadoc)
     * 
     * @see jp.sf.bli.framework.bl.BusinessLogicCtrl
     *      #viewDispSet(javax.servlet.ServletContext,
     *      javax.servlet.http.HttpSession,
     *      javax.servlet.http.HttpServletResponse,
     *      javax.servlet.http.HttpServletRequest,
     *      org.apache.struts.action.ActionForm, java.lang.String,
     *      java.util.Map, java.util.Map)
     */
    @SuppressWarnings ( "unchecked" )
    @Override
    protected void viewDispSet( ServletContext sc, HttpSession session,
            HttpServletResponse res, HttpServletRequest req, ActionForm form )
            throws Exception {

        // 処理後の画面の情報をinputValueMapとoutputValueMapから生成する
        Map< String, Object > inputValueMap = getInputValueMap();
        Map< String, Object > outputValueMap = getOutputValueMap();

        SampleForm sampleForm = ( SampleForm ) form;

        sampleForm.setAge( ( Integer ) inputValueMap.get( "age" ) );
        sampleForm.setName( ( String ) inputValueMap.get( "name" ) );
        sampleForm.setSampleList( ( List< Sample > ) outputValueMap
                .get( "sampleList" ) );

        // 処理後の画面の情報をHttpServletRequestにセットする。
        req.setAttribute( "sampleForm", sampleForm );

    }


    /*
     * (non-Javadoc)
     * 
     * @see jp.sf.bli.framework.bl.BusinessLogicCtrl
     *      #endProcess(javax.servlet.ServletContext,
     *      javax.servlet.http.HttpSession,
     *      javax.servlet.http.HttpServletResponse,
     *      javax.servlet.http.HttpServletRequest)
     */
    @Override
    protected void endProcess( ServletContext sc, HttpSession session,
            HttpServletResponse res, HttpServletRequest req, ActionForm form )
            throws Exception {

        // 処理なし

    }
}
