/*
 * Copyright (C) 2006-2007 BLI Project
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms,
 * with or without modification, are permitted provided
 * that the following conditions are
 * met:
 * 
 * 1. Redistributions of source code must retain
 * the above copyright notice, this list of conditions
 * and the following disclaimer as the first lines of this file unmodified.
 * 
 * 2. Redistributions  in  binary  form must reproduce 
 * the above copyright notice, this list of conditions 
 * and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 *  OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package jp.sf.bli.ss.sample;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import jp.sf.bli.framework.common.BusinessLogicException;
import jp.sf.bli.framework.common.Globals;
import jp.sf.bli.framework.ss.BusinessLogicValidateSS;

public class SampleBlValidate extends BusinessLogicValidateSS {

    /*
     * (non-Javadoc)
     * 
     * @see jp.sf.bli.framework.bl.BusinessLogicValidate#initProcess(java.lang.String,
     *      java.util.Map, java.util.Map)
     */
    @Override
    protected void initProcess( String loginName,
            Map< String, Object > inputValueMap,
            Map< String, Object > outputValueMap ) throws Exception {

        // 処理なし

    }


    /*
     * (non-Javadoc)
     * 
     * @see jp.sf.bli.framework.bl.BusinessLogicValidate#doValidateMain(java.lang.String,
     *      java.util.Map, java.util.Map)
     */
    @Override
    protected void doValidateMain( String loginName,
            Map< String, Object > inputValueMap,
            Map< String, Object > outputValueMap ) throws Exception {

        String errorMes = "";

        try {

            List< Object[] > checkList = new ArrayList< Object[] >();

            String name = ( String ) inputValueMap.get( "name" );

            Object[] objName = {
                    "name", name
            };

            checkList.add( objName );

            Integer age = ( Integer ) inputValueMap.get( "age" );

            Object[] objAge = {
                    "age", age
            };

            checkList.add( objAge );

            errorMes = validate( "name", checkList, 0 );

            outputValueMap.put( Globals.MAP_KEY_ERROR_MES, errorMes );

        } catch ( Exception e ) {

            e.printStackTrace();

            throw new BusinessLogicException(
                    "BizNewsTopValidate doValidate:ValidateException発生" );

        }

        // エラーメッセージをoutputValueMapへセットする
        outputValueMap.put( Globals.MAP_KEY_ERROR_MES, errorMes );

    }


    /*
     * (non-Javadoc)
     * 
     * @see jp.sf.bli.framework.bl.BusinessLogicValidate#endProcess(java.lang.String,
     *      java.util.Map, java.util.Map)
     */
    @Override
    protected void endProcess( String loginName,
            Map< String, Object > inputValueMap,
            Map< String, Object > outputValueMap ) throws Exception {

        // 処理なし

    }

}
