/*
 * Copyright (C) 2006-2007 BLI Project
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms,
 * with or without modification, are permitted provided
 * that the following conditions are
 * met:
 * 
 * 1. Redistributions of source code must retain
 * the above copyright notice, this list of conditions
 * and the following disclaimer as the first lines of this file unmodified.
 * 
 * 2. Redistributions  in  binary  form must reproduce 
 * the above copyright notice, this list of conditions 
 * and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 *  OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package jp.sf.bli.ss.sample;

import java.util.List;
import java.util.Map;

import jp.sf.bli.framework.common.Globals;
import jp.sf.bli.framework.ss.BusinessLogicDoSS;
import jp.sf.bli.ss.sample.dao.SampleDao;
import jp.sf.bli.ss.sample.model.Sample;

/**
 * @author takeda
 */
public class SampleSelectBlDo extends BusinessLogicDoSS {

    private SampleDao sampleDao = null;


    /**
     * @param sampleDao
     *            this.sampleDao = sampleDao
     */
    public void setSampleDao( SampleDao sampleDao ) {

        this.sampleDao = sampleDao;
    }


    /*
     * (non-Javadoc)
     * 
     * @see jp.sf.bli.framework.bl.BusinessLogicDo#initProcess(java.lang.String,
     *      java.util.Map, java.util.Map)
     */
    @Override
    protected void initProcess( String loginName,
            Map< String, Object > inputValueMap,
            Map< String, Object > outputValueMap ) throws Exception {

        // 初期処理なし
    }


    /*
     * (non-Javadoc)
     * 
     * @see jp.sf.bli.framework.bl.BusinessLogicDo
     *      #doBizLogicMain(java.lang.String, java.util.Map, java.util.Map)
     */
    @SuppressWarnings ( "unchecked" )
    @Override
    protected void doBizLogicMain( String loginName,
            Map< String, Object > inputValueMap,
            Map< String, Object > outputValueMap ) throws Exception {

        List< Sample > sampleList = this.sampleDao
                .selectSample( ( Integer ) inputValueMap.get( "id" ) );

        if ( sampleList == null || sampleList.size() == 0 ) {

            outputValueMap.put( Globals.RESULT_FLAG, Integer.valueOf( 0 ) );

        } else {
            outputValueMap.put( "sampleList", sampleList );
        }

    }


    /*
     * (non-Javadoc)
     * 
     * @see jp.sf.bli.framework.bl.BusinessLogicDo #endProcess(java.lang.String,
     *      java.util.Map, java.util.Map)
     */
    @Override
    protected void endProcess( String loginName, Map inputValueMap,
            Map outputValueMap ) throws Exception {

        // 終了処理なし
    }

}
