/*
 * Copyright (C) 2006-2007 BLI Project
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms,
 * with or without modification, are permitted provided
 * that the following conditions are
 * met:
 * 
 * 1. Redistributions of source code must retain
 * the above copyright notice, this list of conditions
 * and the following disclaimer as the first lines of this file unmodified.
 * 
 * 2. Redistributions  in  binary  form must reproduce 
 * the above copyright notice, this list of conditions 
 * and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 *  OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package jp.sf.bli.ss.sample.dao.impl.sample;

import java.util.List;

import jp.sf.bli.ss.sample.dao.SampleDao;

import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.support.JdbcDaoSupport;

/**
 * @author takeda 2007/02/06
 */
public class SampleDaoImpl extends JdbcDaoSupport implements SampleDao {

    /*
     * (non-Javadoc)
     * 
     * @see jp.sf.bli.sample.dao.Impl.SampleDaoImpl#selectAllSample()
     */
    public List selectAllSample() throws DataAccessException {

        RowMapper rowMapper = new SampleRowMapper();

        PreparedStatementCreator psc = new SelectAllSample();

        List rtnList = getJdbcTemplate().query( psc, rowMapper );

        return rtnList;
    }


    /*
     * (non-Javadoc)
     * 
     * @see jp.sf.bli.sample.dao.Impl.SampleDaoImpl#selectSample(java.lang.String)
     */
    public List selectSample( Integer id ) throws DataAccessException {

        RowMapper rowMapper = new SampleRowMapper();

        PreparedStatementCreator psc = new SelectIdSample( id );

        List rtnList = getJdbcTemplate().query( psc, rowMapper );

        return rtnList;
    }


    /*
     * (non-Javadoc)
     * 
     * @see jp.sf.bli.sample.dao.SampleDao#insertSample(java.lang.Integer,
     *      java.lang.String, java.lang.Integer)
     */
    public void insertSample( Integer id, String name, Integer age )
            throws DataAccessException {

        InsertSample insertSample = new InsertSample( getDataSource() );

        insertSample.update( new Object[] {
                id, name, age
        } );

    }


    /*
     * (non-Javadoc)
     * 
     * @see jp.sf.bli.sample.dao.SampleDao#updateSample(java.lang.Integer,
     *      java.lang.String, java.lang.Integer)
     */
    public void updateSample( Integer id, String name, Integer age )
            throws DataAccessException {

        UpdateSample updateSample = new UpdateSample( getDataSource() );

        updateSample.update( new Object[] {
                name, age, id
        } );

    }

}
