/*
 * Copyright 2006 - 2007 the original author or authors.
 * This source code licensed under the GPL License.
 * You may not use this file except in compliance with the License.
 */
package jp.sf.bli.ss.sample;

import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;

import jp.sf.bli.framework.common.Globals;
import jp.sf.bli.testingframework.BliDjUnitTestCase;

/**
 * SampleBlValidateに対するUnitTestクラス
 */
public class SampleBlValidateTest extends BliDjUnitTestCase {

    /**
     * BLValidate InitProcess Test
     * 
     * <pre>
     *  [前提条件]
     *  なし
     *  [テスト内容]
     *  BLValidateのinitProcessを実行する。
     *  [事後条件]
     *  Exceptionにならずにテストが終了する。
     * </pre>
     */
    public void testBlValidateInitProcess() {

        String testMethodNameStr = "testBlDoInitProcess";

        logStart( testMethodNameStr );

        // ---------------------------------------------------------------------
        // テスト準備1 HTTP系モックのインスタンス化
        // ---------------------------------------------------------------------

        // 処理なし

        // ---------------------------------------------------------------------
        // テスト準備2 テスト用に必要なインスタンスを用意
        // ---------------------------------------------------------------------

        String loginId = "loginId";
        Map< String, Object > inputValueMap = new HashMap< String, Object >();
        Map< String, Object > outputValueMap = new HashMap< String, Object >();

        // ---------------------------------------------------------------------
        // テスト準備3 テスト用データ加工
        // ---------------------------------------------------------------------

        // 処理なし

        // ---------------------------------------------------------------------
        // テスト準備4 Virtual Mockでテストケースに必要なテストデータ加工を行う
        // ---------------------------------------------------------------------

        // 処理なし

        // ---------------------------------------------------------------------
        // テスト準備5 テスト対象クラスインスタンス化
        // ---------------------------------------------------------------------

        SampleBlValidate blValidate = new SampleBlValidate();

        // ---------------------------------------------------------------------
        // 単体テスト実行 テスト準備で用意されたインスタンスでテストケースを実行
        // ---------------------------------------------------------------------

        try {
            blValidate.initProcess( loginId, inputValueMap, outputValueMap );

        } catch ( Exception e ) {

            e.printStackTrace();
            fail( "Exceptionは起こしてはいけません" );

        }

        logEnd( testMethodNameStr );

    }


    /**
     * BLValidate doValidateMain Test
     * 
     * <pre>
     *  [前提条件]
     *  なし
     *  [テスト内容]
     *  BLValidateのdoValidateMainを実行する。
     *  [事後条件]
     *  ExceptionにならずにNull禁則が作動し、テストが終了する。
     * </pre>
     */
    public void testBlValidateDoValidateMain01() {

        String testMethodNameStr = "testBlValidateDoValidateMain01";

        logStart( testMethodNameStr );

        // ---------------------------------------------------------------------
        // テスト準備1 HTTP系モックのインスタンス化
        // ---------------------------------------------------------------------

        // 処理なし

        // ---------------------------------------------------------------------
        // テスト準備2 テスト用に必要なインスタンスを用意
        // ---------------------------------------------------------------------

        String loginId = "loginId";
        Map< String, Object > inputValueMap = new HashMap< String, Object >();
        Map< String, Object > outputValueMap = new HashMap< String, Object >();

        String validateConfigFile = "jp.sf.bli.ss.sample.resources.Validate";
        String validateMessageFile = "jp.sf.bli.ss.sample.resources.ValidateMessage";

        // ---------------------------------------------------------------------
        // テスト準備3 テスト用データ加工
        // ---------------------------------------------------------------------

        inputValueMap.put( "name", null );
        inputValueMap.put( "age", null );

        // ---------------------------------------------------------------------
        // テスト準備4 Virtual Mockでテストケースに必要なテストデータ加工を行う
        // ---------------------------------------------------------------------

        // ---------------------------------------------------------------------
        // テスト準備5 テスト対象クラスインスタンス化
        // ---------------------------------------------------------------------

        SampleBlValidate blValidate = new SampleBlValidate();
        blValidate.setValidateConfigFile( validateConfigFile );
        blValidate.setValidateMessageFile( validateMessageFile );

        // ---------------------------------------------------------------------
        // 単体テスト実行 テスト準備で用意されたインスタンスでテストケースを実行
        // ---------------------------------------------------------------------

        try {
            blValidate.doValidateMain( loginId, inputValueMap, outputValueMap );

            ResourceBundle bundle = ResourceBundle
                    .getBundle( validateMessageFile );

            String errorMes = "ErrorCode:"
                    + bundle.getString( "name_nullChk_code" ) + " [ "
                    + bundle.getString( "name_nullChk_mes" ) + " ]" + "\r\n"
                    + "ErrorCode:" + bundle.getString( "age_nullChk_code" )
                    + " [ " + bundle.getString( "age_nullChk_mes" ) + " ]"
                    + "\r\n";

            assertEquals( errorMes, ( String ) outputValueMap
                    .get( Globals.MAP_KEY_ERROR_MES ) );

        } catch ( Exception e ) {

            e.printStackTrace();
            fail( "Exceptionは起こしてはいけません" );

        }

        logEnd( testMethodNameStr );

    }


    /**
     * BLValidate doValidateMain Test
     * 
     * <pre>
     *  [前提条件]
     *  なし
     *  [テスト内容]
     *  BLValidateのdoValidateMainを実行する。
     *  [事後条件]
     *  Exceptionにならずに空文字禁則が作動し、テストが終了する。
     * </pre>
     */
    public void testBlValidateDoValidateMain02() {

        String testMethodNameStr = "testBlValidateDoValidateMain02";

        logStart( testMethodNameStr );

        // ---------------------------------------------------------------------
        // テスト準備1 HTTP系モックのインスタンス化
        // ---------------------------------------------------------------------

        // 処理なし

        // ---------------------------------------------------------------------
        // テスト準備2 テスト用に必要なインスタンスを用意
        // ---------------------------------------------------------------------

        String loginId = "loginId";
        Map< String, Object > inputValueMap = new HashMap< String, Object >();
        Map< String, Object > outputValueMap = new HashMap< String, Object >();

        String validateConfigFile = "jp.sf.bli.ss.sample.resources.Validate";
        String validateMessageFile = "jp.sf.bli.ss.sample.resources.ValidateMessage";

        // ---------------------------------------------------------------------
        // テスト準備3 テスト用データ加工
        // ---------------------------------------------------------------------

        inputValueMap.put( "name", "" );
        inputValueMap.put( "age", Integer.valueOf( 1 ) );

        // ---------------------------------------------------------------------
        // テスト準備4 Virtual Mockでテストケースに必要なテストデータ加工を行う
        // ---------------------------------------------------------------------

        // ---------------------------------------------------------------------
        // テスト準備5 テスト対象クラスインスタンス化
        // ---------------------------------------------------------------------

        SampleBlValidate blValidate = new SampleBlValidate();
        blValidate.setValidateConfigFile( validateConfigFile );
        blValidate.setValidateMessageFile( validateMessageFile );

        // ---------------------------------------------------------------------
        // 単体テスト実行 テスト準備で用意されたインスタンスでテストケースを実行
        // ---------------------------------------------------------------------

        try {
            blValidate.doValidateMain( loginId, inputValueMap, outputValueMap );

            ResourceBundle bundle = ResourceBundle
                    .getBundle( validateMessageFile );

            String errorMes = "ErrorCode:"
                    + bundle.getString( "name_emptyChk_code" ) + " [ "
                    + bundle.getString( "name_emptyChk_mes" ) + " ]" + "\r\n";

            assertEquals( errorMes, ( String ) outputValueMap
                    .get( Globals.MAP_KEY_ERROR_MES ) );

        } catch ( Exception e ) {

            e.printStackTrace();
            fail( "Exceptionは起こしてはいけません" );

        }

        logEnd( testMethodNameStr );

    }


    /**
     * BLValidate doValidateMain Exception Test
     * 
     * <pre>
     *  [前提条件]
     *  なし
     *  [テスト内容]
     *  BLValidateのdoValidateMainを実行する。
     *  [事後条件]
     *  Exceptionにならずに空文字禁則が作動し、テストが終了する。
     * </pre>
     */
    public void testBlValidateDoValidateMainException() {

        String testMethodNameStr = "testBlValidateDoValidateMainException";

        logStart( testMethodNameStr );

        // ---------------------------------------------------------------------
        // テスト準備1 HTTP系モックのインスタンス化
        // ---------------------------------------------------------------------

        // 処理なし

        // ---------------------------------------------------------------------
        // テスト準備2 テスト用に必要なインスタンスを用意
        // ---------------------------------------------------------------------

        // 処理なし

        // ---------------------------------------------------------------------
        // テスト準備3 テスト用データ加工
        // ---------------------------------------------------------------------

        // 処理なし

        // ---------------------------------------------------------------------
        // テスト準備4 Virtual Mockでテストケースに必要なテストデータ加工を行う
        // ---------------------------------------------------------------------

        // 処理なし

        // ---------------------------------------------------------------------
        // テスト準備5 テスト対象クラスインスタンス化
        // ---------------------------------------------------------------------

        SampleBlValidate blValidate = new SampleBlValidate();

        // ---------------------------------------------------------------------
        // 単体テスト実行 テスト準備で用意されたインスタンスでテストケースを実行
        // ---------------------------------------------------------------------

        try {
            // NullPointerを発生させる
            blValidate.doValidateMain( null, null, null );

            fail( "Exceptionを起こさなくてはいけません。" );

        } catch ( Exception e ) {

            e.printStackTrace();

        }

        logEnd( testMethodNameStr );

    }


    /**
     * BLValidate endProcess Test
     * 
     * <pre>
     *  [前提条件]
     *  なし
     *  [テスト内容]
     *  BLValidateのendProcessを実行する。
     *  [事後条件]
     *  Exceptionにならずにテストが終了する。
     * </pre>
     */
    public void testBlValidateEndProcess() {

        String testMethodNameStr = "testBlValidateEndProcess";

        logStart( testMethodNameStr );

        // ---------------------------------------------------------------------
        // テスト準備1 HTTP系モックのインスタンス化
        // ---------------------------------------------------------------------

        // 処理なし

        // ---------------------------------------------------------------------
        // テスト準備2 テスト用に必要なインスタンスを用意
        // ---------------------------------------------------------------------

        String loginId = "loginId";
        Map< String, Object > inputValueMap = new HashMap< String, Object >();
        Map< String, Object > outputValueMap = new HashMap< String, Object >();

        // ---------------------------------------------------------------------
        // テスト準備3 テスト用データ加工
        // ---------------------------------------------------------------------

        // 処理なし

        // ---------------------------------------------------------------------
        // テスト準備4 Virtual Mockでテストケースに必要なテストデータ加工を行う
        // ---------------------------------------------------------------------

        // 処理なし

        // ---------------------------------------------------------------------
        // テスト準備5 テスト対象クラスインスタンス化
        // ---------------------------------------------------------------------

        SampleBlValidate blValidate = new SampleBlValidate();

        // ---------------------------------------------------------------------
        // 単体テスト実行 テスト準備で用意されたインスタンスでテストケースを実行
        // ---------------------------------------------------------------------

        try {
            blValidate.endProcess( loginId, inputValueMap, outputValueMap );

        } catch ( Exception e ) {

            e.printStackTrace();
            fail( "Exceptionは起こしてはいけません" );

        }

        logEnd( testMethodNameStr );

    }

}
