/*
 * Copyright 2006 - 2007 the original author or authors.
 * This source code licensed under the GPL License.
 * You may not use this file except in compliance with the License.
 */
package jp.sf.bli.ss.sample.model;

import jp.co.dgic.testing.framework.DJUnitTestCase;

/**
 * @author takeda 2007/02/08
 */
public class SampleTest extends DJUnitTestCase {

    /**
     * Smaple コンストラクタテスト
     * 
     * <pre>
     *    [前提条件]
     *    なし
     *    [テスト内容]
     *    コンストラクターで印す単価
     *    [事後条件]
     *    テストにすべてパスする。
     * </pre>
     */
    public void testSampleConst01() {

        Sample sample = new Sample( Integer.valueOf( 1 ) );

        assertEquals( sample.getId(), Integer.valueOf( 1 ) );

    }


    /**
     * Smaple コンストラクタテスト
     * 
     * <pre>
     *    [前提条件]
     *    なし
     *    [テスト内容]
     *    コンストラクターで印す単価
     *    [事後条件]
     *    テストにすべてパスする。
     * </pre>
     */
    public void testSampleConst02() {

        Sample sample = new Sample( Integer.valueOf( 1 ), "武田", Integer
                .valueOf( 11 ) );

        assertEquals( sample.getId(), Integer.valueOf( 1 ) );
        assertEquals( sample.getName(), "武田" );
        assertEquals( sample.getAge(), Integer.valueOf( 11 ) );

    }


    /**
     * Smaple getter setter テスト
     * 
     * <pre>
     *    [前提条件]
     *    なし
     *    [テスト内容]
     *    getter setter を実行する。
     *    [事後条件]
     *    テストにすべてパスする。
     * </pre>
     */
    public void testSample() {

        Sample sample = new Sample();

        sample.setId( Integer.valueOf( 1 ) );
        sample.setName( "武田" );
        sample.setAge( Integer.valueOf( 11 ) );

        assertEquals( sample.getId(), Integer.valueOf( 1 ) );
        assertEquals( sample.getName(), "武田" );
        assertEquals( sample.getAge(), Integer.valueOf( 11 ) );

    }

}
