/*
 * Copyright 2006 - 2007 the original author or authors.
 * This source code licensed under the GPL License.
 * You may not use this file except in compliance with the License.
 */
package jp.sf.bli.testsuite;

import jp.sf.bli.ss.sample.SampleActionTest;
import jp.sf.bli.ss.sample.SampleBlCtrlTest;
import jp.sf.bli.ss.sample.SampleBlValidateTest;
import jp.sf.bli.ss.sample.SampleFormTest;
import jp.sf.bli.ss.sample.SampleSelectBlDoTest;
import jp.sf.bli.ss.sample.dao.impl.sample.SampleDaoTest;
import jp.sf.bli.ss.sample.model.SampleTest;
import jp.sf.bli.web.sample.servlet.SampleFilterTest;
import jp.sf.bli.web.sample.servlet.SampleServletTest;
import junit.framework.Test;
import junit.framework.TestSuite;

public class SampleTestSuite {

    public static Test suite() {

        // テストスイートをオブジェクト化する。

        TestSuite suite = new TestSuite();
        // $JUnit-BEGIN$

        /* Servlet Test */
        suite.addTest( new TestSuite( SampleServletTest.class ) );
        suite.addTest( new TestSuite( SampleFilterTest.class ) );

        /* Struts Action Test */
        suite.addTest( new TestSuite( SampleActionTest.class ) );

        /* Strtuts ActionFrom Test */
        suite.addTest( new TestSuite( SampleFormTest.class ) );

        /* BLCtrl Test */
        suite.addTest( new TestSuite( SampleBlCtrlTest.class ) );

        /* BLValidate Test */
        suite.addTest( new TestSuite( SampleBlValidateTest.class ) );
        
        /* BLDo Test */
        suite.addTest( new TestSuite( SampleSelectBlDoTest.class ) );

        /* Dao Model test */
        suite.addTest( new TestSuite( SampleTest.class ) );

        /* Dao Impl Test */
        suite.addTest( new TestSuite( SampleDaoTest.class ) );

        // $JUnit-END$
        return suite;
    }

}
