class PLAIN2Style < BloggerPost::Style
  def self.style_name
    'plain2'
  end

  def self.extname
    '.pln'
  end

  def entry_to_html(entry)
    html = external_convert('plain2html -c', entry.body)
    html = html.gsub(/&nbsp;/, '')
    html = tidy_html(html)
    html = html.sub(/<h1>.*?<!-- toc -->\n/m, '')
    html
  end
end

BloggerPost.register_style(PLAIN2Style)
