class StxStyle < BloggerPost::Style
  def self.style_name
    'stx'
  end

  def self.extname
    '.stx'
  end

  def entry_to_html(entry)
    html = external_convert('stx2any', entry.body)
    html = delete_first_h1(html)
    html = escape_pre_text(html)
    html = tidy_html(html)
    html
  end
end

BloggerPost.register_style(StxStyle)
