/*
 * Decompiled with CFR 0.152.
 */
package org.blojsom.blog;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.blojsom.BlojsomException;
import org.blojsom.blog.Blog;
import org.blojsom.blog.BlogEntry;
import org.blojsom.blog.BlogUser;
import org.blojsom.util.BlojsomUtils;

public abstract class BlogCategory
implements Comparable,
Serializable {
    protected Log _logger = LogFactory.getLog((Class)BlogCategory.class);
    protected String _categoryURL;
    protected String _category;
    protected Map _metadata = null;
    protected String _description = null;
    protected String _name = null;
    protected List _subcategories;
    protected BlogEntry _blogEntry;
    protected BlogCategory _parentCategory = null;

    public BlogCategory() {
        this._subcategories = new ArrayList();
    }

    public BlogCategory(String category, String categoryURL) {
        this._category = BlojsomUtils.normalize(category);
        this._categoryURL = categoryURL;
    }

    public String getCategoryURL() {
        return this._categoryURL;
    }

    public void setCategoryURL(String categoryURL) {
        this._categoryURL = categoryURL;
    }

    public String getCategory() {
        return this._category;
    }

    public String getEncodedCategory() {
        return BlojsomUtils.urlEncodeForLink(this._category);
    }

    public String getEncodedCategoryURL() {
        return BlojsomUtils.urlEncodeForLink(this._categoryURL);
    }

    public void setCategory(String category) {
        this._category = BlojsomUtils.normalize(category);
    }

    public boolean equals(Object obj) {
        BlogCategory otherCategory = (BlogCategory)obj;
        return this._category.equals(otherCategory._category) && this._categoryURL.equals(otherCategory._categoryURL);
    }

    public int compareTo(Object o) {
        BlogCategory category = (BlogCategory)o;
        return this._category.compareTo(category._category);
    }

    public String toString() {
        return this._category;
    }

    public void setDescription(String desc) {
        this._description = desc;
        if (this._metadata == null) {
            this._metadata = new HashMap(5);
        }
        this._metadata.put("blojsom.description", this._description);
    }

    public String getDescription() {
        return this._description;
    }

    public void setName(String name) {
        this._name = name;
        if (this._metadata == null) {
            this._metadata = new HashMap(5);
        }
        this._metadata.put("blojsom.name", this._name);
    }

    public String getName() {
        return this._name;
    }

    public void setMetaData(Map metadata) {
        this._metadata = metadata;
    }

    public void setMetaData(Properties data) {
        String s = null;
        Enumeration<Object> keys = data.keys();
        if (this._metadata == null) {
            this._metadata = new HashMap(5);
        }
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            this._metadata.put(key, data.get(key));
        }
        s = (String)this._metadata.get("blojsom.description");
        if (s != null && !"".equals(s)) {
            this._description = s;
        }
        if ((s = (String)this._metadata.get("blojsom.name")) != null && !"".equals(s)) {
            this._name = s;
        }
    }

    public Map getMetaData() {
        if (this._metadata == null) {
            return new HashMap();
        }
        return this._metadata;
    }

    public void setAttributes(Map attributeMap) {
    }

    public abstract void load(Blog var1) throws BlojsomException;

    public abstract void save(Blog var1) throws BlojsomException;

    public abstract void delete(Blog var1) throws BlojsomException;

    public abstract void load(BlogUser var1) throws BlojsomException;

    public abstract void save(BlogUser var1) throws BlojsomException;

    public abstract void delete(BlogUser var1) throws BlojsomException;

    public abstract int countBlogEntries(Blog var1, boolean var2);

    public List getSubcategories() {
        return this._subcategories;
    }

    public List getSubcategories(int depth) {
        return this._subcategories;
    }

    public void setSubcategories(List subcategories) {
        this._subcategories = subcategories;
    }

    public BlogCategory getParentCategory() {
        return this._parentCategory;
    }

    public void setParentCategory(BlogCategory cateogory) {
        this._parentCategory = cateogory;
    }
}

