/*
 * Decompiled with CFR 0.152.
 */
package org.blojsom.blog;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.blojsom.BlojsomException;
import org.blojsom.blog.BlogEntry;
import org.blojsom.blog.BlogUser;
import org.blojsom.util.BlojsomUtils;

public abstract class BlogComment
implements Serializable {
    protected String _author;
    protected String _authorEmail;
    protected String _authorURL;
    protected String _comment;
    protected Date _commentDate;
    protected long _commentDateLong = -1L;
    protected String _id;
    protected Map _metaData;
    protected BlogEntry _blogEntry;

    public String getAuthor() {
        return this._author;
    }

    public void setAuthor(String author) {
        this._author = author;
    }

    public String getAuthorEmail() {
        return this._authorEmail;
    }

    public void setAuthorEmail(String authorEmail) {
        this._authorEmail = authorEmail;
    }

    public String getAuthorURL() {
        return this._authorURL;
    }

    public void setAuthorURL(String authorURL) {
        this._authorURL = authorURL;
    }

    public String getEscapedComment() {
        return BlojsomUtils.escapeString(this._comment);
    }

    public String getComment() {
        return this._comment;
    }

    public void setComment(String comment) {
        this._comment = comment;
    }

    public Date getCommentDate() {
        return this._commentDate;
    }

    public String getISO8601Date() {
        return BlojsomUtils.getISO8601Date(this._commentDate);
    }

    public String getRFC822Date() {
        return BlojsomUtils.getRFC822Date(this._commentDate);
    }

    public Map getMetaData() {
        if (this._metaData == null) {
            return new HashMap();
        }
        return this._metaData;
    }

    public void setCommentDate(Date commentDate) {
        this._commentDate = commentDate;
    }

    public long getCommentDateLong() {
        return this._commentDateLong;
    }

    public void setCommentDateLong(long commentDateLong) {
        this._commentDateLong = commentDateLong;
    }

    public String getId() {
        return this._id;
    }

    public void setId(String id) {
        if (this._id == null) {
            this._id = id;
        }
    }

    public void setMetaData(Map metaData) {
        this._metaData = metaData;
    }

    public String getDateAsFormat(String format) {
        if (this._commentDate == null || format == null) {
            return null;
        }
        SimpleDateFormat sdf = null;
        try {
            sdf = new SimpleDateFormat(format);
            return sdf.format(this._commentDate);
        }
        catch (IllegalArgumentException e) {
            return this._commentDate.toString();
        }
    }

    public BlogEntry getBlogEntry() {
        return this._blogEntry;
    }

    public void setBlogEntry(BlogEntry blogEntry) {
        this._blogEntry = blogEntry;
    }

    public abstract void load(BlogUser var1) throws BlojsomException;

    public abstract void save(BlogUser var1) throws BlojsomException;

    public abstract void delete(BlogUser var1) throws BlojsomException;
}

