/*
 * Decompiled with CFR 0.152.
 */
package org.blojsom.blog;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.blojsom.BlojsomException;
import org.blojsom.blog.BlogCategory;
import org.blojsom.blog.BlogComment;
import org.blojsom.blog.BlogUser;
import org.blojsom.blog.Pingback;
import org.blojsom.blog.Trackback;
import org.blojsom.util.BlojsomConstants;
import org.blojsom.util.BlojsomMetaDataConstants;
import org.blojsom.util.BlojsomUtils;

public abstract class BlogEntry
implements BlojsomConstants,
BlojsomMetaDataConstants,
Serializable {
    protected transient Log _logger = LogFactory.getLog((Class)BlogEntry.class);
    protected String _title;
    protected String _link;
    protected String _description;
    protected String _category;
    protected Date _entryDate;
    protected long _lastModified;
    protected List _comments;
    protected List _trackbacks;
    protected List _pingbacks;
    protected BlogCategory _blogCategory;
    protected Map _metaData;

    public Date getDate() {
        return this._entryDate;
    }

    public void setDate(Date entryDate) {
        this._entryDate = entryDate;
    }

    public String getRFC822Date() {
        return BlojsomUtils.getRFC822Date(this._entryDate);
    }

    public String getUTCDate() {
        return BlojsomUtils.getUTCDate(this._entryDate);
    }

    public String getISO8601Date() {
        return BlojsomUtils.getISO8601Date(this._entryDate);
    }

    public String getDateAsFormat(String format) {
        return this.getDateAsFormat(format, null);
    }

    public String getDateAsFormat(String format, Locale locale) {
        if (this._entryDate == null || format == null) {
            return null;
        }
        SimpleDateFormat sdf = null;
        try {
            sdf = locale == null ? new SimpleDateFormat(format) : new SimpleDateFormat(format, locale);
            return sdf.format(this._entryDate);
        }
        catch (IllegalArgumentException e) {
            return this._entryDate.toString();
        }
    }

    public String getTitle() {
        return this._title;
    }

    public void setTitle(String title) {
        this._title = title;
    }

    public String getEscapedTitle() {
        return BlojsomUtils.escapeString(this._title);
    }

    public String getLink() {
        return this._link;
    }

    public String getEscapedLink() {
        return BlojsomUtils.escapeString(this._link);
    }

    public void setLink(String link) {
        this._link = link;
    }

    public String getDescription() {
        return this._description;
    }

    public String getEscapedDescription() {
        return BlojsomUtils.escapeString(this._description);
    }

    public void setDescription(String description) {
        this._description = description;
    }

    public long getLastModified() {
        return this._lastModified;
    }

    public abstract String getId();

    public abstract String getPermalink();

    public String getCategory() {
        return this._category;
    }

    public String getEncodedCategory() {
        if (this._category == null) {
            return null;
        }
        if (!this._category.startsWith("/")) {
            return "/" + BlojsomUtils.urlEncodeForLink(this._category);
        }
        return BlojsomUtils.urlEncodeForLink(this._category);
    }

    public void setCategory(String category) {
        this._category = category;
    }

    public boolean equals(Object o) {
        if (!(o instanceof BlogEntry)) {
            return false;
        }
        BlogEntry entry = (BlogEntry)o;
        return this._link.equals(entry.getLink());
    }

    public abstract boolean supportsComments();

    public List getComments() {
        if (this._comments == null) {
            return new ArrayList();
        }
        return this._comments;
    }

    public void setComments(List comments) {
        this._comments = comments;
    }

    public BlogComment[] getCommentsAsArray() {
        if (this._comments == null) {
            return new BlogComment[0];
        }
        return this._comments.toArray(new BlogComment[this._comments.size()]);
    }

    public int getNumComments() {
        if (this._comments == null) {
            return 0;
        }
        return this._comments.size();
    }

    public abstract boolean supportsTrackbacks();

    public List getTrackbacks() {
        if (this._trackbacks == null) {
            return new ArrayList();
        }
        return this._trackbacks;
    }

    public void setTrackbacks(List trackbacks) {
        this._trackbacks = trackbacks;
    }

    public Trackback[] getTrackbacksAsArray() {
        if (this._trackbacks == null) {
            return new Trackback[0];
        }
        return this._trackbacks.toArray(new Trackback[this._trackbacks.size()]);
    }

    public int getNumTrackbacks() {
        if (this._trackbacks == null) {
            return 0;
        }
        return this._trackbacks.size();
    }

    public BlogCategory getBlogCategory() {
        return this._blogCategory;
    }

    public void setBlogCategory(BlogCategory blogCategory) {
        this._blogCategory = blogCategory;
    }

    public Map getMetaData() {
        if (this._metaData == null) {
            return new HashMap();
        }
        return this._metaData;
    }

    public void setMetaData(Map metaData) {
        this._metaData = metaData;
    }

    public String toString() {
        return this._title;
    }

    public void setAttributes(Map attributeMap) {
    }

    public abstract boolean supportsPingbacks();

    public List getPingbacks() {
        if (this._pingbacks == null) {
            return new ArrayList();
        }
        return this._pingbacks;
    }

    public void setPingbacks(List pingbacks) {
        this._pingbacks = pingbacks;
    }

    public Pingback[] getPingbacksAsArray() {
        if (this._pingbacks == null) {
            return new Pingback[0];
        }
        return this._pingbacks.toArray(new Pingback[this._pingbacks.size()]);
    }

    public int getNumPingbacks() {
        if (this._pingbacks == null) {
            return 0;
        }
        return this._pingbacks.size();
    }

    public abstract void load(BlogUser var1) throws BlojsomException;

    public abstract void save(BlogUser var1) throws BlojsomException;

    public abstract void delete(BlogUser var1) throws BlojsomException;
}

