/*
 * Decompiled with CFR 0.152.
 */
package org.blojsom.blog;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.blojsom.BlojsomException;
import org.blojsom.blog.Blog;
import org.blojsom.blog.BlogCategory;
import org.blojsom.blog.BlogUser;
import org.blojsom.util.BlojsomProperties;
import org.blojsom.util.BlojsomUtils;

public class FileBackedBlogCategory
extends BlogCategory {
    private transient Log _logger = LogFactory.getLog((Class)FileBackedBlogCategory.class);
    protected transient BlogUser _blogUser;

    public FileBackedBlogCategory() {
    }

    public FileBackedBlogCategory(String category, String categoryURL) {
        super(category, categoryURL);
    }

    protected void loadMetaData(String blogHome, String[] propertiesExtensions) {
        File blog = new File(blogHome + BlojsomUtils.removeInitialSlash(this._category));
        File[] categoryPropertyFiles = blog.listFiles(BlojsomUtils.getExtensionsFilter(propertiesExtensions));
        if (categoryPropertyFiles != null && categoryPropertyFiles.length > 0) {
            BlojsomProperties dirProps = new BlojsomProperties();
            for (int i = 0; i < categoryPropertyFiles.length; ++i) {
                try {
                    FileInputStream _fis = new FileInputStream(categoryPropertyFiles[i]);
                    ((Properties)dirProps).load(_fis);
                    _fis.close();
                    continue;
                }
                catch (IOException ex) {
                    this._logger.warn((Object)("Failed loading properties from: " + categoryPropertyFiles[i].toString()));
                }
            }
            this.setMetaData(dirProps);
        }
    }

    public void load(Blog blog) throws BlojsomException {
    }

    public void save(Blog blog) throws BlojsomException {
    }

    public void delete(Blog blog) throws BlojsomException {
    }

    public void load(BlogUser blogUser) throws BlojsomException {
        this._blogUser = blogUser;
        Blog blog = blogUser.getBlog();
        this.loadMetaData(blog.getBlogHome(), blog.getBlogPropertiesExtensions());
    }

    public void save(BlogUser blogUser) throws BlojsomException {
        this._blogUser = blogUser;
        Blog blog = blogUser.getBlog();
        File blogCategory = new File(blog.getBlogHome() + BlojsomUtils.removeInitialSlash(this._category));
        if (!blogCategory.exists() && !blogCategory.mkdirs()) {
            this._logger.error((Object)("Could not create new blog category at: " + blogCategory.toString()));
            return;
        }
        String propertiesExtension = blog.getBlogPropertiesExtensions()[0];
        File categoryMetaDataFile = new File(blogCategory, "blojsom" + propertiesExtension);
        Properties categoryMetaData = BlojsomUtils.mapToProperties(this._metadata, "UTF-8");
        try {
            FileOutputStream fos = new FileOutputStream(categoryMetaDataFile);
            categoryMetaData.store(fos, null);
            fos.close();
        }
        catch (IOException e) {
            this._logger.error((Object)e);
            throw new BlojsomException("Unable to save blog category", e);
        }
        this._logger.debug((Object)("Saved blog category: " + blogCategory.toString()));
    }

    public void delete(BlogUser blogUser) throws BlojsomException {
        this._blogUser = blogUser;
        Blog blog = blogUser.getBlog();
        File blogCategory = new File(blog.getBlogHome() + BlojsomUtils.removeInitialSlash(this._category));
        if (blogCategory.equals(blog.getBlogHome()) ? !BlojsomUtils.deleteDirectory(blogCategory, false) : !BlojsomUtils.deleteDirectory(blogCategory)) {
            throw new BlojsomException("Unable to delete blog category directory: " + this._category);
        }
        this._logger.debug((Object)("Deleted blog category: " + blogCategory.toString()));
    }

    protected int recursiveBlogEntriesCounter(Blog blog, boolean recursive, String rootDirectory) {
        int i;
        File blogDirectory = new File(rootDirectory);
        int totalEntries = 0;
        File[] directories = blog.getBlogDirectoryFilter() == null ? blogDirectory.listFiles(BlojsomUtils.getDirectoryFilter()) : blogDirectory.listFiles(BlojsomUtils.getDirectoryFilter(blog.getBlogDirectoryFilter()));
        File[] entries = blogDirectory.listFiles(BlojsomUtils.getRegularExpressionFilter(blog.getBlogFileExtensions()));
        totalEntries = entries == null ? 0 : entries.length;
        if (directories != null && recursive && (i = 0) < directories.length) {
            File directory = directories[i];
            return totalEntries + this.recursiveBlogEntriesCounter(blog, recursive, directory.toString());
        }
        return totalEntries;
    }

    public int countBlogEntries(Blog blog, boolean recursive) {
        int totalEntries = this.recursiveBlogEntriesCounter(blog, recursive, blog.getBlogHome() + this._category);
        return totalEntries;
    }

    protected void recursiveCategoryBuilder(BlogUser blogUser, int blogDepth, int blogDirectoryDepth, String blogDirectory, List categoryList) {
        Blog blog = blogUser.getBlog();
        if (blogDirectoryDepth != -1 && ++blogDepth == blogDirectoryDepth) {
            return;
        }
        File blogDir = new File(blogDirectory);
        File[] directories = blog.getBlogDirectoryFilter() == null ? blogDir.listFiles(BlojsomUtils.getDirectoryFilter()) : blogDir.listFiles(BlojsomUtils.getDirectoryFilter(blog.getBlogDirectoryFilter()));
        String categoryKey = BlojsomUtils.getBlogCategory(blog.getBlogHome(), blogDirectory);
        if (!categoryKey.endsWith("/")) {
            categoryKey = categoryKey + "/";
        }
        FileBackedBlogCategory blogCategory = new FileBackedBlogCategory();
        blogCategory.setParentCategory(this);
        blogCategory.setCategory(categoryKey);
        blogCategory.setCategoryURL(blog.getBlogURL() + BlojsomUtils.removeInitialSlash(categoryKey));
        try {
            ((BlogCategory)blogCategory).load(blogUser);
        }
        catch (BlojsomException e) {
            this._logger.error((Object)e);
        }
        if (blogDepth != 0) {
            categoryList.add(blogCategory);
        }
        if (directories == null) {
            return;
        }
        for (int i = 0; i < directories.length; ++i) {
            File directory = directories[i];
            this.recursiveCategoryBuilder(blogUser, blogDepth, blogDirectoryDepth, directory.toString(), categoryList);
        }
    }

    public List getSubcategories() {
        this._subcategories = new ArrayList();
        this.recursiveCategoryBuilder(this._blogUser, -1, -1, this._blogUser.getBlog().getBlogHome() + BlojsomUtils.removeInitialSlash(this._category), this._subcategories);
        return this._subcategories;
    }

    public List getSubcategories(int depth) {
        this._subcategories = new ArrayList();
        depth = depth <= -1 ? -1 : ++depth;
        this.recursiveCategoryBuilder(this._blogUser, -1, depth, this._blogUser.getBlog().getBlogHome() + BlojsomUtils.removeInitialSlash(this._category), this._subcategories);
        return this._subcategories;
    }
}

