/*
 * Decompiled with CFR 0.152.
 */
package org.blojsom.dispatcher;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.util.EnumerationIterator;
import org.blojsom.BlojsomException;
import org.blojsom.blog.BlogUser;
import org.blojsom.blog.BlojsomConfiguration;
import org.blojsom.dispatcher.BlojsomDispatcher;
import org.blojsom.util.BlojsomUtils;

public class VelocityDispatcher
implements BlojsomDispatcher {
    private static final String BLOG_VELOCITY_PROPERTIES_IP = "velocity-properties";
    private static final String BLOJSOM_RENDER_TOOL = "BLOJSOM_RENDER_TOOL";
    private Log _logger = LogFactory.getLog((Class)VelocityDispatcher.class);
    private String _installationDirectory;
    private String _baseConfigurationDirectory;
    private String _templatesDirectory;
    private Properties _velocityProperties;

    public void init(ServletConfig servletConfig, BlojsomConfiguration blojsomConfiguration) throws BlojsomException {
        this._baseConfigurationDirectory = blojsomConfiguration.getBaseConfigurationDirectory();
        this._installationDirectory = blojsomConfiguration.getInstallationDirectory();
        this._templatesDirectory = blojsomConfiguration.getTemplatesDirectory();
        this._logger.debug((Object)("Using templates directory: " + this._templatesDirectory));
        String velocityConfiguration = servletConfig.getInitParameter(BLOG_VELOCITY_PROPERTIES_IP);
        this._velocityProperties = new Properties();
        InputStream is = servletConfig.getServletContext().getResourceAsStream(velocityConfiguration);
        try {
            this._velocityProperties.load(is);
            is.close();
        }
        catch (Exception e) {
            this._logger.error((Object)e);
        }
        this._logger.debug((Object)"Initialized Velocity dispatcher");
    }

    protected String getVelocityFileLoaderPath(String userId) {
        StringBuffer fileLoaderPath = new StringBuffer();
        fileLoaderPath.append(this._installationDirectory);
        fileLoaderPath.append(BlojsomUtils.removeInitialSlash(this._baseConfigurationDirectory));
        fileLoaderPath.append(userId).append("/");
        fileLoaderPath.append(BlojsomUtils.removeInitialSlash(this._templatesDirectory));
        fileLoaderPath.append(", ");
        fileLoaderPath.append(this._installationDirectory);
        fileLoaderPath.append(BlojsomUtils.removeInitialSlash(this._baseConfigurationDirectory));
        fileLoaderPath.append(BlojsomUtils.removeInitialSlash(this._templatesDirectory));
        return fileLoaderPath.toString();
    }

    protected void populateVelocityContext(HttpServletRequest httpServletRequest, Map context) {
        EnumerationIterator iterator = new EnumerationIterator(httpServletRequest.getAttributeNames());
        while (iterator.hasNext()) {
            Object key = iterator.next();
            Object value = httpServletRequest.getAttribute(key.toString());
            context.put(key, value);
        }
        HttpSession httpSession = httpServletRequest.getSession();
        if (httpSession != null) {
            iterator = new EnumerationIterator(httpSession.getAttributeNames());
            while (iterator.hasNext()) {
                Object key = iterator.next();
                Object value = httpSession.getAttribute(key.toString());
                context.put(key, value);
            }
        }
    }

    protected void destroyVelocityContext(VelocityContext velocityContext) {
        Object[] contextKeys = velocityContext.getKeys();
        for (int i = 0; i < contextKeys.length; ++i) {
            Object contextKey = contextKeys[i];
            velocityContext.remove(contextKey);
        }
    }

    public void dispatch(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, BlogUser user, Map context, String flavorTemplate, String flavorContentType) throws IOException, ServletException {
        httpServletResponse.setContentType(flavorContentType);
        VelocityEngine velocityEngine = new VelocityEngine();
        try {
            Properties updatedVelocityProperties = (Properties)this._velocityProperties.clone();
            updatedVelocityProperties.setProperty("file.resource.loader.path", this.getVelocityFileLoaderPath(user.getId()));
            velocityEngine.init(updatedVelocityProperties);
            updatedVelocityProperties = null;
        }
        catch (Exception e) {
            this._logger.error((Object)e);
            return;
        }
        PrintWriter responseWriter = httpServletResponse.getWriter();
        String flavorTemplateForPage = null;
        String pageParameter = BlojsomUtils.getRequestValue("page", httpServletRequest, true);
        if (pageParameter != null) {
            flavorTemplateForPage = BlojsomUtils.getTemplateForPage(flavorTemplate, pageParameter);
            this._logger.debug((Object)("Retrieved template for page: " + flavorTemplateForPage));
        }
        this.populateVelocityContext(httpServletRequest, context);
        VelocityContext velocityContext = new VelocityContext(context);
        velocityContext.put(BLOJSOM_RENDER_TOOL, (Object)new BlojsomRenderTool(velocityEngine, velocityContext));
        if (flavorTemplateForPage != null) {
            if (!velocityEngine.templateExists(flavorTemplateForPage)) {
                this._logger.error((Object)("Could not find flavor page template for user: " + flavorTemplateForPage));
                ((Writer)responseWriter).flush();
                this.destroyVelocityContext(velocityContext);
                velocityContext = null;
                velocityEngine = null;
                return;
            }
            try {
                velocityEngine.mergeTemplate(flavorTemplateForPage, "UTF-8", (Context)velocityContext, (Writer)responseWriter);
            }
            catch (Exception e) {
                this._logger.error((Object)e);
                ((Writer)responseWriter).flush();
                this.destroyVelocityContext(velocityContext);
                velocityContext = null;
                velocityEngine = null;
                return;
            }
            this._logger.debug((Object)("Dispatched to flavor page template: " + flavorTemplateForPage));
        } else {
            if (!velocityEngine.templateExists(flavorTemplate)) {
                this._logger.error((Object)("Could not find flavor template for user: " + flavorTemplate));
                ((Writer)responseWriter).flush();
                this.destroyVelocityContext(velocityContext);
                velocityContext = null;
                velocityEngine = null;
                return;
            }
            try {
                velocityEngine.mergeTemplate(flavorTemplate, "UTF-8", (Context)velocityContext, (Writer)responseWriter);
            }
            catch (Exception e) {
                this._logger.error((Object)e);
                ((Writer)responseWriter).flush();
                this.destroyVelocityContext(velocityContext);
                velocityContext = null;
                velocityEngine = null;
                return;
            }
            this._logger.debug((Object)("Dispatched to flavor template: " + flavorTemplate));
        }
        ((Writer)responseWriter).flush();
        this.destroyVelocityContext(velocityContext);
        velocityContext = null;
        velocityEngine = null;
    }

    public class BlojsomRenderTool {
        private static final String LOG_TAG = "BlojsomRenderTool";
        private VelocityEngine _velocityEngine;
        private VelocityContext _velocityContext;

        public BlojsomRenderTool(VelocityEngine velocityEngine, VelocityContext velocityContext) {
            this._velocityEngine = velocityEngine;
            this._velocityContext = velocityContext;
        }

        public String evaluate(String template) {
            if (BlojsomUtils.checkNullOrBlank(template)) {
                return null;
            }
            StringWriter sw = new StringWriter();
            boolean success = false;
            try {
                success = this._velocityEngine == null ? Velocity.evaluate((Context)this._velocityContext, (Writer)sw, (String)LOG_TAG, (String)template) : this._velocityEngine.evaluate((Context)this._velocityContext, (Writer)sw, LOG_TAG, template);
            }
            catch (ParseErrorException e) {
                VelocityDispatcher.this._logger.error((Object)e);
            }
            catch (MethodInvocationException e) {
                VelocityDispatcher.this._logger.error((Object)e);
            }
            catch (ResourceNotFoundException e) {
                VelocityDispatcher.this._logger.error((Object)e);
            }
            catch (IOException e) {
                VelocityDispatcher.this._logger.error((Object)e);
            }
            if (success) {
                return sw.toString();
            }
            return null;
        }
    }
}

