/*
 * Decompiled with CFR 0.152.
 */
package org.blojsom.filter;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.zip.GZIPOutputStream;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.blojsom.filter.CharArrayWrapper;

public class SimpleCompressionFilter
implements Filter {
    private Log _logger = LogFactory.getLog((Class)SimpleCompressionFilter.class);
    private FilterConfig config;

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws ServletException, IOException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse res = (HttpServletResponse)response;
        if (!this.isGzipSupported(req)) {
            chain.doFilter((ServletRequest)req, (ServletResponse)res);
        } else {
            this._logger.debug((Object)"GZIP supported, compressing.");
            res.setHeader("Content-Encoding", "gzip");
            CharArrayWrapper responseWrapper = new CharArrayWrapper(res);
            chain.doFilter((ServletRequest)req, (ServletResponse)responseWrapper);
            char[] responseChars = responseWrapper.toCharArray();
            ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
            GZIPOutputStream zipOut = new GZIPOutputStream(byteStream);
            OutputStreamWriter tempOut = new OutputStreamWriter((OutputStream)zipOut, "UTF-8");
            tempOut.write(responseChars);
            tempOut.close();
            res.setContentLength(byteStream.size());
            ServletOutputStream realOut = res.getOutputStream();
            byteStream.writeTo((OutputStream)realOut);
            byteStream.flush();
            byteStream.close();
        }
    }

    public void init(FilterConfig config) throws ServletException {
        this.config = config;
    }

    protected FilterConfig getFilterConfig() {
        return this.config;
    }

    public void destroy() {
    }

    private boolean isGzipSupported(HttpServletRequest req) {
        String browserEncodings = req.getHeader("Accept-Encoding");
        return browserEncodings != null && browserEncodings.indexOf("gzip") != -1;
    }
}

