/*
 * Decompiled with CFR 0.152.
 */
package org.blojsom.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.blojsom.BlojsomException;
import org.blojsom.blog.Blog;
import org.blojsom.blog.BlogCategory;
import org.blojsom.blog.BlogComment;
import org.blojsom.blog.BlogEntry;
import org.blojsom.blog.BlogUser;
import org.blojsom.dispatcher.BlojsomDispatcher;
import org.blojsom.fetcher.BlojsomFetcherException;
import org.blojsom.plugin.BlojsomPlugin;
import org.blojsom.plugin.BlojsomPluginException;
import org.blojsom.servlet.BlojsomBaseServlet;
import org.blojsom.util.BlojsomUtils;
import org.blojsom.util.resources.ResourceManager;

public class BlojsomServlet
extends BlojsomBaseServlet {
    private static final String BLOJSOM_DISPATCHER_MAP_CONFIGURATION_IP = "dispatcher-configuration";
    private Log _logger = LogFactory.getLog((Class)BlojsomServlet.class);
    private Map _plugins;
    private Map _dispatchers;
    private ResourceManager _resourceManager;

    protected void configureDispatchers(ServletConfig servletConfig) throws ServletException {
        String templateConfiguration = servletConfig.getInitParameter(BLOJSOM_DISPATCHER_MAP_CONFIGURATION_IP);
        this._dispatchers = new HashMap();
        Properties templateMapProperties = new Properties();
        InputStream is = servletConfig.getServletContext().getResourceAsStream(templateConfiguration);
        try {
            templateMapProperties.load(is);
            is.close();
            Iterator<Object> templateIterator = templateMapProperties.keySet().iterator();
            while (templateIterator.hasNext()) {
                String templateExtension = (String)templateIterator.next();
                String templateDispatcherClass = templateMapProperties.getProperty(templateExtension);
                Class<?> dispatcherClass = Class.forName(templateDispatcherClass);
                BlojsomDispatcher dispatcher = (BlojsomDispatcher)dispatcherClass.newInstance();
                dispatcher.init(servletConfig, this._blojsomConfiguration);
                this._dispatchers.put(templateExtension, dispatcher);
                this._logger.debug((Object)("Added template dispatcher: " + templateDispatcherClass));
            }
        }
        catch (InstantiationException e) {
            this._logger.error((Object)e);
        }
        catch (IllegalAccessException e) {
            this._logger.error((Object)e);
        }
        catch (ClassNotFoundException e) {
            this._logger.error((Object)e);
        }
        catch (IOException e) {
            this._logger.error((Object)e);
            throw new ServletException((Throwable)e);
        }
        catch (BlojsomException e) {
            this._logger.error((Object)e);
            throw new ServletException((Throwable)e);
        }
    }

    protected void configureFlavorsForBlog(ServletConfig servletConfig, BlogUser blogUser) throws ServletException {
        String flavorConfiguration = servletConfig.getInitParameter("flavor-configuration");
        if (BlojsomUtils.checkNullOrBlank(flavorConfiguration)) {
            flavorConfiguration = "flavor.properties";
        }
        HashMap<String, String> flavors = new HashMap<String, String>();
        HashMap<String, String> flavorToTemplateMap = new HashMap<String, String>();
        HashMap<String, String> flavorToContentTypeMap = new HashMap<String, String>();
        String user = blogUser.getId();
        Properties flavorProperties = new Properties();
        InputStream is = servletConfig.getServletContext().getResourceAsStream(this._baseConfigurationDirectory + user + '/' + flavorConfiguration);
        try {
            flavorProperties.load(is);
            is.close();
            this._logger.debug((Object)("Loaded flavor information for user: " + user));
            Iterator<Object> flavorIterator = flavorProperties.keySet().iterator();
            while (flavorIterator.hasNext()) {
                String flavor = (String)flavorIterator.next();
                String[] flavorMapping = BlojsomUtils.parseCommaList(flavorProperties.getProperty(flavor));
                flavors.put(flavor, flavor);
                flavorToTemplateMap.put(flavor, flavorMapping[0]);
                flavorToContentTypeMap.put(flavor, flavorMapping[1]);
            }
            blogUser.setFlavors(flavors);
            blogUser.setFlavorToTemplate(flavorToTemplateMap);
            blogUser.setFlavorToContentType(flavorToContentTypeMap);
        }
        catch (IOException e) {
            this._logger.error((Object)e);
            throw new ServletException((Throwable)e);
        }
    }

    protected void configurePlugins(ServletConfig servletConfig) throws ServletException {
        String pluginConfiguration = servletConfig.getInitParameter("plugin-configuration");
        if (BlojsomUtils.checkNullOrBlank(pluginConfiguration)) {
            this._logger.error((Object)"No plugin configuration file specified");
            throw new ServletException("No plugin configuration file specified");
        }
        this._plugins = new HashMap();
        String pluginConfigurationLocation = this._baseConfigurationDirectory + pluginConfiguration;
        Properties pluginProperties = new Properties();
        try {
            pluginProperties = BlojsomUtils.loadProperties(servletConfig, pluginConfigurationLocation);
        }
        catch (BlojsomException e) {
            this._logger.error((Object)e);
            throw new ServletException((Throwable)e);
        }
        Iterator<Object> pluginIterator = pluginProperties.keySet().iterator();
        while (pluginIterator.hasNext()) {
            String plugin = (String)pluginIterator.next();
            if (plugin.indexOf("blojsom-plugin-chain") != -1) {
                this._logger.debug((Object)"Skipping blojsom plugin chain in global plugin configuration file");
                continue;
            }
            String pluginClassName = pluginProperties.getProperty(plugin);
            try {
                Class<?> pluginClass = Class.forName(pluginClassName);
                BlojsomPlugin blojsomPlugin = (BlojsomPlugin)pluginClass.newInstance();
                blojsomPlugin.init(servletConfig, this._blojsomConfiguration);
                this._plugins.put(plugin, blojsomPlugin);
                this._logger.info((Object)("Added blojsom plugin: " + pluginClassName));
            }
            catch (BlojsomPluginException e) {
                this._logger.error((Object)e);
            }
            catch (InstantiationException e) {
                this._logger.error((Object)e);
            }
            catch (IllegalAccessException e) {
                this._logger.error((Object)e);
            }
            catch (ClassNotFoundException e) {
                this._logger.error((Object)e);
            }
        }
    }

    protected void configurePluginsForBlog(ServletConfig servletConfig, BlogUser blogUser) throws ServletException {
        String pluginConfiguration = servletConfig.getInitParameter("plugin-configuration");
        Iterator<Object> pluginIterator = this._plugins.keySet().iterator();
        if (BlojsomUtils.checkNullOrBlank(pluginConfiguration)) {
            this._logger.error((Object)"No plugin configuration file specified");
            throw new ServletException("No plugin configuration file specified");
        }
        HashMap<String, String[]> pluginChainMap = new HashMap<String, String[]>();
        String user = blogUser.getId();
        InputStream is = servletConfig.getServletContext().getResourceAsStream(this._baseConfigurationDirectory + user + '/' + pluginConfiguration);
        Properties pluginProperties = new Properties();
        try {
            pluginProperties.load(is);
            is.close();
            pluginIterator = pluginProperties.keySet().iterator();
            while (pluginIterator.hasNext()) {
                String plugin = (String)pluginIterator.next();
                if (plugin.indexOf("blojsom-plugin-chain") == -1) continue;
                pluginChainMap.put(plugin, BlojsomUtils.parseCommaList(pluginProperties.getProperty(plugin)));
                this._logger.debug((Object)("Added plugin chain: " + plugin + '=' + pluginProperties.getProperty(plugin) + " for user: " + user));
            }
            blogUser.setPluginChain(pluginChainMap);
        }
        catch (IOException e) {
            this._logger.error((Object)e);
            throw new ServletException((Throwable)e);
        }
    }

    protected void configureResourceManager() throws ServletException {
        String resourceManagerClass = this._blojsomConfiguration.getResourceManager();
        try {
            Class<?> resourceManagerClazz = Class.forName(resourceManagerClass);
            this._resourceManager = (ResourceManager)resourceManagerClazz.newInstance();
            this._resourceManager.init(this._blojsomConfiguration);
        }
        catch (InstantiationException e) {
            this._logger.error((Object)e);
            throw new ServletException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            this._logger.error((Object)e);
            throw new ServletException((Throwable)e);
        }
        catch (ClassNotFoundException e) {
            this._logger.error((Object)e);
            throw new ServletException((Throwable)e);
        }
        catch (BlojsomException e) {
            this._logger.error((Object)e);
            throw new ServletException((Throwable)e);
        }
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        this.configureBlojsom(servletConfig);
        this.configureDispatchers(servletConfig);
        this.configurePlugins(servletConfig);
        this.configureResourceManager();
        this._logger.debug((Object)"blojsom: All Your Blog Are Belong To Us");
    }

    protected void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String pluginChainMapKey;
        String[] pluginChainValue;
        BlogUser blogUser;
        String user;
        block29: {
            try {
                httpServletRequest.setCharacterEncoding("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                this._logger.error((Object)e);
            }
            if (!httpServletRequest.getRequestURI().endsWith("/")) {
                StringBuffer redirectURL = new StringBuffer();
                redirectURL.append(httpServletRequest.getRequestURI());
                redirectURL.append("/");
                if (httpServletRequest.getParameterMap().size() > 0) {
                    redirectURL.append("?");
                    redirectURL.append(BlojsomUtils.convertRequestParams(httpServletRequest));
                }
                this._logger.debug((Object)("Redirecting the user to: " + redirectURL.toString()));
                httpServletResponse.sendRedirect(redirectURL.toString());
                return;
            }
            user = httpServletRequest.getParameter("id");
            if (BlojsomUtils.checkNullOrBlank(user)) {
                String userFromPath = BlojsomUtils.getUserFromPath(httpServletRequest.getPathInfo());
                user = userFromPath == null ? this._blojsomConfiguration.getDefaultUser() : userFromPath;
            }
            blogUser = null;
            try {
                blogUser = this._blojsomConfiguration.loadBlog(user);
            }
            catch (BlojsomException e) {
                if (BlojsomUtils.checkNullOrBlank(this._blojsomConfiguration.getDefaultUser())) break block29;
                try {
                    blogUser = this._blojsomConfiguration.loadBlog(this._blojsomConfiguration.getDefaultUser());
                }
                catch (BlojsomException e2) {
                    this._logger.error((Object)e2);
                    httpServletResponse.sendError(404, "Requested blog not found: " + user);
                    return;
                }
            }
        }
        if (!this._blojsomConfiguration.checkBlogIDExists(blogUser.getId())) {
            this._blojsomConfiguration.addBlogID(blogUser.getId());
        }
        this.configureFlavorsForBlog(this._servletConfig, blogUser);
        this.configurePluginsForBlog(this._servletConfig, blogUser);
        Blog blog = blogUser.getBlog();
        BlojsomUtils.resolveDynamicBaseAndBlogURL(httpServletRequest, blog, user);
        String flavor = httpServletRequest.getParameter("flavor");
        if (BlojsomUtils.checkNullOrBlank(flavor)) {
            flavor = blog.getBlogDefaultFlavor();
            if (blogUser.getFlavors().get(flavor) == null) {
                flavor = "html";
            }
        } else if (blogUser.getFlavors().get(flavor) == null) {
            flavor = blog.getBlogDefaultFlavor();
            if (blogUser.getFlavors().get(flavor) == null) {
                flavor = "html";
            }
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("BLOJSOM_RESOURCE_MANAGER", this._resourceManager);
        context.put("BLOJSOM_REQUESTED_FLAVOR", flavor);
        BlogEntry[] entries = null;
        BlogCategory[] categories = null;
        try {
            categories = this._fetcher.fetchCategories(httpServletRequest, httpServletResponse, blogUser, flavor, context);
            entries = this._fetcher.fetchEntries(httpServletRequest, httpServletResponse, blogUser, flavor, context);
        }
        catch (BlojsomFetcherException e) {
            this._logger.error((Object)e);
        }
        String[] pluginChain = null;
        Map pluginChainMap = blogUser.getPluginChain();
        pluginChain = httpServletRequest.getParameter("plugins") != null ? BlojsomUtils.parseCommaList(httpServletRequest.getParameter("plugins")) : ((pluginChainValue = (String[])pluginChainMap.get(pluginChainMapKey = flavor + '.' + "blojsom-plugin-chain")) != null && pluginChainValue.length > 0 ? (String[])pluginChainMap.get(pluginChainMapKey) : (String[])pluginChainMap.get("blojsom-plugin-chain"));
        if (entries != null && pluginChain != null && !"".equals(pluginChain)) {
            for (int i = 0; i < pluginChain.length; ++i) {
                String plugin = pluginChain[i];
                if (this._plugins.containsKey(plugin)) {
                    BlojsomPlugin blojsomPlugin = (BlojsomPlugin)this._plugins.get(plugin);
                    this._logger.debug((Object)("blojsom plugin execution: " + blojsomPlugin.getClass().getName()));
                    try {
                        entries = blojsomPlugin.process(httpServletRequest, httpServletResponse, blogUser, context, entries);
                        blojsomPlugin.cleanup();
                    }
                    catch (BlojsomPluginException e) {
                        this._logger.error((Object)e);
                    }
                    continue;
                }
                this._logger.error((Object)("No plugin loaded for: " + plugin));
            }
        }
        String blogdate = null;
        String blogISO8601Date = null;
        String blogUTCDate = null;
        Date blogDateObject = null;
        boolean sendLastModified = true;
        if (httpServletRequest.getParameter("lastmodified") != null) {
            sendLastModified = Boolean.getBoolean(httpServletRequest.getParameter("lastmodified"));
        }
        if (sendLastModified) {
            if (entries != null && entries.length > 0) {
                Long lastModified;
                long _lastmodified;
                BlogEntry _entry = entries[0];
                if (_entry.getNumComments() > 0) {
                    BlogComment _comment = _entry.getCommentsAsArray()[_entry.getNumComments() - 1];
                    _lastmodified = _comment.getCommentDateLong();
                    this._logger.debug((Object)"Adding last-modified header for most recent entry comment");
                } else {
                    _lastmodified = _entry.getLastModified();
                    this._logger.debug((Object)"Adding last-modified header for most recent blog entry");
                }
                if (context.containsKey("BLOJSOM_LAST_MODIFIED") && (lastModified = (Long)context.get("BLOJSOM_LAST_MODIFIED")) > _lastmodified) {
                    _lastmodified = lastModified;
                }
                String etagLastModified = BlojsomUtils.getISO8601Date(new Date(_lastmodified));
                httpServletResponse.addHeader("ETag", "\"" + BlojsomUtils.digestString(etagLastModified) + "\"");
                httpServletResponse.addDateHeader("Last-Modified", _lastmodified);
                blogdate = entries[0].getRFC822Date();
                blogISO8601Date = entries[0].getISO8601Date();
                blogDateObject = entries[0].getDate();
                blogUTCDate = BlojsomUtils.getUTCDate(entries[0].getDate());
            } else {
                this._logger.debug((Object)"Adding last-modified header for current date");
                Date today = new Date();
                blogdate = BlojsomUtils.getRFC822Date(today);
                blogISO8601Date = BlojsomUtils.getISO8601Date(today);
                blogUTCDate = BlojsomUtils.getUTCDate(today);
                blogDateObject = today;
                httpServletResponse.addDateHeader("Last-Modified", today.getTime());
                httpServletResponse.addHeader("ETag", "\"" + BlojsomUtils.digestString(blogISO8601Date) + "\"");
            }
        }
        context.put("BLOJSOM_DATE", blogdate);
        context.put("BLOJSOM_DATE_ISO8601", blogISO8601Date);
        context.put("BLOJSOM_DATE_OBJECT", blogDateObject);
        context.put("BLOJSOM_DATE_UTC", blogUTCDate);
        context.put("BLOJSOM_BLOG", blog);
        context.put("BLOJSOM_SITE_URL", blog.getBlogBaseURL());
        context.put("BLOJSOM_ENTRIES", entries);
        context.put("BLOJSOM_CATEGORIES", categories);
        context.put("BLOJSOM_COMMENTS_ENABLED", blog.getBlogCommentsEnabled());
        context.put("BLOJSOM_VERSION", "blojsom v2.28");
        context.put("BLOJSOM_USER", blogUser.getId());
        context.put("BLOJSOM_PLUGINS", Collections.unmodifiableMap(this._plugins));
        Map flavorToTemplate = blogUser.getFlavorToTemplate();
        String flavorTemplate = flavorToTemplate.get(flavor) == null ? (String)flavorToTemplate.get("html") : (String)flavorToTemplate.get(flavor);
        Map flavorToContentType = blogUser.getFlavorToContentType();
        String flavorContentType = (String)flavorToContentType.get(flavor);
        String templateExtension = BlojsomUtils.getFileExtension(flavorTemplate);
        this._logger.debug((Object)("Template extension: " + templateExtension));
        BlojsomDispatcher dispatcher = (BlojsomDispatcher)this._dispatchers.get(templateExtension);
        dispatcher.dispatch(httpServletRequest, httpServletResponse, blogUser, context, flavorTemplate, flavorContentType);
    }

    public void destroy() {
        super.destroy();
        try {
            this._fetcher.destroy();
        }
        catch (BlojsomFetcherException e) {
            this._logger.error((Object)e);
        }
        Iterator pluginIteratorIterator = this._plugins.keySet().iterator();
        while (pluginIteratorIterator.hasNext()) {
            String pluginName = (String)pluginIteratorIterator.next();
            BlojsomPlugin plugin = (BlojsomPlugin)this._plugins.get(pluginName);
            try {
                plugin.destroy();
                this._logger.debug((Object)("Removed blojsom plugin: " + plugin.getClass().getName()));
            }
            catch (BlojsomPluginException e) {
                this._logger.error((Object)e);
            }
        }
        this._logger.debug((Object)"blojsom destroyed");
    }
}

