/*
 * Decompiled with CFR 0.152.
 */
package org.blojsom.extension.atomapi;

import java.util.Date;
import org.blojsom.blog.Blog;
import org.blojsom.blog.BlogEntry;
import org.blojsom.blog.BlogUser;
import org.blojsom.extension.atomapi.AtomAPIConstants;
import org.blojsom.util.BlojsomUtils;
import org.intabulas.sandler.SyndicationFactory;
import org.intabulas.sandler.authentication.DigestUtilities;
import org.intabulas.sandler.elements.Content;
import org.intabulas.sandler.elements.Entry;
import org.intabulas.sandler.elements.Link;
import org.intabulas.sandler.elements.impl.ContentImpl;
import org.intabulas.sandler.elements.impl.EntryImpl;
import org.intabulas.sandler.elements.impl.LinkImpl;

public class AtomUtils
implements AtomAPIConstants {
    public static String generateNextNonce(BlogUser user) {
        String nonce = BlojsomUtils.getISO8601Date((Date)new Date()) + ":" + user.getId() + ":" + user.getBlog().getBlogDescription();
        return DigestUtilities.digestString((String)nonce);
    }

    public static Entry fromBlogEntry(Blog blog, BlogUser user, BlogEntry blogentry, String servletPath) {
        EntryImpl result = new EntryImpl();
        result.setTitle(blogentry.getEscapedTitle());
        result.setSummary(blogentry.getEscapedTitle());
        result.setCreated(blogentry.getDate());
        result.setIssued(blogentry.getDate());
        result.setModified(new Date(blogentry.getLastModified()));
        result.setId("tag:" + blog.getBlogOwnerEmail() + "," + blogentry.getDateAsFormat("yyyy-MM-dd") + ":" + blogentry.getId());
        LinkImpl link = new LinkImpl();
        link.setType("text/html");
        link.setRelationship("alternate");
        link.setHref(blogentry.getEscapedLink());
        result.addLink((Link)link);
        LinkImpl editlink = new LinkImpl();
        editlink.setType("application/x.atom+xml");
        editlink.setRelationship("service.edit");
        editlink.setHref(blog.getBlogBaseURL() + servletPath + blogentry.getId());
        result.addLink((Link)editlink);
        result.setAuthor(SyndicationFactory.createPerson((String)blog.getBlogOwner(), (String)blog.getBlogOwnerEmail(), (String)blog.getBlogURL()));
        ContentImpl content = new ContentImpl();
        content.setMimeType("text/html");
        content.setMode("escaped");
        content.setBody(blogentry.getEscapedDescription());
        result.addContent((Content)content);
        return result;
    }

    public static Entry fromBlogEntrySearch(Blog blog, BlogUser user, BlogEntry blogentry, String servletMapping) {
        EntryImpl result = new EntryImpl();
        result.setTitle(blogentry.getEscapedTitle());
        result.setId(blog.getBlogBaseURL() + servletMapping + user.getId() + blogentry.getId());
        return result;
    }

    public static String getSOAPActionMethod(String soapaction) {
        String result = null;
        int idx = soapaction.lastIndexOf(47);
        if (idx != -1) {
            result = soapaction.substring(idx);
        }
        return result;
    }
}

