/*
 * Decompiled with CFR 0.152.
 */
package org.blojsom.extension.comment;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.mail.Session;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.blojsom.BlojsomException;
import org.blojsom.blog.Blog;
import org.blojsom.blog.BlogComment;
import org.blojsom.blog.BlogEntry;
import org.blojsom.blog.BlogUser;
import org.blojsom.blog.BlojsomConfigurationException;
import org.blojsom.event.BlojsomEvent;
import org.blojsom.fetcher.BlojsomFetcher;
import org.blojsom.fetcher.BlojsomFetcherException;
import org.blojsom.plugin.comment.event.CommentAddedEvent;
import org.blojsom.plugin.email.EmailMessage;
import org.blojsom.plugin.email.EmailUtils;
import org.blojsom.servlet.BlojsomBaseServlet;
import org.blojsom.util.BlojsomConstants;
import org.blojsom.util.BlojsomProperties;
import org.blojsom.util.BlojsomUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class CommentAPIServlet
extends BlojsomBaseServlet
implements BlojsomConstants {
    private static final String COMMENTAPI_TITLE = "title";
    private static final String COMMENTAPI_LINK = "link";
    private static final String COMMENTAPI_DESCRIPTION = "description";
    private static final String COMMENTAPI_AUTHOR = "author";
    private static final String BLOG_VELOCITY_PROPERTIES_IP = "velocity-properties";
    private static final String DEFAULT_VELOCITY_PROPERTIES = "/WEB-INF/velocity.properties";
    private Log _logger = LogFactory.getLog((Class)CommentAPIServlet.class);
    private Session _mailsession = null;
    private ServletConfig _servletConfig;
    private Properties _velocityProperties;

    public void init(ServletConfig servletConfig) throws ServletException {
        String velocityConfiguration;
        super.init(servletConfig);
        this._servletConfig = servletConfig;
        String _hostname = servletConfig.getInitParameter("smtp-server");
        if (_hostname != null) {
            Properties _props = new Properties();
            _props.put("mail.smtp.host", _hostname);
            this._mailsession = Session.getInstance((Properties)_props);
        }
        if (BlojsomUtils.checkNullOrBlank((String)(velocityConfiguration = servletConfig.getInitParameter(BLOG_VELOCITY_PROPERTIES_IP)))) {
            velocityConfiguration = DEFAULT_VELOCITY_PROPERTIES;
        }
        this._velocityProperties = new Properties();
        InputStream is = servletConfig.getServletContext().getResourceAsStream(velocityConfiguration);
        try {
            this._velocityProperties.load(is);
            is.close();
        }
        catch (Exception e) {
            this._logger.error((Object)e);
        }
        this.configureBlojsom(servletConfig);
    }

    private BlogUser loadBlogUser(String userID) {
        BlogUser blogUser = new BlogUser();
        blogUser.setId(userID);
        try {
            BlojsomProperties userProperties = new BlojsomProperties();
            InputStream is = this._servletConfig.getServletContext().getResourceAsStream(this._baseConfigurationDirectory + userID + '/' + "blog.properties");
            if (is == null) {
                return null;
            }
            userProperties.load(is);
            is.close();
            Blog userBlog = new Blog((Properties)userProperties);
            blogUser.setBlog(userBlog);
            this._logger.debug((Object)("Configured blojsom user: " + blogUser.getId()));
        }
        catch (BlojsomConfigurationException e) {
            this._logger.error((Object)e);
            return null;
        }
        catch (IOException e) {
            this._logger.error((Object)e);
            return null;
        }
        return blogUser;
    }

    protected void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        try {
            httpServletRequest.setCharacterEncoding("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            this._logger.error((Object)e);
        }
        String commentAuthor = null;
        String commentEmail = null;
        String commentLink = null;
        String commentText = null;
        String commentTitle = null;
        String userFromPath = BlojsomUtils.getUserFromPath((String)httpServletRequest.getPathInfo());
        if (userFromPath == null) {
            httpServletResponse.sendError(404, "Requested user not available in URL");
            return;
        }
        String user = userFromPath;
        String requestedCategory = BlojsomUtils.getCategoryFromPath((String)httpServletRequest.getPathInfo());
        requestedCategory = BlojsomUtils.urlDecode((String)requestedCategory);
        requestedCategory = BlojsomUtils.normalize((String)requestedCategory);
        if (BlojsomUtils.checkNullOrBlank((String)user) || "/".equals(user)) {
            httpServletResponse.sendError(404, "Requested user not available in URL");
            return;
        }
        BlogUser blogUser = this.loadBlogUser(user);
        if (blogUser == null) {
            httpServletResponse.sendError(404, "Requested user not available: " + user);
            return;
        }
        Blog blog = blogUser.getBlog();
        BlojsomUtils.resolveDynamicBaseAndBlogURL((HttpServletRequest)httpServletRequest, (Blog)blog, (String)user);
        this._logger.info((Object)("Processing a comment for [" + user + "] in category [" + requestedCategory + "]"));
        if (blog.getBlogCommentsEnabled().booleanValue() && httpServletRequest.getContentLength() > 0) {
            String permalink = httpServletRequest.getParameter("permalink");
            try {
                NodeList comment;
                DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                Document document = builder.parse((InputStream)httpServletRequest.getInputStream());
                Element docElement = document.getDocumentElement();
                if (docElement.hasChildNodes() && (comment = docElement.getChildNodes()).getLength() > 0) {
                    for (int x = 0; x < comment.getLength(); ++x) {
                        Node node = comment.item(x);
                        if (node.getNodeType() != 1) continue;
                        if (node.getNodeName().equals(COMMENTAPI_LINK)) {
                            commentLink = node.getFirstChild().getNodeValue();
                        }
                        if (node.getNodeName().equals(COMMENTAPI_TITLE)) {
                            commentTitle = node.getFirstChild().getNodeValue();
                        }
                        if (node.getNodeName().equals(COMMENTAPI_AUTHOR)) {
                            commentAuthor = node.getFirstChild().getNodeValue();
                        }
                        if (!node.getNodeName().equals(COMMENTAPI_DESCRIPTION)) continue;
                        commentText = node.getFirstChild().getNodeValue();
                    }
                }
            }
            catch (ParserConfigurationException e) {
                this._logger.error((Object)e);
                httpServletResponse.sendError(500, e.getMessage());
                return;
            }
            catch (FactoryConfigurationError e) {
                this._logger.error((Object)e);
                httpServletResponse.sendError(500, e.getMessage());
                return;
            }
            catch (SAXException e) {
                this._logger.error((Object)e);
                httpServletResponse.sendError(500, e.getMessage());
                return;
            }
            catch (IOException e) {
                this._logger.error((Object)e);
                httpServletResponse.sendError(500, e.getMessage());
                return;
            }
            if (commentAuthor != null) {
                try {
                    InternetAddress emailaddress = new InternetAddress(commentAuthor);
                    commentEmail = emailaddress.getAddress();
                    commentAuthor = emailaddress.getPersonal();
                }
                catch (AddressException e) {
                    this._logger.error((Object)e);
                }
            } else {
                commentAuthor = "";
                commentEmail = "";
            }
            if (commentLink == null) {
                commentLink = "";
            }
            if (commentText != null) {
                this._logger.debug((Object)"Comment API ==============================================");
                this._logger.debug((Object)(" Blog User: " + user));
                this._logger.debug((Object)("  Category: " + requestedCategory));
                this._logger.debug((Object)(" Permalink: " + permalink));
                this._logger.debug((Object)(" Commenter: " + commentAuthor));
                this._logger.debug((Object)("Cmtr Email: " + commentEmail));
                this._logger.debug((Object)("      Link: " + commentLink));
                this._logger.debug((Object)("   Comment: \n" + commentText));
                BlogComment comment = this._fetcher.newBlogComment();
                try {
                    BlogEntry blogEntry = BlojsomUtils.fetchEntry((BlojsomFetcher)this._fetcher, (BlogUser)blogUser, (String)requestedCategory, (String)permalink);
                    comment.setAuthor(commentAuthor);
                    comment.setAuthorEmail(commentEmail);
                    comment.setAuthorURL(commentLink);
                    comment.setComment(commentText);
                    comment.setCommentDate(new Date());
                    comment.setBlogEntry(blogEntry);
                    comment.save(blogUser);
                    this._blojsomConfiguration.getEventBroadcaster().broadcastEvent((BlojsomEvent)new CommentAddedEvent((Object)this, new Date(), comment, blogUser));
                    this.sendCommentEmail(blogUser, blogEntry, comment);
                    httpServletResponse.setStatus(200);
                }
                catch (BlojsomFetcherException e) {
                    this._logger.error((Object)e);
                    httpServletResponse.sendError(404, "Could not find blog entry: " + requestedCategory + permalink);
                }
                catch (BlojsomException e) {
                    this._logger.error((Object)e);
                    httpServletResponse.sendError(500, e.getMessage());
                }
            } else {
                httpServletResponse.sendError(500, "No comment text available");
            }
        } else {
            httpServletResponse.sendError(500, "Blog comments not enabled or No content in request");
        }
    }

    private String getVelocityFileLoaderPath(String userId) {
        StringBuffer fileLoaderPath = new StringBuffer();
        fileLoaderPath.append(this._blojsomConfiguration.getInstallationDirectory());
        fileLoaderPath.append(BlojsomUtils.removeInitialSlash((String)this._baseConfigurationDirectory));
        fileLoaderPath.append(userId).append("/");
        fileLoaderPath.append(BlojsomUtils.removeInitialSlash((String)this._blojsomConfiguration.getTemplatesDirectory()));
        fileLoaderPath.append(", ");
        fileLoaderPath.append(this._blojsomConfiguration.getInstallationDirectory());
        fileLoaderPath.append(BlojsomUtils.removeInitialSlash((String)this._baseConfigurationDirectory));
        fileLoaderPath.append(BlojsomUtils.removeInitialSlash((String)this._blojsomConfiguration.getTemplatesDirectory()));
        return fileLoaderPath.toString();
    }

    private String mergeTemplate(String template, BlogUser user, Map context) {
        VelocityEngine velocityEngine = new VelocityEngine();
        try {
            Properties updatedVelocityProperties = (Properties)this._velocityProperties.clone();
            updatedVelocityProperties.setProperty("file.resource.loader.path", this.getVelocityFileLoaderPath(user.getId()));
            velocityEngine.init(updatedVelocityProperties);
        }
        catch (Exception e) {
            this._logger.error((Object)e);
            return null;
        }
        StringWriter writer = new StringWriter();
        VelocityContext velocityContext = new VelocityContext(context);
        if (!velocityEngine.templateExists(template)) {
            this._logger.error((Object)("Could not find template for user: " + template));
            return null;
        }
        try {
            velocityEngine.mergeTemplate(template, "UTF-8", (Context)velocityContext, (Writer)writer);
        }
        catch (Exception e) {
            this._logger.error((Object)e);
            return null;
        }
        this._logger.debug((Object)("Merged template: " + template));
        return writer.toString();
    }

    private void sendCommentEmail(BlogUser blogUser, BlogEntry entry, BlogComment comment) {
        HashMap<String, Object> emailTemplateContext = new HashMap<String, Object>();
        emailTemplateContext.put("BLOJSOM_BLOG", blogUser.getBlog());
        emailTemplateContext.put("BLOJSOM_USER", blogUser);
        emailTemplateContext.put("BLOJSOM_COMMENT_PLUGIN_BLOG_COMMENT", comment);
        emailTemplateContext.put("BLOJSOM_COMMENT_PLUGIN_BLOG_ENTRY", entry);
        String emailComment = this.mergeTemplate("org/blojsom/plugin/comment/comment-plugin-email-template.vm", blogUser, emailTemplateContext);
        try {
            String commentPrefix = blogUser.getBlog().getBlogProperty("plugin-comment-email-prefix");
            if (BlojsomUtils.checkNullOrBlank((String)commentPrefix)) {
                commentPrefix = "[blojsom] Comment on: ";
            }
            EmailMessage emailMessage = new EmailMessage(commentPrefix + entry.getTitle(), emailComment);
            InternetAddress defaultRecipient = new InternetAddress(blogUser.getBlog().getBlogOwnerEmail(), blogUser.getBlog().getBlogOwner());
            EmailUtils.sendMailMessage((Session)this._mailsession, (EmailMessage)emailMessage, (InternetAddress)defaultRecipient);
        }
        catch (UnsupportedEncodingException e) {
            this._logger.error((Object)e);
        }
    }

    public void destroy() {
    }
}

