/*
 * Decompiled with CFR 0.152.
 */
package org.blojsom.extension.xmlrpc.handlers;

import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlrpc.XmlRpcException;
import org.blojsom.BlojsomException;
import org.blojsom.blog.BlogCategory;
import org.blojsom.blog.BlogEntry;
import org.blojsom.blog.BlogUser;
import org.blojsom.event.BlojsomEvent;
import org.blojsom.extension.xmlrpc.handlers.AbstractBlojsomAPIHandler;
import org.blojsom.plugin.admin.event.AddBlogEntryEvent;
import org.blojsom.plugin.admin.event.DeletedBlogEntryEvent;
import org.blojsom.plugin.admin.event.UpdatedBlogEntryEvent;
import org.blojsom.util.BlojsomUtils;

public class BloggerAPIHandler
extends AbstractBlojsomAPIHandler {
    private static final String MEMBER_URL = "url";
    private static final String MEMBER_BLOGID = "blogid";
    private static final String MEMBER_POSTID = "postid";
    private static final String MEMBER_BLOGNAME = "blogName";
    private static final String MEMBER_TITLE = "title";
    private static final String MEMBER_CONTENT = "content";
    private static final String MEMBER_DATECREATED = "dateCreated";
    private static final String MEMBER_AUTHORNAME = "authorName";
    private static final String MEMBER_AUTHOREMAIL = "authorEmail";
    private static final String MEMBER_NICKNAME = "nickname";
    private static final String MEMBER_USERID = "userid";
    private static final String MEMBER_EMAIL = "email";
    private static final String MEMBER_FIRSTNAME = "firstname";
    private static final String MEMBER_LASTNAME = "lastname";
    private static final String TITLE_TAG_START = "<title>";
    private static final String TITLE_TAG_END = "</title>";
    public static final String API_PREFIX = "blogger";
    private static final String BLOGGER_API_PERMISSION = "post_via_blogger_api";
    private Log _logger = LogFactory.getLog((Class)BloggerAPIHandler.class);

    public String getName() {
        return API_PREFIX;
    }

    public void setBlogUser(BlogUser blogUser) throws BlojsomException {
        this._blogUser = blogUser;
        this._blog = this._blogUser.getBlog();
        this._blogEntryExtension = this._blog.getBlogProperty("blog-xmlrpc-entry-extension");
        if (BlojsomUtils.checkNullOrBlank((String)this._blogEntryExtension)) {
            this._blogEntryExtension = ".html";
        }
    }

    public Object getUserInfo(String appkey, String userid, String password) throws Exception {
        this._logger.debug((Object)"getUserInfo() Called =====[ SUPPORTED ]=======");
        this._logger.debug((Object)("     Appkey: " + appkey));
        this._logger.debug((Object)("     UserId: " + userid));
        this._logger.debug((Object)"   Password: *********");
        try {
            this._authorizationProvider.loadAuthenticationCredentials(this._blogUser);
            this._authorizationProvider.authorize(this._blogUser, null, userid, password);
            this.checkXMLRPCPermission(userid, BLOGGER_API_PERMISSION);
            Hashtable<String, String> userinfo = new Hashtable<String, String>();
            userinfo.put(MEMBER_EMAIL, this._blog.getBlogOwnerEmail());
            userinfo.put(MEMBER_NICKNAME, userid);
            userinfo.put(MEMBER_USERID, "1");
            userinfo.put(MEMBER_URL, this._blog.getBlogURL());
            String _ownerName = this._blog.getBlogOwner();
            int _split = _ownerName.indexOf(" ");
            if (_split > 0) {
                userinfo.put(MEMBER_FIRSTNAME, _ownerName.substring(0, _split));
                userinfo.put(MEMBER_LASTNAME, _ownerName.substring(_split + 1));
            } else {
                userinfo.put(MEMBER_FIRSTNAME, "blojsom");
                userinfo.put(MEMBER_LASTNAME, _ownerName);
            }
            return userinfo;
        }
        catch (BlojsomException e) {
            this._logger.error((Object)("Failed to authenticate user [" + userid + "] with password [" + password + "]"));
            throw new XmlRpcException(1, "Invalid username and/or password");
        }
    }

    public Object getUsersBlogs(String appkey, String userid, String password) throws Exception {
        this._logger.debug((Object)"getUsersBlogs() Called ===[ SUPPORTED ]=======");
        this._logger.debug((Object)("     Appkey: " + appkey));
        this._logger.debug((Object)("     UserId: " + userid));
        this._logger.debug((Object)"   Password: *********");
        try {
            this._authorizationProvider.loadAuthenticationCredentials(this._blogUser);
            this._authorizationProvider.authorize(this._blogUser, null, userid, password);
            this.checkXMLRPCPermission(userid, BLOGGER_API_PERMISSION);
            Vector result = new Vector();
            BlogCategory[] _categories = this._fetcher.fetchCategories(null, this._blogUser);
            if (_categories != null) {
                for (int x = 0; x < _categories.length; ++x) {
                    Hashtable<String, String> _bloglist = new Hashtable<String, String>(3);
                    BlogCategory _category = _categories[x];
                    String _blogid = _category.getCategory();
                    if (_blogid.length() > 1) {
                        _blogid = BlojsomUtils.removeInitialSlash((String)_blogid);
                    }
                    String _description = "";
                    Map _metadata = _category.getMetaData();
                    _description = _metadata != null && _metadata.containsKey("blojsom.name") ? (String)_metadata.get("blojsom.name") : _category.getEncodedCategory();
                    _bloglist.put(MEMBER_URL, _category.getCategoryURL());
                    _bloglist.put(MEMBER_BLOGID, _blogid);
                    _bloglist.put(MEMBER_BLOGNAME, _description);
                    result.add(_bloglist);
                }
            } else {
                throw new XmlRpcException(3000, "There are no categories defined");
            }
            return result;
        }
        catch (BlojsomException e) {
            this._logger.error((Object)("Failed to authenticate user [" + userid + "] with password [" + password + "]"));
            throw new XmlRpcException(1, "Invalid username and/or password");
        }
    }

    private String findTitleInContent(String content) {
        int titleTagEndIndex;
        String titleFromContent = null;
        int titleTagStartIndex = content.indexOf(TITLE_TAG_START);
        if (titleTagStartIndex != -1 && (titleTagEndIndex = content.indexOf(TITLE_TAG_END)) != -1 && titleTagEndIndex > titleTagStartIndex) {
            titleFromContent = content.substring(titleTagStartIndex + TITLE_TAG_START.length(), titleTagEndIndex);
        }
        return titleFromContent;
    }

    public String newPost(String appkey, String blogid, String userid, String password, String content, boolean publish) throws Exception {
        this._logger.debug((Object)"newPost() Called ===========[ SUPPORTED ]=====");
        this._logger.debug((Object)("     Appkey: " + appkey));
        this._logger.debug((Object)("     BlogId: " + blogid));
        this._logger.debug((Object)("     UserId: " + userid));
        this._logger.debug((Object)"   Password: *********");
        this._logger.debug((Object)("    Publish: " + publish));
        this._logger.debug((Object)("     Content:\n " + content));
        blogid = BlojsomUtils.normalize((String)blogid);
        try {
            this._authorizationProvider.loadAuthenticationCredentials(this._blogUser);
            this._authorizationProvider.authorize(this._blogUser, null, userid, password);
            this.checkXMLRPCPermission(userid, BLOGGER_API_PERMISSION);
            String result = null;
            String title = this.findTitleInContent(content);
            try {
                String postid;
                BlogEntry entry = this._fetcher.newBlogEntry();
                HashMap<String, String> blogEntryMetaData = new HashMap<String, String>();
                entry.setCategory(blogid);
                if (title != null) {
                    content = BlojsomUtils.replace((String)content, (String)(TITLE_TAG_START + title + TITLE_TAG_END), (String)"");
                    entry.setTitle(title);
                }
                entry.setDescription(content);
                blogEntryMetaData.put("blog-entry-author", userid);
                blogEntryMetaData.put("blog-entry-metadata-timestamp", new Long(new Date().getTime()).toString());
                entry.setMetaData(blogEntryMetaData);
                entry.save(this._blogUser);
                entry.load(this._blogUser);
                result = postid = blogid + "?" + "permalink" + "=" + entry.getPermalink();
                this._configuration.getEventBroadcaster().broadcastEvent((BlojsomEvent)new AddBlogEntryEvent((Object)this, new Date(), entry, this._blogUser));
            }
            catch (BlojsomException e) {
                this._logger.error((Object)e);
                throw new XmlRpcException(1000, "An error occured processing your request");
            }
            return result;
        }
        catch (BlojsomException e) {
            this._logger.error((Object)("Failed to authenticate user [" + userid + "] with password [" + password + "]"));
            throw new XmlRpcException(1, "Invalid username and/or password");
        }
    }

    public boolean editPost(String appkey, String postid, String userid, String password, String content, boolean publish) throws Exception {
        this._logger.debug((Object)"editPost() Called ========[ SUPPORTED ]=====");
        this._logger.debug((Object)("     Appkey: " + appkey));
        this._logger.debug((Object)("     PostId: " + postid));
        this._logger.debug((Object)("     UserId: " + userid));
        this._logger.debug((Object)"   Password: *********");
        this._logger.debug((Object)("    Publish: " + publish));
        this._logger.debug((Object)("     Content:\n " + content));
        try {
            this._authorizationProvider.loadAuthenticationCredentials(this._blogUser);
            this._authorizationProvider.authorize(this._blogUser, null, userid, password);
            this.checkXMLRPCPermission(userid, BLOGGER_API_PERMISSION);
            boolean result = false;
            String match = "?permalink=";
            int pos = postid.indexOf(match);
            if (pos != -1) {
                String category = postid.substring(0, pos);
                category = BlojsomUtils.normalize((String)category);
                category = BlojsomUtils.urlDecode((String)category);
                String permalink = postid.substring(pos + match.length());
                HashMap<String, Object> fetchMap = new HashMap<String, Object>();
                BlogCategory blogCategory = this._fetcher.newBlogCategory();
                blogCategory.setCategory(category);
                blogCategory.setCategoryURL(this._blog.getBlogURL() + category);
                fetchMap.put("FETCHER_CATEGORY", blogCategory);
                fetchMap.put("FETCHER_PERMALINK", permalink);
                BlogEntry[] _entries = this._fetcher.fetchEntries(fetchMap, this._blogUser);
                if (_entries != null && _entries.length > 0) {
                    BlogEntry _entry = _entries[0];
                    try {
                        String title = this.findTitleInContent(content);
                        if (title != null) {
                            content = BlojsomUtils.replace((String)content, (String)(TITLE_TAG_START + title + TITLE_TAG_END), (String)"");
                            _entry.setTitle(title);
                        } else {
                            _entry.setTitle(null);
                        }
                        _entry.setDescription(content);
                        _entry.save(this._blogUser);
                        result = true;
                        this._configuration.getEventBroadcaster().broadcastEvent((BlojsomEvent)new UpdatedBlogEntryEvent((Object)this, new Date(), _entry, this._blogUser));
                    }
                    catch (BlojsomException e) {
                        this._logger.error((Object)e);
                        throw new XmlRpcException(1000, "An error occured processing your request");
                    }
                } else {
                    throw new XmlRpcException(2000, "The entry postid you submitted is invalid");
                }
            }
            return result;
        }
        catch (BlojsomException e) {
            this._logger.error((Object)("Failed to authenticate user [" + userid + "] with password [" + password + "]"));
            throw new XmlRpcException(1, "Invalid username and/or password");
        }
    }

    public Object getPost(String appkey, String blogid, String userid, String password) throws Exception {
        this._logger.debug((Object)"getPost() Called ===========[ SUPPORTED ]=====");
        this._logger.debug((Object)("     Appkey: " + appkey));
        this._logger.debug((Object)("     BlogId: " + blogid));
        this._logger.debug((Object)("     UserId: " + userid));
        this._logger.debug((Object)"   Password: *********");
        try {
            this._authorizationProvider.loadAuthenticationCredentials(this._blogUser);
            this._authorizationProvider.authorize(this._blogUser, null, userid, password);
            this.checkXMLRPCPermission(userid, BLOGGER_API_PERMISSION);
            String match = "?permalink=";
            int pos = blogid.indexOf(match);
            if (pos != -1) {
                String category = blogid.substring(0, pos);
                category = BlojsomUtils.normalize((String)category);
                category = BlojsomUtils.urlDecode((String)category);
                String permalink = blogid.substring(pos + match.length());
                HashMap<String, Object> fetchMap = new HashMap<String, Object>();
                BlogCategory blogCategory = this._fetcher.newBlogCategory();
                blogCategory.setCategory(category);
                blogCategory.setCategoryURL(this._blog.getBlogURL() + category);
                fetchMap.put("FETCHER_CATEGORY", blogCategory);
                fetchMap.put("FETCHER_PERMALINK", permalink);
                BlogEntry[] _entries = this._fetcher.fetchEntries(fetchMap, this._blogUser);
                if (_entries != null && _entries.length > 0) {
                    BlogEntry entry = _entries[0];
                    Hashtable<String, Object> entrystruct = new Hashtable<String, Object>();
                    entrystruct.put(MEMBER_POSTID, entry.getId());
                    entrystruct.put(MEMBER_BLOGID, entry.getCategory());
                    entrystruct.put(MEMBER_TITLE, entry.getTitle());
                    entrystruct.put(MEMBER_URL, entry.getEscapedLink());
                    entrystruct.put(MEMBER_CONTENT, entry.getTitle() + LINE_SEPARATOR + entry.getDescription());
                    entrystruct.put(MEMBER_DATECREATED, entry.getDate());
                    entrystruct.put(MEMBER_AUTHORNAME, this._blog.getBlogOwner());
                    entrystruct.put(MEMBER_AUTHOREMAIL, this._blog.getBlogOwnerEmail());
                    return entrystruct;
                }
                throw new XmlRpcException(2000, "The entry postid you submitted is invalid");
            }
            throw new XmlRpcException(2000, "The entry postid you submitted is invalid");
        }
        catch (BlojsomException e) {
            this._logger.error((Object)("Failed to authenticate user [" + userid + "] with password [" + password + "]"));
            throw new XmlRpcException(1, "Invalid username and/or password");
        }
    }

    public boolean deletePost(String appkey, String postid, String userid, String password, boolean publish) throws Exception {
        boolean result;
        block5: {
            this._logger.debug((Object)"deletePost() Called =====[ SUPPORTED ]=====");
            this._logger.debug((Object)("     Appkey: " + appkey));
            this._logger.debug((Object)("     PostId: " + postid));
            this._logger.debug((Object)("     UserId: " + userid));
            this._logger.debug((Object)"   Password: *********");
            result = false;
            try {
                this._authorizationProvider.loadAuthenticationCredentials(this._blogUser);
                this._authorizationProvider.authorize(this._blogUser, null, userid, password);
                this.checkXMLRPCPermission(userid, BLOGGER_API_PERMISSION);
                String match = "?permalink=";
                int pos = postid.indexOf(match);
                if (pos == -1) break block5;
                String category = postid.substring(0, pos);
                category = BlojsomUtils.normalize((String)category);
                category = BlojsomUtils.urlDecode((String)category);
                String permalink = postid.substring(pos + match.length());
                HashMap<String, Object> fetchMap = new HashMap<String, Object>();
                BlogCategory blogCategory = this._fetcher.newBlogCategory();
                blogCategory.setCategory(category);
                blogCategory.setCategoryURL(this._blog.getBlogURL() + category);
                fetchMap.put("FETCHER_CATEGORY", blogCategory);
                fetchMap.put("FETCHER_PERMALINK", permalink);
                BlogEntry[] _entries = this._fetcher.fetchEntries(fetchMap, this._blogUser);
                if (_entries != null && _entries.length > 0) {
                    try {
                        _entries[0].delete(this._blogUser);
                    }
                    catch (BlojsomException e) {
                        this._logger.error((Object)e);
                        throw new XmlRpcException(1000, "An error occured processing your request");
                    }
                    result = true;
                    this._configuration.getEventBroadcaster().broadcastEvent((BlojsomEvent)new DeletedBlogEntryEvent((Object)this, new Date(), _entries[0], this._blogUser));
                    break block5;
                }
                throw new XmlRpcException(2000, "The entry postid you submitted is invalid");
            }
            catch (BlojsomException e) {
                this._logger.error((Object)("Failed to authenticate user [" + userid + "] with password [" + password + "]"));
                throw new XmlRpcException(1, "Invalid username and/or password");
            }
        }
        return result;
    }

    public Object getRecentPosts(String appkey, String blogid, String userid, String password, int numposts) throws Exception {
        this._logger.debug((Object)"getRecentPosts() Called ===========[ SUPPORTED ]=====");
        this._logger.debug((Object)("     Appkey: " + appkey));
        this._logger.debug((Object)("     BlogId: " + blogid));
        this._logger.debug((Object)("     UserId: " + userid));
        this._logger.debug((Object)"   Password: *********");
        this._logger.debug((Object)("   Numposts: " + numposts));
        Vector recentPosts = new Vector();
        blogid = BlojsomUtils.normalize((String)blogid);
        try {
            BlogEntry[] entries;
            this._authorizationProvider.loadAuthenticationCredentials(this._blogUser);
            this._authorizationProvider.authorize(this._blogUser, null, userid, password);
            this.checkXMLRPCPermission(userid, BLOGGER_API_PERMISSION);
            String requestedCategory = BlojsomUtils.removeInitialSlash((String)blogid);
            requestedCategory = BlojsomUtils.normalize((String)requestedCategory);
            BlogCategory blogCategory = this._fetcher.newBlogCategory();
            blogCategory.setCategory(blogid);
            blogCategory.setCategoryURL(this._blog.getBlogURL() + requestedCategory);
            HashMap<String, Object> fetchMap = new HashMap<String, Object>();
            if (BlojsomUtils.checkNullOrBlank((String)requestedCategory)) {
                fetchMap.put("FETCHER_FLAVOR", "html");
                fetchMap.put("FETCHER_NUM_POSTS_INTEGER", new Integer(numposts));
                entries = this._fetcher.fetchEntries(fetchMap, this._blogUser);
            } else {
                fetchMap.put("FETCHER_CATEGORY", blogCategory);
                fetchMap.put("FETCHER_NUM_POSTS_INTEGER", new Integer(numposts));
                entries = this._fetcher.fetchEntries(fetchMap, this._blogUser);
            }
            if (entries != null && entries.length > 0) {
                for (int x = 0; x < entries.length; ++x) {
                    BlogEntry entry = entries[x];
                    Hashtable<String, Object> entrystruct = new Hashtable<String, Object>();
                    entrystruct.put(MEMBER_POSTID, entry.getId());
                    entrystruct.put(MEMBER_BLOGID, entry.getCategory());
                    entrystruct.put(MEMBER_TITLE, entry.getTitle());
                    entrystruct.put(MEMBER_URL, entry.getEscapedLink());
                    entrystruct.put(MEMBER_CONTENT, entry.getTitle() + LINE_SEPARATOR + entry.getDescription());
                    entrystruct.put(MEMBER_DATECREATED, entry.getDate());
                    entrystruct.put(MEMBER_AUTHORNAME, this._blog.getBlogOwner());
                    entrystruct.put(MEMBER_AUTHOREMAIL, this._blog.getBlogOwnerEmail());
                    recentPosts.add(entrystruct);
                }
            }
            return recentPosts;
        }
        catch (BlojsomException e) {
            this._logger.error((Object)("Failed to authenticate user [" + userid + "] with password [" + password + "]"));
            throw new XmlRpcException(1, "Invalid username and/or password");
        }
    }

    public boolean setTemplate(String appkey, String blogid, String userid, String password, String template, String templateType) throws Exception {
        this._logger.debug((Object)"setTemplate() Called =====[ UNSUPPORTED ]=====");
        this._logger.debug((Object)("     Appkey: " + appkey));
        this._logger.debug((Object)("     BlogId: " + blogid));
        this._logger.debug((Object)("     UserId: " + userid));
        this._logger.debug((Object)"   Password: *********");
        this._logger.debug((Object)("   Template: " + template));
        this._logger.debug((Object)("       Type: " + templateType));
        throw new XmlRpcException(1001, "Unsupported method");
    }

    public String getTemplate(String appkey, String blogid, String userid, String password, String templateType) throws Exception {
        this._logger.debug((Object)"getTemplate() Called =====[ UNSUPPORTED ]=====");
        this._logger.debug((Object)("     Appkey: " + appkey));
        this._logger.debug((Object)("     BlogId: " + blogid));
        this._logger.debug((Object)("     UserId: " + userid));
        this._logger.debug((Object)"   Password: *********");
        this._logger.debug((Object)("       Type: " + templateType));
        throw new XmlRpcException(1001, "Unsupported method");
    }
}

