/*
 * Decompiled with CFR 0.152.
 */
package org.blojsom.plugin.admin;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.blojsom.blog.BlogEntry;
import org.blojsom.blog.BlogUser;
import org.blojsom.blog.BlojsomConfiguration;
import org.blojsom.plugin.BlojsomPluginException;
import org.blojsom.plugin.admin.BaseAdminPlugin;
import org.blojsom.util.BlojsomProperties;
import org.blojsom.util.BlojsomUtils;

public class EditBlogFlavorsPlugin
extends BaseAdminPlugin {
    private Log _logger = LogFactory.getLog((Class)EditBlogFlavorsPlugin.class);
    private static final String PROTECTED_FLAVORS_IP = "protected-flavors";
    private static final String DEFAULT_PROTECTED_FLAVORS = "admin";
    private static final String EDIT_BLOG_FLAVORS_PAGE = "/org/blojsom/plugin/admin/templates/admin-edit-blog-flavors";
    private static final String DEFAULT_MIME_TYPE = "text/html";
    private static final String DEFAULT_CHARACTER_SET = "UTF-8";
    private static final String BLOJSOM_PLUGIN_EDIT_BLOG_FLAVORS_EXISTING = "BLOJSOM_PLUGIN_EDIT_BLOG_FLAVORS_EXISTING";
    private static final String BLOJSOM_PLUGIN_EDIT_BLOG_FLAVORS_TEMPLATE_FILES = "BLOJSOM_PLUGIN_EDIT_BLOG_FLAVORS_TEMPLATE_FILES";
    private static final String BLOJSOM_PLUGIN_EDIT_BLOG_FLAVORS_FLAVORS = "BLOJSOM_PLUGIN_EDIT_BLOG_FLAVORS_FLAVORS";
    private static final String FAILED_EDIT_FLAVOR_PERMISSION_KEY = "failed.edit.flavor.permission.text";
    private static final String NO_FLAVOR_SPECIFIED_KEY = "no.flavor.specified.text";
    private static final String NO_BLOG_TEMPLATE_SPECIFIED_KEY = "no.blog.template.specified.text";
    private static final String SUCCESSFULLY_ADDED_FLAVOR_KEY = "successfully.added.flavor.text";
    private static final String FAILED_UPDATE_FLAVOR_KEY = "failed.update.flavor.text";
    private static final String FAILED_DELETE_DEFAULT_FLAVOR_KEY = "failed.delete.default.flavor.text";
    private static final String FAILED_DELETE_PROTECTED_FLAVOR_KEY = "failed.delete.protected.flavor.text";
    private static final String SUCCESSFULLY_DELETED_FLAVOR_KEY = "successfully.deleted.flavor.text";
    private static final String ADD_BLOG_FLAVOR_ACTION = "add-blog-flavor";
    private static final String MODIFY_BLOG_FLAVOR_ACTION = "modify-blog-flavor";
    private static final String DELETE_BLOG_FLAVOR_ACTION = "delete-blog-flavor";
    private static final String FLAVOR_NAME = "flavor-name";
    private static final String FLAVOR_MIME_TYPE = "flavor-mime-type";
    private static final String FLAVOR_CHARACTER_SET = "flavor-character-set";
    private static final String BLOG_TEMPLATE = "blog-template";
    private static final String EDIT_BLOG_FLAVORS_PERMISSION = "edit_blog_flavors";
    private String _flavorConfiguration;

    public void init(ServletConfig servletConfig, BlojsomConfiguration blojsomConfiguration) throws BlojsomPluginException {
        super.init(servletConfig, blojsomConfiguration);
        this._flavorConfiguration = servletConfig.getInitParameter("flavor-configuration");
    }

    protected void addFlavorInformationToContext(BlogUser blogUser, Map context) {
        File templatesDirectory = new File(this._blojsomConfiguration.getInstallationDirectory() + BlojsomUtils.removeInitialSlash((String)this._blojsomConfiguration.getBaseConfigurationDirectory()) + blogUser.getId() + this._blojsomConfiguration.getTemplatesDirectory());
        this._logger.debug((Object)("Looking for templates in directory: " + templatesDirectory.toString()));
        File[] templates = templatesDirectory.listFiles();
        ArrayList<String> templatesList = new ArrayList<String>(templates.length);
        for (int i = 0; i < templates.length; ++i) {
            File template = templates[i];
            if (!template.isFile()) continue;
            templatesList.add(template.getName());
            this._logger.debug((Object)("Added template: " + template.getName()));
        }
        context.put(BLOJSOM_PLUGIN_EDIT_BLOG_FLAVORS_FLAVORS, new TreeMap(blogUser.getFlavors()));
        context.put(BLOJSOM_PLUGIN_EDIT_BLOG_FLAVORS_TEMPLATE_FILES, templatesList);
        context.put(BLOJSOM_PLUGIN_EDIT_BLOG_FLAVORS_EXISTING, new TreeMap(blogUser.getFlavorToTemplate()));
    }

    public BlogEntry[] process(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, BlogUser user, Map context, BlogEntry[] entries) throws BlojsomPluginException {
        if (!this.authenticateUser(httpServletRequest, httpServletResponse, context, user)) {
            httpServletRequest.setAttribute("page", (Object)"/org/blojsom/plugin/admin/templates/admin-login");
            return entries;
        }
        String username = this.getUsernameFromSession(httpServletRequest, user.getBlog());
        if (!this.checkPermission(user, null, username, EDIT_BLOG_FLAVORS_PERMISSION)) {
            httpServletRequest.setAttribute("page", (Object)"/org/blojsom/plugin/admin/templates/admin");
            this.addOperationResultMessage(context, this.getAdminResource(FAILED_EDIT_FLAVOR_PERMISSION_KEY, FAILED_EDIT_FLAVOR_PERMISSION_KEY, user.getBlog().getBlogAdministrationLocale()));
            return entries;
        }
        String protectedFlavors = user.getBlog().getBlogProperty(PROTECTED_FLAVORS_IP);
        if (BlojsomUtils.checkNullOrBlank((String)protectedFlavors)) {
            protectedFlavors = DEFAULT_PROTECTED_FLAVORS;
        }
        if (protectedFlavors.indexOf(DEFAULT_PROTECTED_FLAVORS) == -1) {
            protectedFlavors = protectedFlavors + " " + DEFAULT_PROTECTED_FLAVORS;
        }
        this.addFlavorInformationToContext(user, context);
        String action = BlojsomUtils.getRequestValue((String)"action", (HttpServletRequest)httpServletRequest);
        if (BlojsomUtils.checkNullOrBlank((String)action)) {
            this._logger.debug((Object)"User did not request edit action");
            httpServletRequest.setAttribute("page", (Object)"/org/blojsom/plugin/admin/templates/admin");
        } else if ("page".equals(action)) {
            this._logger.debug((Object)"User requested add blog flavor page");
            httpServletRequest.setAttribute("page", (Object)EDIT_BLOG_FLAVORS_PAGE);
        } else if (ADD_BLOG_FLAVOR_ACTION.equals(action) || MODIFY_BLOG_FLAVOR_ACTION.equals(action)) {
            String flavorCharacterSet;
            this._logger.debug((Object)"User requested add blog flavor action");
            String flavorName = BlojsomUtils.getRequestValue((String)FLAVOR_NAME, (HttpServletRequest)httpServletRequest);
            if (BlojsomUtils.checkNullOrBlank((String)flavorName)) {
                this._logger.debug((Object)"No flavor name specified");
                this.addOperationResultMessage(context, this.getAdminResource(NO_FLAVOR_SPECIFIED_KEY, NO_FLAVOR_SPECIFIED_KEY, user.getBlog().getBlogAdministrationLocale()));
                httpServletRequest.setAttribute("page", (Object)EDIT_BLOG_FLAVORS_PAGE);
                return entries;
            }
            String blogTemplate = BlojsomUtils.getRequestValue((String)BLOG_TEMPLATE, (HttpServletRequest)httpServletRequest);
            if (BlojsomUtils.checkNullOrBlank((String)blogTemplate)) {
                this._logger.debug((Object)"No blog template specified");
                this.addOperationResultMessage(context, this.getAdminResource(NO_BLOG_TEMPLATE_SPECIFIED_KEY, NO_BLOG_TEMPLATE_SPECIFIED_KEY, user.getBlog().getBlogAdministrationLocale()));
                httpServletRequest.setAttribute("page", (Object)EDIT_BLOG_FLAVORS_PAGE);
                return entries;
            }
            String flavorMimeType = BlojsomUtils.getRequestValue((String)FLAVOR_MIME_TYPE, (HttpServletRequest)httpServletRequest);
            if (BlojsomUtils.checkNullOrBlank((String)flavorMimeType)) {
                flavorMimeType = DEFAULT_MIME_TYPE;
                this._logger.debug((Object)("Flavor MIME type not specified. Using default: " + flavorMimeType));
            }
            if (BlojsomUtils.checkNullOrBlank((String)(flavorCharacterSet = BlojsomUtils.getRequestValue((String)FLAVOR_CHARACTER_SET, (HttpServletRequest)httpServletRequest)))) {
                flavorCharacterSet = DEFAULT_CHARACTER_SET;
                this._logger.debug((Object)("Flavor character set not specified. Using default: " + flavorCharacterSet));
            }
            Map flavorMapForUser = user.getFlavors();
            Map flavorTemplatesForUser = user.getFlavorToTemplate();
            Map flavorContentTypesForUser = user.getFlavorToContentType();
            flavorMapForUser.put(flavorName, flavorName);
            flavorTemplatesForUser.put(flavorName, blogTemplate);
            flavorContentTypesForUser.put(flavorName, flavorMimeType + ";charset=" + flavorCharacterSet);
            this._logger.debug((Object)("Successfully added flavor: " + flavorName + " using template: " + blogTemplate + " with content type: " + flavorMimeType + ";" + flavorCharacterSet));
            try {
                this.writeFlavorConfiguration(user);
                this.addOperationResultMessage(context, this.formatAdminResource(SUCCESSFULLY_ADDED_FLAVOR_KEY, SUCCESSFULLY_ADDED_FLAVOR_KEY, user.getBlog().getBlogAdministrationLocale(), new Object[]{flavorName, blogTemplate, flavorMimeType, flavorCharacterSet}));
                this._logger.debug((Object)("Successfully wrote flavor configuration file for user: " + user.getId()));
                this.addFlavorInformationToContext(user, context);
            }
            catch (IOException e) {
                this.addOperationResultMessage(context, this.getAdminResource(FAILED_UPDATE_FLAVOR_KEY, FAILED_UPDATE_FLAVOR_KEY, user.getBlog().getBlogAdministrationLocale()));
                this._logger.error((Object)e);
            }
            httpServletRequest.setAttribute("page", (Object)EDIT_BLOG_FLAVORS_PAGE);
        } else if (DELETE_BLOG_FLAVOR_ACTION.equals(action)) {
            this._logger.debug((Object)"User requested delete blog flavor action");
            String flavorName = BlojsomUtils.getRequestValue((String)FLAVOR_NAME, (HttpServletRequest)httpServletRequest);
            if (BlojsomUtils.checkNullOrBlank((String)flavorName)) {
                this._logger.debug((Object)"No flavor name specified");
                this.addOperationResultMessage(context, this.getAdminResource(NO_FLAVOR_SPECIFIED_KEY, NO_FLAVOR_SPECIFIED_KEY, user.getBlog().getBlogAdministrationLocale()));
                httpServletRequest.setAttribute("page", (Object)EDIT_BLOG_FLAVORS_PAGE);
                return entries;
            }
            if (flavorName.equalsIgnoreCase(user.getBlog().getBlogDefaultFlavor())) {
                this._logger.debug((Object)"Cannot delete the default flavor");
                this.addOperationResultMessage(context, this.getAdminResource(FAILED_DELETE_DEFAULT_FLAVOR_KEY, FAILED_DELETE_DEFAULT_FLAVOR_KEY, user.getBlog().getBlogAdministrationLocale()));
                httpServletRequest.setAttribute("page", (Object)EDIT_BLOG_FLAVORS_PAGE);
                return entries;
            }
            if (protectedFlavors.indexOf(flavorName) != -1) {
                this._logger.debug((Object)("Cannot delete protected flavor: " + flavorName));
                this.addOperationResultMessage(context, this.formatAdminResource(FAILED_DELETE_PROTECTED_FLAVOR_KEY, FAILED_DELETE_PROTECTED_FLAVOR_KEY, user.getBlog().getBlogAdministrationLocale(), new Object[]{flavorName}));
                httpServletRequest.setAttribute("page", (Object)EDIT_BLOG_FLAVORS_PAGE);
                return entries;
            }
            user.getFlavors().remove(flavorName);
            user.getFlavorToContentType().remove(flavorName);
            user.getFlavorToTemplate().remove(flavorName);
            try {
                this.writeFlavorConfiguration(user);
                this._logger.debug((Object)("Successfully wrote flavor configuration file for user: " + user.getId()));
                this.addOperationResultMessage(context, this.formatAdminResource(SUCCESSFULLY_DELETED_FLAVOR_KEY, SUCCESSFULLY_DELETED_FLAVOR_KEY, user.getBlog().getBlogAdministrationLocale(), new Object[]{flavorName}));
                this.addFlavorInformationToContext(user, context);
            }
            catch (IOException e) {
                this.addOperationResultMessage(context, this.getAdminResource(FAILED_UPDATE_FLAVOR_KEY, FAILED_UPDATE_FLAVOR_KEY, user.getBlog().getBlogAdministrationLocale()));
                this._logger.error((Object)e);
            }
            httpServletRequest.setAttribute("page", (Object)EDIT_BLOG_FLAVORS_PAGE);
        }
        return entries;
    }

    private void writeFlavorConfiguration(BlogUser user) throws IOException {
        Iterator flavorIterator = user.getFlavors().keySet().iterator();
        BlojsomProperties flavorProperties = new BlojsomProperties();
        Map flavorToTemplateMap = user.getFlavorToTemplate();
        Map flavorToContentTypeMap = user.getFlavorToContentType();
        while (flavorIterator.hasNext()) {
            String flavor = (String)flavorIterator.next();
            flavorProperties.setProperty(flavor, flavorToTemplateMap.get(flavor) + ", " + flavorToContentTypeMap.get(flavor));
        }
        File flavorFile = new File(this._blojsomConfiguration.getInstallationDirectory() + this._blojsomConfiguration.getBaseConfigurationDirectory() + user.getId() + "/" + this._flavorConfiguration);
        FileOutputStream fos = new FileOutputStream(flavorFile);
        flavorProperties.store(fos, null);
        fos.close();
    }
}

