/*
 * Decompiled with CFR 0.152.
 */
package org.blojsom.plugin.admin;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.DiskFileUpload;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.blojsom.blog.BlogEntry;
import org.blojsom.blog.BlogUser;
import org.blojsom.blog.BlojsomConfiguration;
import org.blojsom.event.BlojsomEvent;
import org.blojsom.event.BlojsomListener;
import org.blojsom.plugin.BlojsomPlugin;
import org.blojsom.plugin.BlojsomPluginException;
import org.blojsom.plugin.admin.event.ProcessRequestEvent;
import org.blojsom.util.BlojsomUtils;

public class ThemeUploadPlugin
implements BlojsomPlugin,
BlojsomListener {
    private Log _logger = LogFactory.getLog((Class)ThemeUploadPlugin.class);
    private static final String THEME_UPLOAD_TEMPLATE = "org/blojsom/plugin/admin/templates/admin-theme-upload.vm";
    private String _resourcesDirectory;
    private String _templatesDirectory;
    private String _installationDirectory;
    private String _baseConfigurationDirectory;
    private String _themesDirectory = "/themes";
    protected static final String BLOJSOM_ADMIN_PLUGIN_OPERATION_RESULT = "BLOJSOM_ADMIN_PLUGIN_OPERATION_RESULT";

    public void init(ServletConfig servletConfig, BlojsomConfiguration blojsomConfiguration) throws BlojsomPluginException {
        this._resourcesDirectory = blojsomConfiguration.getResourceDirectory();
        this._templatesDirectory = blojsomConfiguration.getTemplatesDirectory();
        this._installationDirectory = blojsomConfiguration.getInstallationDirectory();
        this._baseConfigurationDirectory = blojsomConfiguration.getBaseConfigurationDirectory();
        blojsomConfiguration.getEventBroadcaster().addListener((BlojsomListener)this);
    }

    public BlogEntry[] process(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, BlogUser user, Map context, BlogEntry[] entries) throws BlojsomPluginException {
        return entries;
    }

    public void cleanup() throws BlojsomPluginException {
    }

    public void destroy() throws BlojsomPluginException {
    }

    public void handleEvent(BlojsomEvent event) {
    }

    protected void addOperationResultMessage(Map context, String message) {
        context.put(BLOJSOM_ADMIN_PLUGIN_OPERATION_RESULT, message);
    }

    public void processEvent(BlojsomEvent event) {
        if (event instanceof ProcessRequestEvent) {
            ProcessRequestEvent requestEvent = (ProcessRequestEvent)event;
            TreeMap<String, String> templateAdditions = (TreeMap<String, String>)requestEvent.getContext().get("BLOJSOM_TEMPLATE_ADDITIONS");
            if (templateAdditions == null) {
                templateAdditions = new TreeMap<String, String>();
            }
            templateAdditions.put(this.getClass().getName(), "#parse('org/blojsom/plugin/admin/templates/admin-theme-upload.vm')");
            requestEvent.getContext().put("BLOJSOM_TEMPLATE_ADDITIONS", templateAdditions);
            DiskFileUpload diskFileUpload = new DiskFileUpload();
            diskFileUpload.setRepositoryPath("/tmp");
            diskFileUpload.setSizeThreshold(300000);
            diskFileUpload.setSizeMax(2000000L);
            try {
                List items = diskFileUpload.parseRequest(requestEvent.getHttpServletRequest());
                Iterator itemsIterator = items.iterator();
                while (itemsIterator.hasNext()) {
                    FileItem item = (FileItem)itemsIterator.next();
                    if (item.isFormField()) continue;
                    String itemNameWithoutPath = BlojsomUtils.getFilenameFromPath((String)item.getName());
                    if (itemNameWithoutPath.toLowerCase().endsWith(".zip")) {
                        this._logger.debug((Object)("Found file item: " + itemNameWithoutPath + " of type: " + item.getContentType()));
                        try {
                            ZipEntry zipEntry;
                            ZipInputStream zipInputStream = new ZipInputStream(item.getInputStream());
                            String themeName = BlojsomUtils.getFilename((String)item.getName());
                            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                                if (zipEntry.isDirectory()) continue;
                                String zipItemName = "/" + zipEntry.getName();
                                if (zipItemName.startsWith(this._resourcesDirectory) || zipItemName.startsWith(this._templatesDirectory)) {
                                    String themeOutputFilename = this.createThemeOutputFilename(themeName, zipItemName);
                                    this.writeThemeFile(themeOutputFilename, zipInputStream);
                                    continue;
                                }
                                this._logger.debug((Object)("Ignoring non-resources or templates file: " + zipEntry.getName()));
                            }
                            zipInputStream.close();
                            this.addOperationResultMessage(requestEvent.getContext(), "Successfully uploaded theme: " + themeName);
                        }
                        catch (IOException e) {
                            this._logger.error((Object)e);
                            this.addOperationResultMessage(requestEvent.getContext(), "Unknown error uploading theme");
                        }
                        continue;
                    }
                    this._logger.debug((Object)"Theme archive file not a recognized .zip extension");
                    this.addOperationResultMessage(requestEvent.getContext(), "Theme archive file not a recognized .zip extension");
                }
            }
            catch (FileUploadException e) {
                // empty catch block
            }
        }
    }

    protected void writeThemeFile(String themeFilename, InputStream themeFileInputStream) throws IOException {
        int length;
        File themeFile = new File(themeFilename);
        File themeFilePath = themeFile.getParentFile();
        if (!themeFilePath.exists()) {
            this._logger.debug((Object)("Trying to create theme file path: " + themeFilePath));
            if (!themeFilePath.mkdirs()) {
                throw new IOException("Could not create paths to upload theme file");
            }
        }
        FileOutputStream out = new FileOutputStream(themeFilename);
        byte[] buffer = new byte[1024];
        while ((length = themeFileInputStream.read(buffer)) > 0) {
            ((OutputStream)out).write(buffer, 0, length);
        }
        ((OutputStream)out).close();
    }

    protected String createThemeOutputFilename(String theme, String file) {
        String outputFilename = this._installationDirectory + this._baseConfigurationDirectory + this._themesDirectory + "/" + theme + file;
        return outputFilename;
    }
}

