/*
 * Decompiled with CFR 0.152.
 */
package org.blojsom.plugin.comment;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.blojsom.blog.Blog;
import org.blojsom.blog.BlogEntry;
import org.blojsom.blog.BlogUser;
import org.blojsom.plugin.BlojsomPluginException;
import org.blojsom.plugin.comment.CommentModerationPlugin;
import org.blojsom.util.BlojsomUtils;

public class MathCommentAuthenticationPlugin
extends CommentModerationPlugin {
    private Log _logger = LogFactory.getLog((Class)MathCommentAuthenticationPlugin.class);
    private static final String MATH_COMMENT_AUTHENTICATION_OPERATIONS_IP = "math-comment-authentication-operations";
    private static final String MATH_COMMENT_AUTHENTICATION_BOUND_IP = "math-comment-authentication-bound";
    public static final String BLOJSOM_MATH_AUTHENTICATOR_PLUGIN_ANSWER = "BLOJSOM_MATH_AUTHENTICATOR_PLUGIN_ANSWER";
    public static final String BLOJSOM_MATH_AUTHENTICATOR_PLUGIN_VALUE1 = "BLOJSOM_MATH_AUTHENTICATOR_PLUGIN_VALUE1";
    public static final String BLOJSOM_MATH_AUTHENTICATOR_PLUGIN_VALUE2 = "BLOJSOM_MATH_AUTHENTICATOR_PLUGIN_VALUE2";
    public static final String BLOJSOM_MATH_AUTHENTICATOR_PLUGIN_OPERATION = "BLOJSOM_MATH_AUTHENTICATOR_PLUGIN_OPERATION";
    public static final String BLOJSOM_MATH_AUTHENTICATOR_PLUGIN_ANSWER_CHECK_PARAM = "mathAnswerCheck";
    public static final String BLOJSOM_MATH_AUTHENTICATOR_PLUGIN_STATUS_MESSAGE = "BLOJSOM_MATH_AUTHENTICATOR_PLUGIN_STATUS_MESSAGE";
    private static final int AVAILABLE_OPERATIONS = 3;
    private static final int BOUND_DEFAULT = 10;

    protected void moderateComment(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, BlogUser user, Map context, BlogEntry[] entries) throws BlojsomPluginException {
        Blog blog = user.getBlog();
        if ("true".equalsIgnoreCase(blog.getBlogProperty("comment-moderation-enabled"))) {
            HttpSession httpSession = httpServletRequest.getSession();
            if ("y".equalsIgnoreCase(httpServletRequest.getParameter("comment")) && user.getBlog().getBlogCommentsEnabled().booleanValue()) {
                String mathAnswerCheck = BlojsomUtils.getRequestValue((String)BLOJSOM_MATH_AUTHENTICATOR_PLUGIN_ANSWER_CHECK_PARAM, (HttpServletRequest)httpServletRequest);
                boolean passedCheck = false;
                if (httpSession.getAttribute(BLOJSOM_MATH_AUTHENTICATOR_PLUGIN_ANSWER) != null) {
                    Integer mathAnswer = (Integer)httpSession.getAttribute(BLOJSOM_MATH_AUTHENTICATOR_PLUGIN_ANSWER);
                    try {
                        int mathAnswerCheckValue = Integer.parseInt(mathAnswerCheck);
                        int originalMathAnswerValue = mathAnswer;
                        if (mathAnswerCheckValue == originalMathAnswerValue) {
                            passedCheck = true;
                        }
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                }
                if (!passedCheck) {
                    Map commentMetaData = context.containsKey("BLOJSOM_PLUGIN_COMMENT_METADATA") ? (Map)context.get("BLOJSOM_PLUGIN_COMMENT_METADATA") : new HashMap();
                    commentMetaData.put("BLOJSOM_PLUGIN_COMMENT_METADATA_DESTROY", Boolean.TRUE);
                    context.put("BLOJSOM_PLUGIN_COMMENT_METADATA", commentMetaData);
                    this._logger.info((Object)"Failed math comment authentication check.");
                    context.put(BLOJSOM_MATH_AUTHENTICATOR_PLUGIN_STATUS_MESSAGE, "Failed math comment authentication check.");
                }
            }
            int bound = 10;
            int availableOperations = 3;
            String boundProperty = blog.getBlogProperty(MATH_COMMENT_AUTHENTICATION_BOUND_IP);
            String availableOperationsProperty = blog.getBlogProperty(MATH_COMMENT_AUTHENTICATION_OPERATIONS_IP);
            if (!BlojsomUtils.checkNullOrBlank((String)boundProperty)) {
                try {
                    bound = Integer.parseInt(boundProperty);
                }
                catch (NumberFormatException e) {
                    this._logger.error((Object)e);
                }
            }
            if (!BlojsomUtils.checkNullOrBlank((String)availableOperationsProperty)) {
                try {
                    availableOperations = Integer.parseInt(availableOperationsProperty);
                    availableOperations = availableOperations < 1 || availableOperations > 3 ? 3 : --availableOperations;
                }
                catch (NumberFormatException e) {
                    this._logger.error((Object)e);
                }
            }
            int operation = (int)(Math.random() * (double)availableOperations);
            int value1 = (int)(Math.random() * (double)bound);
            int value2 = (int)(Math.random() * (double)bound);
            int answer = this.getAnswerForOperation(value1, value2, operation);
            httpSession.setAttribute(BLOJSOM_MATH_AUTHENTICATOR_PLUGIN_VALUE1, (Object)new Integer(value1));
            httpSession.setAttribute(BLOJSOM_MATH_AUTHENTICATOR_PLUGIN_VALUE2, (Object)new Integer(value2));
            httpSession.setAttribute(BLOJSOM_MATH_AUTHENTICATOR_PLUGIN_ANSWER, (Object)new Integer(answer));
            httpSession.setAttribute(BLOJSOM_MATH_AUTHENTICATOR_PLUGIN_OPERATION, (Object)this.getOperatorForOperation(operation));
        }
    }

    protected int getAnswerForOperation(int value1, int value2, int operation) {
        int answer;
        switch (operation) {
            case 0: {
                answer = value1 + value2;
                break;
            }
            case 1: {
                answer = value1 - value2;
                break;
            }
            case 2: {
                answer = value1 * value2;
                break;
            }
            default: {
                answer = value1 + value2;
            }
        }
        return answer;
    }

    protected String getOperatorForOperation(int operation) {
        switch (operation) {
            case 0: {
                return "+";
            }
            case 1: {
                return "-";
            }
            case 2: {
                return "*";
            }
        }
        return "+";
    }
}

