/*
 * Decompiled with CFR 0.152.
 */
package org.blojsom.plugin.common;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.blojsom.blog.BlogEntry;
import org.blojsom.blog.BlogUser;
import org.blojsom.blog.BlojsomConfiguration;
import org.blojsom.fetcher.BlojsomFetcher;
import org.blojsom.fetcher.BlojsomFetcherException;
import org.blojsom.plugin.BlojsomPlugin;
import org.blojsom.plugin.BlojsomPluginException;
import org.blojsom.util.BlojsomConstants;
import org.blojsom.util.BlojsomUtils;

public class AllEntriesPlugin
implements BlojsomPlugin,
BlojsomConstants {
    private Log _logger = LogFactory.getLog((Class)AllEntriesPlugin.class);
    public static final String BLOJSOM_PLUGIN_ALL_ENTRIES = "BLOJSOM_PLUGIN_ALL_ENTRIES";
    protected BlojsomFetcher _fetcher;

    public void init(ServletConfig servletConfig, BlojsomConfiguration blojsomConfiguration) throws BlojsomPluginException {
        String fetcherClassName = blojsomConfiguration.getFetcherClass();
        try {
            Class<?> fetcherClass = Class.forName(fetcherClassName);
            this._fetcher = (BlojsomFetcher)fetcherClass.newInstance();
            this._fetcher.init(servletConfig, blojsomConfiguration);
            this._logger.info((Object)("Added blojsom fetcher: " + fetcherClassName));
        }
        catch (ClassNotFoundException e) {
            this._logger.error((Object)e);
            throw new BlojsomPluginException((Throwable)e);
        }
        catch (InstantiationException e) {
            this._logger.error((Object)e);
            throw new BlojsomPluginException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            this._logger.error((Object)e);
            throw new BlojsomPluginException((Throwable)e);
        }
        catch (BlojsomFetcherException e) {
            this._logger.error((Object)e);
            throw new BlojsomPluginException((Throwable)e);
        }
        this._logger.debug((Object)"Initialized All Entries plugin");
    }

    public BlogEntry[] process(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, BlogUser user, Map context, BlogEntry[] entries) throws BlojsomPluginException {
        String requestedFlavor = (String)context.get("BLOJSOM_REQUESTED_FLAVOR");
        HashMap<String, Object> fetchMap = new HashMap<String, Object>();
        fetchMap.put("FETCHER_FLAVOR", requestedFlavor);
        fetchMap.put("FETCHER_NUM_POSTS_INTEGER", new Integer(-1));
        BlogEntry[] allEntries = new BlogEntry[]{};
        try {
            allEntries = this._fetcher.fetchEntries(fetchMap, user);
            if (allEntries != null) {
                this._logger.debug((Object)("Retrieved " + allEntries.length + " entries from all categories"));
                Arrays.sort(allEntries, BlojsomUtils.FILE_TIME_COMPARATOR);
            } else {
                this._logger.debug((Object)"No entries found");
            }
        }
        catch (BlojsomFetcherException e) {
            this._logger.error((Object)e);
        }
        context.put(BLOJSOM_PLUGIN_ALL_ENTRIES, allEntries);
        return entries;
    }

    public void cleanup() throws BlojsomPluginException {
    }

    public void destroy() throws BlojsomPluginException {
    }
}

