/*
 * Decompiled with CFR 0.152.
 */
package org.blojsom.plugin.helper;

import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.blojsom.blog.BlogEntry;
import org.blojsom.blog.BlogUser;
import org.blojsom.blog.BlojsomConfiguration;
import org.blojsom.plugin.BlojsomPlugin;
import org.blojsom.plugin.BlojsomPluginException;
import org.blojsom.util.BlojsomConstants;
import org.blojsom.util.BlojsomUtils;

public class PluginHelperPlugin
implements BlojsomPlugin,
BlojsomConstants {
    private Log _logger = LogFactory.getLog((Class)PluginHelperPlugin.class);
    private static final String BLOJSOM_PLUGINS = "BLOJSOM_PLUGINS";
    private static final String BLOJSOM_PLUGIN_PLUGIN_HELPER = "BLOJSOM_PLUGIN_PLUGIN_HELPER";

    public void init(ServletConfig servletConfig, BlojsomConfiguration blojsomConfiguration) throws BlojsomPluginException {
    }

    public BlogEntry[] process(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, BlogUser user, Map context, BlogEntry[] entries) throws BlojsomPluginException {
        context.put(BLOJSOM_PLUGIN_PLUGIN_HELPER, new PluginHelper(httpServletRequest, httpServletResponse, context, user));
        return entries;
    }

    public void cleanup() throws BlojsomPluginException {
    }

    public void destroy() throws BlojsomPluginException {
    }

    public class PluginHelper {
        HttpServletRequest _request;
        HttpServletResponse _response;
        Map _context;
        BlogUser _blog;

        public PluginHelper(HttpServletRequest request, HttpServletResponse response, Map context, BlogUser blog) {
            this._request = request;
            this._response = response;
            this._context = context;
            this._blog = blog;
        }

        public void processEntryForPlugin(BlogEntry blogEntry, String plugin) {
            this.processEntriesForPlugin(new BlogEntry[]{blogEntry}, plugin);
        }

        public void processEntryForFlavor(BlogEntry blogEntry, String flavor) {
            this.processEntriesForFlavor(new BlogEntry[]{blogEntry}, flavor);
        }

        public void processEntriesForPlugin(BlogEntry[] entries, String plugin) {
            this.process(entries, plugin, null);
        }

        public void processEntriesForFlavor(BlogEntry[] entries, String flavor) {
            this.process(entries, null, flavor);
        }

        protected void process(BlogEntry[] entries, String plugin, String flavor) {
            String pluginChainMapKey;
            String[] pluginChainValue;
            Map plugins = (Map)this._context.get(PluginHelperPlugin.BLOJSOM_PLUGINS);
            if (plugins == null) {
                return;
            }
            String[] pluginChain = null;
            Map pluginChainMap = this._blog.getPluginChain();
            pluginChain = !BlojsomUtils.checkNullOrBlank((String)plugin) ? new String[]{plugin} : ((pluginChainValue = (String[])pluginChainMap.get(pluginChainMapKey = flavor + '.' + "blojsom-plugin-chain")) != null && pluginChainValue.length > 0 ? (String[])pluginChainMap.get(pluginChainMapKey) : (String[])pluginChainMap.get("blojsom-plugin-chain"));
            if (entries != null && pluginChain != null && !"".equals(pluginChain)) {
                for (int i = 0; i < pluginChain.length; ++i) {
                    String pluginToExecute = pluginChain[i];
                    if (plugins.containsKey(pluginToExecute)) {
                        BlojsomPlugin blojsomPlugin = (BlojsomPlugin)plugins.get(pluginToExecute);
                        PluginHelperPlugin.this._logger.debug((Object)("blojsom plugin execution: " + blojsomPlugin.getClass().getName()));
                        try {
                            entries = blojsomPlugin.process(this._request, this._response, this._blog, this._context, entries);
                            blojsomPlugin.cleanup();
                        }
                        catch (BlojsomPluginException e) {
                            PluginHelperPlugin.this._logger.error((Object)e);
                        }
                        continue;
                    }
                    PluginHelperPlugin.this._logger.error((Object)("No plugin loaded for: " + pluginToExecute));
                }
            }
        }
    }
}

