/*
 * Decompiled with CFR 0.152.
 */
package org.blojsom.plugin.highlight;

import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.blojsom.blog.BlogEntry;
import org.blojsom.blog.BlogUser;
import org.blojsom.blog.BlojsomConfiguration;
import org.blojsom.plugin.BlojsomPlugin;
import org.blojsom.plugin.BlojsomPluginException;

public class GoogleHighlightPlugin
implements BlojsomPlugin {
    private static final String HEADER_REFERER = "referer";
    private static final String START_BOUNDRY = "(\\b";
    private static final String END_BOUNDRY = "\\b)";
    private static final String EXPRESSSION_GOOGLE = "^http:\\/\\/w?w?w?\\.?google.*";
    private static final String EXPRESSION_HTMLPREFIX = "(?<=>)([^<]+)?";
    private static final String EXPRESSION_HASTAGS = "<.+>";
    private static final String GOOGLE_QUERY = "^.*q=([^&]+)&?.*$";
    private static final String GOOGLE_CLEANQUOTES = "'/'|\"/\"";
    private static final String HIGHLIGHT_PLAINTEXT = "<span class=\"searchhighlight\">$1</span>";
    private static final String HIGHLIGHT_HTML = "$1<span class=\"searchhighlight\">$2</span>";

    public void init(ServletConfig servletConfig, BlojsomConfiguration blojsomConfiguration) throws BlojsomPluginException {
    }

    private String[] extractQueryTokens(String referer) {
        String[] result = null;
        Matcher matcher = Pattern.compile(GOOGLE_QUERY, 2).matcher(referer);
        if (matcher.find()) {
            String _query = matcher.group(1);
            _query = _query.replaceAll(GOOGLE_CLEANQUOTES, "");
            StringTokenizer _st = new StringTokenizer(_query, "+, .", false);
            result = new String[_st.countTokens()];
            int cnt = 0;
            while (_st.hasMoreElements()) {
                result[cnt] = _st.nextToken();
                ++cnt;
            }
        }
        return result;
    }

    public BlogEntry[] process(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, BlogUser user, Map context, BlogEntry[] entries) throws BlojsomPluginException {
        String[] searchwords;
        String referer = httpServletRequest.getHeader(HEADER_REFERER);
        if (referer != null && referer.matches(EXPRESSSION_GOOGLE) && (searchwords = this.extractQueryTokens(referer)) != null) {
            Pattern hasTags = Pattern.compile(EXPRESSION_HASTAGS);
            for (int x = 0; x < entries.length; ++x) {
                BlogEntry entry = entries[x];
                Matcher matcher = hasTags.matcher(entry.getDescription());
                boolean isHtml = matcher.find();
                for (int y = 0; y < searchwords.length; ++y) {
                    String word = searchwords[y];
                    if (!isHtml) {
                        entry.setDescription(entry.getDescription().replaceAll(START_BOUNDRY + word + END_BOUNDRY, HIGHLIGHT_PLAINTEXT));
                        continue;
                    }
                    entry.setDescription(entry.getDescription().replaceAll("(?<=>)([^<]+)?(\\b" + word + END_BOUNDRY, HIGHLIGHT_HTML));
                }
            }
        }
        return entries;
    }

    public void cleanup() throws BlojsomPluginException {
    }

    public void destroy() throws BlojsomPluginException {
    }
}

