/*
 * Decompiled with CFR 0.152.
 */
package org.blojsom.plugin.macro;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.blojsom.blog.BlogEntry;
import org.blojsom.blog.BlogUser;
import org.blojsom.blog.BlojsomConfiguration;
import org.blojsom.plugin.BlojsomPlugin;
import org.blojsom.plugin.BlojsomPluginException;
import org.blojsom.util.BlojsomProperties;
import org.blojsom.util.BlojsomUtils;

public class MacroExpansionPlugin
implements BlojsomPlugin {
    public static final String BLOG_MACRO_CONFIGURATION_IP = "plugin-macros-expansion";
    private Log _logger = LogFactory.getLog((Class)MacroExpansionPlugin.class);
    private BlojsomConfiguration _blojsomConfiguration;
    private ServletConfig _servletConfig;
    private String _macroConfiguration;
    private static final String MACRO_REGEX = "(\\$[^\\$]*\\$)";

    public void init(ServletConfig servletConfig, BlojsomConfiguration blojsomConfiguration) throws BlojsomPluginException {
        this._blojsomConfiguration = blojsomConfiguration;
        this._servletConfig = servletConfig;
        this._macroConfiguration = servletConfig.getInitParameter(BLOG_MACRO_CONFIGURATION_IP);
        if (BlojsomUtils.checkNullOrBlank((String)this._macroConfiguration)) {
            throw new BlojsomPluginException("No value given for: plugin-macros-expansion configuration parameter");
        }
    }

    private String replaceMacros(String content, Map macros) {
        if (BlojsomUtils.checkNullOrBlank((String)content)) {
            return content;
        }
        Pattern macroPattern = Pattern.compile(MACRO_REGEX);
        Matcher matcher = macroPattern.matcher(content);
        while (matcher.find()) {
            String token = matcher.group();
            String macro = token.substring(1, token.length() - 1);
            if (!macros.containsKey(macro)) continue;
            content = BlojsomUtils.replace((String)content, (String)token, (String)((String)macros.get(macro)));
        }
        return content;
    }

    private Map readMacros(String userId, String macroConfiguration) throws BlojsomPluginException {
        Map macros = new HashMap();
        BlojsomProperties macroProperties = new BlojsomProperties();
        String configurationFile = this._blojsomConfiguration.getBaseConfigurationDirectory() + userId + '/' + macroConfiguration;
        InputStream is = this._servletConfig.getServletContext().getResourceAsStream(configurationFile);
        if (is == null) {
            this._logger.info((Object)("No macro configuration file found: " + configurationFile));
        } else {
            try {
                macroProperties.load(is);
                is.close();
                macros = BlojsomUtils.propertiesToMap((Properties)macroProperties);
            }
            catch (IOException e) {
                this._logger.error((Object)e);
                throw new BlojsomPluginException((Throwable)e);
            }
        }
        return macros;
    }

    public BlogEntry[] process(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, BlogUser user, Map context, BlogEntry[] entries) throws BlojsomPluginException {
        String userId = user.getId();
        Map macros = this.readMacros(userId, this._macroConfiguration);
        for (int i = 0; i < entries.length; ++i) {
            BlogEntry entry = entries[i];
            entry.setTitle(this.replaceMacros(entry.getTitle(), macros));
            entry.setDescription(this.replaceMacros(entry.getDescription(), macros));
        }
        return entries;
    }

    public void cleanup() throws BlojsomPluginException {
    }

    public void destroy() throws BlojsomPluginException {
    }
}

