/*
 * Decompiled with CFR 0.152.
 */
package org.blojsom.plugin.markup;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.blojsom.blog.BlogEntry;
import org.blojsom.blog.BlogUser;
import org.blojsom.blog.BlojsomConfiguration;
import org.blojsom.event.BlojsomEvent;
import org.blojsom.event.BlojsomListener;
import org.blojsom.plugin.BlojsomPlugin;
import org.blojsom.plugin.BlojsomPluginException;
import org.blojsom.plugin.admin.event.ProcessBlogEntryEvent;
import org.blojsom.util.BlojsomUtils;

public class MarkupSelectionPlugin
implements BlojsomPlugin,
BlojsomListener {
    private Log _logger = LogFactory.getLog((Class)MarkupSelectionPlugin.class);
    private static final String PLUGIN_MARKUP_SELECTION_IP = "plugin-markup-selection";
    private static final String BLOJSOM_PLUGIN_MARKUP_SELECTIONS = "BLOJSOM_PLUGIN_MARKUP_SELECTIONS";
    private static final String MARKUP_SELECTION_TEMPLATE = "org/blojsom/plugin/markup/templates/admin-markup-selection-attachment.vm";
    private static final String MARKUP_SELECTIONS = "markup-selections";
    private Map _markupSelections;

    public void init(ServletConfig servletConfig, BlojsomConfiguration blojsomConfiguration) throws BlojsomPluginException {
        blojsomConfiguration.getEventBroadcaster().addListener((BlojsomListener)this);
        String markupSelection = servletConfig.getInitParameter(PLUGIN_MARKUP_SELECTION_IP);
        this._markupSelections = new TreeMap();
        if (!BlojsomUtils.checkNullOrBlank((String)markupSelection)) {
            String[] markupTypes = BlojsomUtils.parseCommaList((String)markupSelection);
            for (int i = 0; i < markupTypes.length; ++i) {
                String markupType = markupTypes[i];
                String[] markupNameAndKey = BlojsomUtils.parseDelimitedList((String)markupType, (String)":");
                if (markupNameAndKey == null || markupNameAndKey.length != 2) continue;
                this._markupSelections.put(markupNameAndKey[0], markupNameAndKey[1]);
                this._logger.debug((Object)("Added markup type and key: " + markupNameAndKey[0] + ":" + markupNameAndKey[1]));
            }
        }
        this._logger.debug((Object)"Initialized markup selection plugin");
    }

    public BlogEntry[] process(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, BlogUser user, Map context, BlogEntry[] entries) throws BlojsomPluginException {
        return entries;
    }

    public void cleanup() throws BlojsomPluginException {
    }

    public void destroy() throws BlojsomPluginException {
    }

    public void handleEvent(BlojsomEvent event) {
    }

    public void processEvent(BlojsomEvent event) {
        if (event instanceof ProcessBlogEntryEvent) {
            this._logger.debug((Object)"Handling process blog entry event");
            if (!this._markupSelections.isEmpty()) {
                ProcessBlogEntryEvent processBlogEntryEvent = (ProcessBlogEntryEvent)event;
                TreeMap<String, String> templateAdditions = (TreeMap<String, String>)processBlogEntryEvent.getContext().get("BLOJSOM_TEMPLATE_ADDITIONS");
                if (templateAdditions == null) {
                    templateAdditions = new TreeMap<String, String>();
                }
                templateAdditions.put(this.getClass().getName(), "#parse('org/blojsom/plugin/markup/templates/admin-markup-selection-attachment.vm')");
                processBlogEntryEvent.getContext().put("BLOJSOM_TEMPLATE_ADDITIONS", templateAdditions);
                processBlogEntryEvent.getContext().put(BLOJSOM_PLUGIN_MARKUP_SELECTIONS, Collections.unmodifiableMap(this._markupSelections));
                String[] markupSelections = processBlogEntryEvent.getHttpServletRequest().getParameterValues(MARKUP_SELECTIONS);
                BlogEntry entry = processBlogEntryEvent.getBlogEntry();
                if (markupSelections != null && markupSelections.length > 0) {
                    if (markupSelections.length == 1 && "".equals(markupSelections[0])) {
                        Iterator markupSelectionsIterator = this._markupSelections.values().iterator();
                        while (markupSelectionsIterator.hasNext()) {
                            entry.getMetaData().remove(markupSelectionsIterator.next().toString());
                        }
                    } else {
                        for (int i = 0; i < markupSelections.length; ++i) {
                            String markupSelection = markupSelections[i];
                            entry.getMetaData().put(markupSelection, Boolean.TRUE.toString());
                        }
                    }
                }
            } else {
                this._logger.debug((Object)"No markup selections available");
            }
        }
    }
}

