/*
 * Decompiled with CFR 0.152.
 */
package org.blojsom.plugin.moblog;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.ConnectException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.NoSuchProviderException;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMultipart;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.blojsom.BlojsomException;
import org.blojsom.blog.Blog;
import org.blojsom.blog.BlogEntry;
import org.blojsom.blog.BlogUser;
import org.blojsom.blog.BlojsomConfiguration;
import org.blojsom.event.BlojsomEvent;
import org.blojsom.fetcher.BlojsomFetcher;
import org.blojsom.fetcher.BlojsomFetcherException;
import org.blojsom.plugin.BlojsomPluginException;
import org.blojsom.plugin.admin.event.AddBlogEntryEvent;
import org.blojsom.plugin.email.EmailConstants;
import org.blojsom.plugin.email.SimpleAuthenticator;
import org.blojsom.plugin.moblog.Mailbox;
import org.blojsom.plugin.moblog.MoblogPluginUtils;
import org.blojsom.plugin.velocity.StandaloneVelocityPlugin;
import org.blojsom.util.BlojsomConstants;
import org.blojsom.util.BlojsomUtils;

public class MoblogPlugin
extends StandaloneVelocityPlugin
implements EmailConstants {
    private Log _logger = LogFactory.getLog((Class)MoblogPlugin.class);
    private static final String MOBLOG_ENTRY_TEMPLATE = "org/blojsom/plugin/moblog/moblog-plugin-template.vm";
    private static final String MOBLOG_SUBJECT = "MOBLOG_SUBJECT";
    private static final String MOBLOG_BODY_TEXT = "MOBLOG_BODY_TEXT";
    private static final String MOBLOG_IMAGES = "MOBLOG_IMAGES";
    private static final String MOBLOG_ATTACHMENTS = "MOBLOG_ATTACHMENTS";
    private static final String MOBLOG_ATTACHMENT = "MOBLOG_ATTACHMENT";
    private static final String MOBLOG_ATTACHMENT_URL = "MOBLOG_ATTACHMENT_URL";
    private static final String MOBLOG_IMAGE = "MOBLOG_IMAGE";
    private static final String MOBLOG_IMAGE_URL = "MOBLOG_IMAGE_URL";
    private static final String MULTIPART_ALTERNATIVE_MIME_TYPE = "multipart/alternative";
    private static final String TEXT_HTML_MIME_TYPE = "text/html";
    public static final String DEFAULT_TEXT_MIME_TYPES = "text/plain, text/html";
    public static final String DEFAULT_IMAGE_MIME_TYPES = "image/jpg, image/jpeg, image/gif, image/png";
    private static final String MULTIPART_TYPE = "multipart/*";
    private static final String DEFAULT_MESSAGE_STORE = "pop3";
    private static final int DEFAULT_POLL_TIME = 720;
    public static final String PLUGIN_MOBLOG_CONFIGURATION_IP = "plugin-moblog";
    public static final String PLUGIN_MOBLOG_POLL_TIME = "plugin-moblog-poll-time";
    public static final String PLUGIN_MOBLOG_STORE_PROVIDER = "plugin-moblog-store-provider";
    public static final String DEFAULT_MOBLOG_AUTHORIZATION_FILE = "moblog-authorization.properties";
    public static final String PROPERTY_AUTHORIZATION = "moblog-authorization";
    public static final String PROPERTY_HOSTNAME = "moblog-hostname";
    public static final String PROPERTY_USERID = "moblog-userid";
    public static final String PROPERTY_PASSWORD = "moblog-password";
    public static final String PROPERTY_CATEGORY = "moblog-category";
    public static final String PROPERTY_ENABLED = "moblog-enabled";
    public static final String PLUGIN_MOBLOG_SECRET_WORD = "moblog-secret-word";
    public static final String PLUGIN_MOBLOG_IMAGE_MIME_TYPES = "moblog-image-mime-types";
    public static final String PLUGIN_MOBLOG_ATTACHMENT_MIME_TYPES = "moblog-attachment-mime-types";
    public static final String PLUGIN_MOBLOG_TEXT_MIME_TYPES = "moblog-text-mime-types";
    public static final String PLUGIN_MOBLOG_IGNORE_EXPRESSION = "moblog-ignore-expression";
    private int _pollTime;
    private Session _storeSession;
    private boolean _finished = false;
    private MailboxChecker _checker;
    private ServletConfig _servletConfig;
    private BlojsomConfiguration _blojsomConfiguration;
    private String _storeProvider;
    private BlojsomFetcher _fetcher;

    public void init(ServletConfig servletConfig, BlojsomConfiguration blojsomConfiguration) throws BlojsomPluginException {
        super.init(servletConfig, blojsomConfiguration);
        String fetcherClassName = blojsomConfiguration.getFetcherClass();
        try {
            Class<?> fetcherClass = Class.forName(fetcherClassName);
            this._fetcher = (BlojsomFetcher)fetcherClass.newInstance();
            this._fetcher.init(servletConfig, blojsomConfiguration);
            this._logger.info((Object)("Added blojsom fetcher: " + fetcherClassName));
        }
        catch (ClassNotFoundException e) {
            this._logger.error((Object)e);
            throw new BlojsomPluginException((Throwable)e);
        }
        catch (InstantiationException e) {
            this._logger.error((Object)e);
            throw new BlojsomPluginException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            this._logger.error((Object)e);
            throw new BlojsomPluginException((Throwable)e);
        }
        catch (BlojsomFetcherException e) {
            this._logger.error((Object)e);
            throw new BlojsomPluginException((Throwable)e);
        }
        String moblogPollTime = servletConfig.getInitParameter(PLUGIN_MOBLOG_POLL_TIME);
        if (BlojsomUtils.checkNullOrBlank((String)moblogPollTime)) {
            this._pollTime = 720;
        } else {
            try {
                this._pollTime = Integer.parseInt(moblogPollTime);
            }
            catch (NumberFormatException e) {
                this._logger.error((Object)"Invalid time specified for: plugin-moblog-poll-time");
                this._pollTime = 720;
            }
        }
        this._storeProvider = servletConfig.getInitParameter(PLUGIN_MOBLOG_STORE_PROVIDER);
        if (BlojsomUtils.checkNullOrBlank((String)this._storeProvider)) {
            this._storeProvider = DEFAULT_MESSAGE_STORE;
        }
        this._servletConfig = servletConfig;
        this._blojsomConfiguration = blojsomConfiguration;
        this._checker = new MailboxChecker();
        this._checker.setDaemon(true);
        String hostname = servletConfig.getInitParameter("smtp-server");
        if (hostname != null) {
            if (hostname.startsWith("java:comp/env")) {
                try {
                    InitialContext context = new InitialContext();
                    this._storeSession = (Session)context.lookup(hostname);
                }
                catch (NamingException e) {
                    this._logger.error((Object)e);
                    throw new BlojsomPluginException((Throwable)e);
                }
            } else {
                String username = servletConfig.getInitParameter("smtp-server-username");
                String password = servletConfig.getInitParameter("smtp-server-password");
                Properties props = new Properties();
                props.put("mail.smtp.host", hostname);
                this._storeSession = BlojsomUtils.checkNullOrBlank((String)username) || BlojsomUtils.checkNullOrBlank((String)password) ? Session.getInstance((Properties)props, null) : Session.getInstance((Properties)props, (Authenticator)new SimpleAuthenticator(username, password));
            }
        }
        this._checker.start();
        this._logger.debug((Object)"Initialized moblog plugin.");
    }

    public BlogEntry[] process(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, BlogUser user, Map context, BlogEntry[] entries) throws BlojsomPluginException {
        return entries;
    }

    public void cleanup() throws BlojsomPluginException {
    }

    public void destroy() throws BlojsomPluginException {
        this._finished = true;
    }

    protected File getBlogCategoryDirectory(Blog blog, String categoryName) {
        File blogCategory = new File(blog.getBlogHome() + BlojsomUtils.removeInitialSlash((String)categoryName));
        if (blogCategory.exists() && blogCategory.isDirectory()) {
            return blogCategory;
        }
        return new File(blog.getBlogHome() + "/");
    }

    protected String sanitizeContentType(String contentType) {
        int semicolonIndex = contentType.indexOf(";");
        if (semicolonIndex != -1) {
            return contentType.substring(0, semicolonIndex);
        }
        return contentType.toLowerCase();
    }

    private class MailboxChecker
    extends Thread {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processMailbox(Mailbox mailbox) {
            Folder folder = null;
            Store store = null;
            String subject = null;
            try {
                store = MoblogPlugin.this._storeSession.getStore(MoblogPlugin.this._storeProvider);
                store.connect(mailbox.getHostName(), mailbox.getUserId(), mailbox.getPassword());
                folder = store.getDefaultFolder();
                if (folder == null) {
                    MoblogPlugin.this._logger.error((Object)"Default folder is null.");
                    MoblogPlugin.this._finished = true;
                }
                if ((folder = folder.getFolder(mailbox.getFolder())) == null) {
                    MoblogPlugin.this._logger.error((Object)("No POP3 folder called " + mailbox.getFolder()));
                    MoblogPlugin.this._finished = true;
                }
                folder.open(2);
                Message[] msgs = folder.getMessages();
                MoblogPlugin.this._logger.debug((Object)("Found [" + msgs.length + "] messages"));
                for (int msgNum = 0; msgNum < msgs.length; ++msgNum) {
                    int closingIndex;
                    int startIndex;
                    String from = ((InternetAddress)msgs[msgNum].getFrom()[0]).getAddress();
                    MoblogPlugin.this._logger.debug((Object)("Processing message: " + msgNum));
                    if (!this.checkSender(mailbox, from)) {
                        MoblogPlugin.this._logger.debug((Object)("Unauthorized sender address: " + from));
                        MoblogPlugin.this._logger.debug((Object)("Deleting message: " + msgNum));
                        msgs[msgNum].setFlag(Flags.Flag.DELETED, true);
                        continue;
                    }
                    Message email = msgs[msgNum];
                    subject = email.getSubject();
                    StringBuffer description = new StringBuffer();
                    Message messagePart = email;
                    Pattern pattern = null;
                    ArrayList moblogImages = new ArrayList();
                    ArrayList moblogAttachments = new ArrayList();
                    HashMap<String, Object> moblogContext = new HashMap<String, Object>();
                    if (mailbox.getIgnoreExpression() != null) {
                        pattern = Pattern.compile(mailbox.getIgnoreExpression(), 106);
                    }
                    subject = subject == null ? "" : subject.trim();
                    String secretWord = mailbox.getSecretWord();
                    if (secretWord != null) {
                        if (!subject.startsWith(secretWord)) {
                            MoblogPlugin.this._logger.error((Object)("Message does not begin with secret word for user id: " + mailbox.getUserId()));
                            msgs[msgNum].setFlag(Flags.Flag.DELETED, true);
                            continue;
                        }
                        subject = subject.substring(secretWord.length());
                    }
                    if (email.isMimeType(MoblogPlugin.MULTIPART_TYPE)) {
                        String overallType = email.getContentType();
                        overallType = MoblogPlugin.this.sanitizeContentType(overallType);
                        boolean isMultipartAlternative = false;
                        if (MoblogPlugin.MULTIPART_ALTERNATIVE_MIME_TYPE.equals(overallType)) {
                            isMultipartAlternative = true;
                        }
                        Multipart mp = (Multipart)messagePart.getContent();
                        int count = mp.getCount();
                        for (int i = 0; i < count; ++i) {
                            BodyPart bp = mp.getBodyPart(i);
                            String type = bp.getContentType();
                            if (type != null) {
                                String extension;
                                String outputFilename;
                                type = MoblogPlugin.this.sanitizeContentType(type);
                                Map imageMimeTypes = mailbox.getImageMimeTypes();
                                Map attachmentMimeTypes = mailbox.getAttachmentMimeTypes();
                                Map textMimeTypes = mailbox.getTextMimeTypes();
                                if (MoblogPlugin.MULTIPART_ALTERNATIVE_MIME_TYPE.equals(type)) {
                                    Object mimeMultipartContent = bp.getContent();
                                    if (mimeMultipartContent instanceof MimeMultipart) {
                                        MimeMultipart mimeMultipart = (MimeMultipart)mimeMultipartContent;
                                        int mimeMultipartCount = mimeMultipart.getCount();
                                        for (int j = 0; j < mimeMultipartCount; ++j) {
                                            BodyPart mimeMultipartBodyPart = mimeMultipart.getBodyPart(j);
                                            String mmpbpType = mimeMultipartBodyPart.getContentType();
                                            if (mmpbpType != null) {
                                                if (MoblogPlugin.TEXT_HTML_MIME_TYPE.equals(mmpbpType = MoblogPlugin.this.sanitizeContentType(mmpbpType))) {
                                                    String thisLine;
                                                    MoblogPlugin.this._logger.debug((Object)("Using HTML part of multipart/alternative: " + type));
                                                    InputStream is = bp.getInputStream();
                                                    BufferedReader reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                                                    while ((thisLine = reader.readLine()) != null) {
                                                        description.append(thisLine);
                                                        description.append(BlojsomConstants.LINE_SEPARATOR);
                                                    }
                                                    reader.close();
                                                    if (pattern != null) {
                                                        Matcher matcher = pattern.matcher(description);
                                                        if (matcher.find() || matcher.matches()) continue;
                                                        moblogContext.put(MoblogPlugin.MOBLOG_BODY_TEXT, description.toString());
                                                        continue;
                                                    }
                                                    moblogContext.put(MoblogPlugin.MOBLOG_BODY_TEXT, description.toString());
                                                    continue;
                                                }
                                                MoblogPlugin.this._logger.debug((Object)"Skipping non-HTML part of multipart/alternative block");
                                                continue;
                                            }
                                            MoblogPlugin.this._logger.info((Object)"Unknown mimetype for multipart/alternative block");
                                        }
                                        continue;
                                    }
                                    MoblogPlugin.this._logger.debug((Object)"Multipart alternative block not instance of MimeMultipart");
                                    continue;
                                }
                                if (imageMimeTypes.containsKey(type)) {
                                    MoblogPlugin.this._logger.debug((Object)("Creating image of type: " + type));
                                    outputFilename = BlojsomUtils.digestString((String)(bp.getFileName() + "-" + new Date().getTime()));
                                    extension = BlojsomUtils.getFileExtension((String)bp.getFileName());
                                    if (BlojsomUtils.checkNullOrBlank((String)extension)) {
                                        extension = "";
                                    }
                                    MoblogPlugin.this._logger.debug((Object)("Writing to: " + mailbox.getOutputDirectory() + File.separator + outputFilename + "." + extension));
                                    MoblogPluginUtils.saveFile(mailbox.getOutputDirectory() + File.separator + outputFilename, "." + extension, bp.getInputStream());
                                    String baseurl = mailbox.getBlogUser().getBlog().getBlogBaseURL();
                                    HashMap<String, String> moblogImageInformation = new HashMap<String, String>();
                                    moblogImageInformation.put(MoblogPlugin.MOBLOG_IMAGE, new String(outputFilename + "." + extension));
                                    moblogImageInformation.put(MoblogPlugin.MOBLOG_IMAGE_URL, new String(baseurl + mailbox.getUrlPrefix() + outputFilename + "." + extension));
                                    moblogImages.add(moblogImageInformation);
                                    continue;
                                }
                                if (attachmentMimeTypes.containsKey(type)) {
                                    MoblogPlugin.this._logger.debug((Object)("Creating attachment of type: " + type));
                                    outputFilename = BlojsomUtils.digestString((String)(bp.getFileName() + "-" + new Date().getTime()));
                                    extension = BlojsomUtils.getFileExtension((String)bp.getFileName());
                                    if (BlojsomUtils.checkNullOrBlank((String)extension)) {
                                        extension = "";
                                    }
                                    MoblogPlugin.this._logger.debug((Object)("Writing to: " + mailbox.getOutputDirectory() + File.separator + outputFilename + "." + extension));
                                    MoblogPluginUtils.saveFile(mailbox.getOutputDirectory() + File.separator + outputFilename, "." + extension, bp.getInputStream());
                                    String baseurl = mailbox.getBlogUser().getBlog().getBlogBaseURL();
                                    HashMap<String, String> moblogAttachmentInformation = new HashMap<String, String>();
                                    moblogAttachmentInformation.put(MoblogPlugin.MOBLOG_ATTACHMENT, bp.getFileName());
                                    moblogAttachmentInformation.put(MoblogPlugin.MOBLOG_ATTACHMENT_URL, new String(baseurl + mailbox.getUrlPrefix() + outputFilename + "." + extension));
                                    moblogAttachments.add(moblogAttachmentInformation);
                                    continue;
                                }
                                if (textMimeTypes.containsKey(type)) {
                                    String thisLine;
                                    if ((!isMultipartAlternative || !MoblogPlugin.TEXT_HTML_MIME_TYPE.equals(type)) && isMultipartAlternative) continue;
                                    MoblogPlugin.this._logger.debug((Object)("Using text part of type: " + type));
                                    InputStream is = bp.getInputStream();
                                    BufferedReader reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                                    while ((thisLine = reader.readLine()) != null) {
                                        description.append(thisLine);
                                        description.append(BlojsomConstants.LINE_SEPARATOR);
                                    }
                                    reader.close();
                                    if (pattern != null) {
                                        Matcher matcher = pattern.matcher(description);
                                        if (matcher.find() || matcher.matches()) continue;
                                        moblogContext.put(MoblogPlugin.MOBLOG_BODY_TEXT, description.toString());
                                        continue;
                                    }
                                    moblogContext.put(MoblogPlugin.MOBLOG_BODY_TEXT, description.toString());
                                    continue;
                                }
                                MoblogPlugin.this._logger.info((Object)("Unknown mimetype for multipart: " + type));
                                continue;
                            }
                            MoblogPlugin.this._logger.debug((Object)"Body part has no defined mime type. Skipping.");
                        }
                    } else {
                        Map textMimeTypes = mailbox.getTextMimeTypes();
                        String mimeType = email.getContentType();
                        if (mimeType != null) {
                            mimeType = MoblogPlugin.this.sanitizeContentType(mimeType);
                        }
                        if (mimeType != null && textMimeTypes.containsKey(mimeType)) {
                            String thisLine;
                            InputStream is = email.getInputStream();
                            BufferedReader reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                            while ((thisLine = reader.readLine()) != null) {
                                description.append(thisLine);
                                description.append(BlojsomConstants.LINE_SEPARATOR);
                            }
                            reader.close();
                            if (pattern != null) {
                                Matcher matcher = pattern.matcher(description);
                                if (!matcher.find() && !matcher.matches()) {
                                    moblogContext.put(MoblogPlugin.MOBLOG_BODY_TEXT, description.toString());
                                }
                            } else {
                                moblogContext.put(MoblogPlugin.MOBLOG_BODY_TEXT, description.toString());
                            }
                        } else {
                            MoblogPlugin.this._logger.info((Object)("Unknown mimetype: " + mimeType));
                        }
                    }
                    boolean categoryInSubject = false;
                    String categoryFromSubject = null;
                    if (subject.startsWith("[") && (startIndex = subject.indexOf("[")) != -1 && (closingIndex = subject.indexOf("]", startIndex)) != -1) {
                        categoryFromSubject = subject.substring(startIndex + 1, closingIndex);
                        subject = subject.substring(closingIndex + 1);
                        if (!(categoryFromSubject = BlojsomUtils.normalize((String)categoryFromSubject)).startsWith("/")) {
                            categoryFromSubject = "/" + categoryFromSubject;
                        }
                        if (!categoryFromSubject.endsWith("/")) {
                            categoryFromSubject = categoryFromSubject + "/";
                        }
                        categoryInSubject = true;
                        MoblogPlugin.this._logger.info((Object)("Using category [" + categoryFromSubject + "] for entry: " + subject));
                    }
                    BlogUser blogUser = mailbox.getBlogUser();
                    String categoryName = categoryInSubject ? categoryFromSubject : mailbox.getCategoryName();
                    File blogCategory = MoblogPlugin.this.getBlogCategoryDirectory(blogUser.getBlog(), categoryName);
                    if (!blogCategory.exists() || !blogCategory.isDirectory()) continue;
                    moblogContext.put(MoblogPlugin.MOBLOG_SUBJECT, subject);
                    moblogContext.put(MoblogPlugin.MOBLOG_IMAGES, moblogImages);
                    moblogContext.put(MoblogPlugin.MOBLOG_ATTACHMENTS, moblogAttachments);
                    String moblogText = MoblogPlugin.this.mergeTemplate(MoblogPlugin.MOBLOG_ENTRY_TEMPLATE, blogUser, moblogContext);
                    try {
                        BlogEntry blogEntry = MoblogPlugin.this._fetcher.newBlogEntry();
                        HashMap<String, String> blogEntryMetaData = new HashMap<String, String>();
                        blogEntry.setTitle(subject);
                        blogEntry.setCategory(categoryName);
                        blogEntry.setDescription(moblogText);
                        blogEntryMetaData.put("blog-entry-metadata-timestamp", new Long(new Date().getTime()).toString());
                        blogEntryMetaData.put("blog-entry-author-ext", from);
                        blogEntry.setMetaData(blogEntryMetaData);
                        blogEntry.save(mailbox.getBlogUser());
                        blogEntry.load(mailbox.getBlogUser());
                        msgs[msgNum].setFlag(Flags.Flag.DELETED, true);
                        MoblogPlugin.this._blojsomConfiguration.getEventBroadcaster().broadcastEvent((BlojsomEvent)new AddBlogEntryEvent(this, new Date(), blogEntry, mailbox.getBlogUser()));
                        continue;
                    }
                    catch (BlojsomException e) {
                        MoblogPlugin.this._logger.error((Object)e);
                    }
                }
                try {
                    if (folder != null) {
                        folder.close(true);
                    }
                    if (store != null) {
                        store.close();
                    }
                }
                catch (MessagingException e) {
                    MoblogPlugin.this._logger.error((Object)e);
                }
            }
            catch (ConnectException e) {
                MoblogPlugin.this._logger.error((Object)e);
            }
            catch (NoSuchProviderException e) {
                MoblogPlugin.this._logger.error((Object)e);
            }
            catch (MessagingException e) {
                MoblogPlugin.this._logger.error((Object)e);
            }
            catch (IOException e) {
                MoblogPlugin.this._logger.error((Object)e);
            }
            finally {
                try {
                    if (folder != null && folder.isOpen()) {
                        folder.close(true);
                    }
                    if (store != null) {
                        store.close();
                    }
                }
                catch (MessagingException e) {
                    MoblogPlugin.this._logger.error((Object)e);
                }
            }
        }

        public void run() {
            try {
                while (!MoblogPlugin.this._finished) {
                    MoblogPlugin.this._logger.debug((Object)"Moblog plugin waking up and looking for new messages");
                    String[] users = MoblogPlugin.this._blojsomConfiguration.getBlojsomUsers();
                    for (int i = 0; i < users.length; ++i) {
                        String user = users[i];
                        BlogUser blogUser = null;
                        try {
                            blogUser = MoblogPlugin.this._blojsomConfiguration.loadBlog(user);
                            Mailbox mailbox = MoblogPluginUtils.readMailboxSettingsForUser(MoblogPlugin.this._blojsomConfiguration, MoblogPlugin.this._servletConfig, blogUser);
                            if (mailbox == null || !mailbox.isEnabled()) continue;
                            MoblogPlugin.this._logger.debug((Object)("Checking mailbox: " + mailbox.getUserId() + " for user: " + mailbox.getBlogUser().getId()));
                            this.processMailbox(mailbox);
                            continue;
                        }
                        catch (BlojsomException e) {
                            MoblogPlugin.this._logger.error((Object)e);
                        }
                    }
                    MoblogPlugin.this._logger.debug((Object)"Moblog plugin off to take a nap");
                    MailboxChecker.sleep(MoblogPlugin.this._pollTime * 1000);
                }
            }
            catch (InterruptedException e) {
                MoblogPlugin.this._logger.error((Object)e);
            }
        }

        private boolean checkSender(Mailbox mailbox, String fromAddress) {
            boolean result = false;
            Map authorizedAddresses = mailbox.getAuthorizedAddresses();
            if (authorizedAddresses.containsKey(fromAddress)) {
                result = true;
            }
            return result;
        }
    }
}

